/*
 * debug.h -- my debug header for just any program.
 * use:
 * place the statement OPENDEBUG("/tmp/programdebug"); inside main.
 * nothing will happen, unless you compile the source with -DDEBUG
 * 
 * jw. 13.4.91.
 * jw. 11.7.96.	more braces.
 * jw. 14.1.97. OPENDEBUG now always initializes debugfilename
 */
#ifndef FILE
# include <stdio.h>
#endif

#ifdef DEBUG
# define debug(x)		\
  { if (debugfp) { fprintf(debugfp, (x));                fflush(debugfp); } }
# define debug1(x,a)		\
  { if (debugfp) { fprintf(debugfp, (x), (a));           fflush(debugfp); } }
# define debug2(x,a,b)		\
  { if (debugfp) { fprintf(debugfp, (x), (a), (b));      fflush(debugfp); } }
# define debug3(x,a,b,c)	\
  { if (debugfp) { fprintf(debugfp, (x), (a), (b), (c)); fflush(debugfp); } }
# define OPENDEBUG(file)					\
  { 								\
    if (debugfilename) free(debugfilename);			\
    debugfilename = strdup(file);				\
    if ((debugfp = fopen((file), "a")) == NULL) 		\
      { 							\
	debugfp = stderr; 					\
	debug1("OPENDEBUG: sorry, cannot open '%s'\n", (file));	\
	debug("           beware, using stderr!\n"); 		\
      } 							\
  }
extern FILE *debugfp;
extern char *debugfilename;
#else
# define debug(x)		{;}
# define debug1(x,a)		{;}
# define debug2(x,a,b)		{;}
# define debug3(x,a,b,c)	{;}
# define OPENDEBUG(f)		{;}
#endif

#undef NOASSERT

#ifndef ASSERT
# ifndef NOASSERT
#  if defined(__STDC__)
#   define ASSERT(lousy_cpp) {if (lousy_cpp) ; else {debug2("ASSERT("#lousy_cpp") failed file %s line %d\n", __FILE__, __LINE__);abort();}}
#  else
#   define ASSERT(lousy_cpp) {if (lousy_cpp) ; else {debug2("ASSERT(lousy_cpp) failed file %s line %d\n", __FILE__, __LINE__);abort();}}
#  endif
# else
#  define ASSERT(lousy_cpp) {;}
# endif
#endif
