#ifndef _HAVE_DSTRING_H
#define _HAVE_DSTRING_H
/*
 * dstring.h -- declarations & potatotypes
 *
 * Added dstring based error reporting macros ERR, ERRNL, ERRRET.
 * 27.12.95 jw.
 */
#include <stdio.h>	/* for detecting SOLARIS */
#include <string.h>	/* memmove(), stdrup(), bcopy()... @solaris */
#include <stdlib.h>	/* for calloc() and free() */
#include "jittr/debug.h"	/* for ASSERT() macro, needed by everybody */

#if defined(__sun) && !defined(FILE) && !defined(SOLARIS)
# define SOLARIS
#endif

#ifndef __P
# ifdef __STDC__
#  define __P(a) a
# else
#  define __P(a) ()
# endif
#endif

/* we need a bcopy that handles overlapping strings correctly */
#ifdef sun
# ifndef FILE
#  define index strchr
# endif
# ifndef SOLARIS
int bcopy();
int bcmp();
#  define xbcopy(s,d,l) bcopy(s,d,l)
#  define xbcmp(a,b,c) bcmp(a,b,c)
#  ifdef __STDC__
#   include "sun_stdlib.h"
#  endif
# endif
#endif

#if defined(SOLARIS) || defined(__sgi)
# define xbcopy(s,d,l) memmove(d,s,l)
# define xbcmp(a,b,c) memcmp(a,b,c)
#endif

#ifndef xbcopy
/* here we assume that our bcopy handles overlapping strings. E.g. Linux */
# define xbcopy(s, d, l) bcopy(s, d, l)
# define xbcmp(a,b,c) bcmp(a,b,c)
#endif

typedef struct dstring
{ 
  int length;		/* # of valid bytes. buf[length] = 0; */
  int allocated;	/* # of allcoated bytes behind the structure */
  void *data;		/* a private pointer, for parser states, etc. */
  char buf[1];		/* beginning of the buffer. extends further */
} dstring;

#define dstring_set(dsp, string, length) \
	dstring_append((dsp), 0, (string), (length))

/* 
 * A macro returning int cannot be inside the do { ... } while (0) construct.
 * Is this one equally save? May need (void)ERR(msg) cast to supress warnings.
 */
#define ERR(msg) (errp ? dstring_append(errp, -1, (msg), 0) : 0)

/* append an error message to dstring **errp and assure it ends in \n. */
#define ERRNL(msg) do {							\
  if (ERR((msg)) > 0 && (*errp)->buf[(*errp)->length - 1] != '\n')	\
    dstring_append(errp, -1, "\n", 1);					\
} while (0)

/* return -1 with message m because of errno n  */
#define ERRRET(n, m) do { ERRNL((m)); errno = n; if (m) return -1; } while (0)

#define ERRFMTRET(n, f, a1, a2, a3, a4) do {				\
  if (errp) dstring_appendf(errp, -1, (f), (a1), (a2), (a3), (a4));	\
  errno = n; if (f) return -1;						\
} while (0)


/* return nonzero, if p points inside the valid data area of d */
#define dstring_covers_pointer(d, p) 	\
  ((d) && ((p) >= (d)->buf) && ((p) <= ((d)->buf + (d)->length)))
/* measure the size of a (possibly nonexistant) dstring */
#define dstring_length(d) ((d) ? (d)->length : 0)

int dstring_append  __P((dstring **ds, int off, char *str, int len));
int dstring_appendq __P((dstring **ds, int off, char *str, int len));
int dstring_appendn __P((dstring **ds, int off, char *fmt, int n));
int dstring_appendg __P((dstring **ds, int off, char *fmt, double d));
int dstring_appendf __P((/* dstring **ds, int off, char *fmt, ... */));
#endif /* _HAVE_DSTRING_H */
