/*
 * openurl.h -- generic url resolver
 *
 * 29.4.97, jw.
 */

#ifndef __P
# ifdef __STDC__
#  define __P(a) a
# else
#  define __P(a) ()
# endif
#endif

#include <jittr/dstring.h>

#define DEFAULT_TIMEOUT 20	/* seconds hanging */

struct url_info 
{
  dstring *url;		/* chronik/index.html */
  dstring *base;	/* http://www4/~weigert/index.html */
  dstring *proto;	/* HTTP, FILE, FTP, unknown */
  dstring *host;	/* hostname used */
  dstring *path;	/* file path on server or error */
  dstring *mime;	/* mime type of url */
  dstring *name, *pass;	/* optional authentification */
  dstring *modified;	/* Last-Modified */
  dstring *date;	/* the server's clock */
  dstring *server;	/* Apache/1.2.5 */
  dstring *redirect;	/* location if 301/302 */
  int port;		/* port, -1 means unknown */
  int len;		/* file size, -1 means unknown */
  int mode;		/* O_RDONLY or O_WRONLY */
  int timeout;		/* seconds allowed for accept(), connect() and read() */
};

int OpenUrl __P((char *url, struct url_info *u, int mode));
void FreeUrlInfo __P((struct url_info *u));

int OpenUrl1 __P((struct url_info *u));
char *MimeTypeBySuffix __P((char *name));
int OpenUrlHttp __P((struct url_info *u));
int OpenUrlFtp  __P((struct url_info *u));
int OpenUrlFile __P((struct url_info *u));
/*
int AnchorFindHref __P((char *url, int fd, char **nam, int vlen, char **val, int blen));
*/
