/******************************************************/
/* PDecoderConfig.h                                   */
/*                                                    */
/******************************************************/

#ifndef _PDECODER_MAIN_H
#define _PDECODER_MAIN_H

#include "defs.h"

#define MAX_NAME_LENGTH 100
#define PACKET_SIZE     1024


/*************************************************************************/
/*                        Defaults for info struct                       */
/*************************************************************************/

/* Reed-Solomon packetization */
#define DEFAULT_PACKET_RS                                               OFF
#define DEFAULT_SHOW_PACKET_LOSS                                         ON

/* General configurations */
#define DEFAULT_DISPLAY_FORMAT                                           ON
#define DEFAULT_DISPLAY_SIZE                                            CIF
#define DEFAULT_WINDOWID                                                  0
#define DEFAULT_FRAMES_PER_SECOND                                         0
#define DEFAULT_TOP_LAYER                                                 0
#define DEFAULT_QUIET_FLAG                                                0
#define DEFAULT_LOOP                                                      0


/*************************************************************************/
/*                            Info struct                                */
/*************************************************************************/

typedef struct {

  /* General configurations */
  int displayFormat;
  int displaySize;
  long windowid;
  int fps;
  int topLayer;
  int quiet;
  int loop;

#ifndef WITHOUT_CHACODEC
  /* RS packetization */
  int prs;
  int showPckLoss;
#endif

} DecInfo;



#endif /* _PDECODER_MAIN_H */
