/******************************************************/
/* PCoderConfig.h                                     */
/*                                                    */
/******************************************************/

#ifndef _PCODER_MAIN_H
#define _PCODER_MAIN_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

#include "defs.h"
#include "structs.h"
#include "Util.h"
#include "bitOut.h"
#include "common.h"
#include "filter.p"
#include "Lattice.h"
#include "pyraencoder.h"
#include "pyracoder.p"
#include "h263/encoder/h263encoder.h"
#include "h263encoder.p"


/* Undefine definitions from config.h */
#ifdef DEFAULT_ORIG
#undef DEFAULT_ORIG
#endif
#ifdef DEFAULT_WIDTH_FRAME
#undef DEFAULT_WIDTH_FRAME
#endif
#ifdef DEFAULT_HEIGHT_FRAME
#undef DEFAULT_HEIGHT_FRAME
#endif
#ifdef DEFAULT_LAST_FRAME
#undef DEFAULT_LAST_FRAME
#endif


#define MAX_NAME_LENGTH 100


/*************************************************************************/
/*                        Defaults for info struct                       */
/*************************************************************************/

/* File specifications  */
#define DEFAULT_ORIG             "/net/nt36/cdrom/unnamed_cdrom/foreman/fm"
#define DEFAULT_BITSTREAM                                       "bitstream"
#define DEFAULT_BS_SUFFIX                                              NULL
#define DEFAULT_DISPLAY_FORMAT                                           ON
#define DEFAULT_PROT_FORMAT                                             OFF
#define DEFAULT_PROT                                                    "-"

/* Video frame specifications */ 
#define DEFAULT_WIDTH_FRAME                                       CIF_WIDTH
#define DEFAULT_HEIGHT_FRAME                                     CIF_HEIGHT
#define DEFAULT_FPS                                                      30

/* Encoder specifications */
#define DEFAULT_FIRST_FRAME                                               0
#define DEFAULT_LAST_FRAME                                              100
#define DEFAULT_RATE_CONTROL_FLAG                                       OFF

/* Coding speed */
#define DEFAULT_CODING_TIME                                               7

/* Layer specifications */
#define DEFAULT_METHOD_0                                               H263
#define DEFAULT_SCAL_TYPE                                                 0
#define DEFAULT_RATE_0                                                   -1
#define DEFAULT_QUANT_0                                                  15
#define DEFAULT_SIZE_DIV_0                                                1
#define DEFAULT_FREQ_DIV_0                                                1
#define DEFAULT_INTRA_FREQ_DIV_0                                          0
#define DEFAULT_START_OFFSET_0                                            0

/* Reed Solomon coding and paket multiplexing */
#define DEFAULT_RS_CODING_FLAG                                          OFF
#define DEFAULT_N_IL                                                     50
#define DEFAULT_BYTES_PER_PACKET                                        500
#define DEFAULT_K_IL                                                     30
#define DEFAULT_PCK_MODE                                                  0
#define DEFAULT_AWAIT_GOP                                               OFF
#define DEFAULT_PRS_FILENAME                                   "prs_stream"

/* General configurations */
#define DEFAULT_DEMO_FLAG                                               OFF
#define DEFAULT_QUIET_FLAG                                                0


/*************************************************************************/
/*                            Info struct                                */
/*************************************************************************/

typedef struct {
  /* File specifications  */
  char *orig;
  char *bitstream;
  char *bs_suffix;
  int bs_index[NUM_LAYERS];
  int displayFormat;
  int protFormat;
  char *prot;
  FILE *protFile;

  /* Video frame specifications */ 
  int widthFrame;
  int heightFrame;
  int fps;          /* Frames per second (for rate computation) */

  /* Encoder specifications */
  int firstFrame;
  int lastFrame;
  int rateControlFlag;

  /* Coding speed */
  int codingTime;

  /* Layer configuration */
  int method[NUM_LAYERS];
  int scalType[NUM_LAYERS];
  int rate[NUM_LAYERS];
  int qP[NUM_LAYERS];
  int qI[NUM_LAYERS];
  int sizeDiv[NUM_LAYERS];
  int freqDiv[NUM_LAYERS];
  int intraFreqDiv[NUM_LAYERS];
  int startOffset[NUM_LAYERS];

#ifndef WITHOUT_CHACODEC
  /* Reed Solomon coding and paket multiplexing */
  int prs;             /* Flag to switch on Reed Solomon coding */
  int nIl;             /* Number of lines in interleaver */
  int bytesPerPck;     /* Bytes per packet */
  int kIl[NUM_LAYERS]; /* Number of info lines per layer */
  int pckMode;         /* Packetization mode */
  int awaitGOP;        /* Await one complete GOP before packing */
  char *prsFilename;
#endif
  
  /* General configurations */
  int demoF;
  int quiet;

} EncInfo;



#endif /* _PCODER_MAIN_H */
