/* CodeBlock.c */
extern void InitBlockPyra(void);
extern int EncodePictDPCM(Picture *act, Picture *dec, Bitstr *bs);
extern void Code16x16IntraBlock(Picture *Actual, Picture *Decoded, int bx, int by, int scale1, int scale0, Bitstr *bs);
extern void Code16x16PredBlock(Picture *act_pict, Picture *pre_pict, Picture *dec_pict, int bx, int by, int scale, int layerMode, int mode, int mvx, int mvy, int lambda, Bitstr *bs);
extern int BlockMSE(int *b1, int *b2, int size);
extern void Code8x8PredBlock(Picture *act_pict, Picture *pre_pict, Picture *dec_pict, int bx, int by, int scale, int layerMode, int mode, int mvx, int mvy, Bitstr *bs);
/* Quantize.c */
extern void Get8x8MB(Picture *pic, int x, int y, BlockMemStruct *blk);
extern void Get16x16MB(Picture *pic, int x, int y, BlockMemStruct *blk);
extern void Put8x8MB(Picture *pic, int x, int y, BlockMemStruct *blk);
extern void Put16x16MB(Picture *pic, int x, int y, BlockMemStruct *blk);
extern void InitLatticeQuantizer(void);
extern void Quantize8x8MB(BlockMemStruct *act_blk, BlockMemStruct *pre_blk, int BScale, int CodingMode, CodedPatternStruct *block_patt);
extern void Send8x8MB(BlockMemStruct *dec_blk, BlockMemStruct *pre_blk, int BScale, int LayerMode, int CodingMode, CodedPatternStruct *block_patt, int mvx, int mvy, Bitstr *bs);
extern void Send8x8LowestIntraMB(BlockMemStruct *dec_blk, BlockMemStruct *pre_blk, int BScale, CodedPatternStruct *block_patt, Bitstr *bs);
extern void Quantize16x16MB(BlockMemStruct *act_blk, BlockMemStruct *pre_blk, int BScale, int CodingMode, CodedPatternStruct *block_patt);
extern void Send16x16MB(BlockMemStruct *dec_blk, BlockMemStruct *pre_blk, int BScale, int LayerMode, int CodingMode, int uncoded_f, CodedPatternStruct *block_patt, int mvx, int mvy, Bitstr *bs);
extern void Send16x16LowestIntraMB(BlockMemStruct *dec_blk, BlockMemStruct *pre_blk, int BScale, CodedPatternStruct *block_patt, Bitstr *bs);
/* Lattice.c */
extern void RecVect(int *dec, int *pre, float scale, LatticePointInfo *lpi, int mode);
extern int QuantizeVect(int *orig, int *pred, float scale, LatticePointInfo *lpi);
/* EncodeClass.c */
extern int ConvTab[64][8];
extern int SignType[64];
extern int CompBits[64];
extern int IndexHist[64+1];
extern int EvenSignHist[128];
extern int OddSignHist[128];
extern int AllSignHist[256];
extern Byte StructCB[64][8];
extern void PrintSignPattern(int sign);
extern void PrintIndexHist(void);
extern int FindCBIndex(float *v, int *sign, int *nsign);
extern int EncSign(int index, int sign, int nsign, Bitstr *bs);
extern int EncodeComponents(float v[8], int index, Bitstr *bs);
extern int EncodeExtVector(float v[8], int index, int sign, int nsign, Bitstr *bs);
extern void InitExtVectTables(void);
/* Encoding.c */
extern int CombSignHuffCodeTab[18];
extern int VCombHuffCodeTab[128];
extern int VMagHuffCodeTab[16];
extern int DiffHuffCodeTab[256];
extern int EvenSignHuffCodeTab[256];
extern int AllSignsHuffCodeTab[512];
extern int PPredTypeHuffCodeTab[8];
extern int IntraShellCombCHuffCodeTab[30];
extern int Shell1SPYHuffCodeTab[240];
extern int Shell1SPCHuffCodeTab[240];
extern int Shell2SPYHuffCodeTab[1600];
extern int Shell2SPCHuffCodeTab[1600];
extern int SPYClassHuffCodeTab[130];
extern int SPCClassHuffCodeTab[130];
extern int IntraCCPHuffCodeTab[14];
extern int IntraCCP6HuffCodeTab[126];
extern int InterCCP6HuffCodeTab[128];
extern int IntraCBPYHuffCodeTab[510];
extern int IntraCBPCHuffCodeTab[510];
extern int IntraShellCombYHuffCodeTab[30];
extern int InterCCPHuffCodeTab[16];
extern int InterCBPYHuffCodeTab[510];
extern int InterCBPCHuffCodeTab[510];
extern int InterShellCombCHuffCodeTab[30];
extern int InterShellCombYHuffCodeTab[30];
extern int TPYClassHuffCodeTab[130];
extern int TPCClassHuffCodeTab[130];
extern int Shell1TPYHuffCodeTab[240];
extern int Shell1TPCHuffCodeTab[240];
extern int Shell2TPYHuffCodeTab[1600];
extern int Shell2TPCHuffCodeTab[1600];
extern void PrintHuffCodeHistos(void);
extern void InitHuffTables(void);
extern void SendShell1Vect(LatticePointInfo *lpi, int mode, Bitstr *bs);
extern void SendShell2Vect(LatticePointInfo *lpi, int mode, Bitstr *bs);
extern int EncodeDiff(int val, Bitstr *bs);
extern void SendVect(LatticePointInfo *lpi, int mode, Bitstr *bs);
extern int PutAllSignsHuffCode(int val, Bitstr *bs);
extern int PutEvenSignHuffCode(int val, Bitstr *bs);
extern int PutCBP(int cbp, int mode, Bitstr *bs);
extern int PutCombShell(int comb_shell, int mode, Bitstr *bs);
extern int PutCCP(int ccp, int mode, Bitstr *bs);
extern int Put8x8CCP(int ccp, int mode, Bitstr *bs);
extern int PutMode(int mode, Bitstr *bs);
extern int PutMV(int mvx, int mvy, Bitstr *bs);
extern int EmitBits(int sym, int size, char *comment, Bitstr *bs);
/* pyraenc.c */
extern int CodePyraLayer(Picture *origPict, Picture *prevOrigPict, Picture *spatPredPict, Picture *tempPredPict, Byte *interpol[3], MVField mvIn, int rate, int codingType, int scalType, int gfid, int t, Bitstr *bs, Picture *decPict, MVField mvOut, int *mbInd, int baseLayer_f, int codingTime);
extern int CodePyraLayerQ(unsigned char *crvec, Picture *origPict, Picture *prevOrigPict, Picture *spatPredPict, Picture *tempPredPict, Byte *interpol[3], MVField mvIn, int q, int codingType, int scalType, int gfid, int t, Bitstr *bs, Picture *decPict, MVField mvOut, int *mbInd, int baseLayer_f, int codingTime);
extern int CodePyraLayerQIntra8x8(Picture *origPict, Picture *spatPredPict, int q, int gfid, int t, Bitstr *bs, Picture *decPict);
extern int PyraPutPictureHeader(int t, int ws, int hs, int codingType, int scalType, int q, Bitstr *bs);
extern int PyraPutGOBHeader(int nGOB, int gfid, int q, Bitstr *bs);
