#ifndef PYRA_H
#define PYRA_H

#include "bitIn.h"
#include "structs.h"
#include "Util.h"


typedef struct PyraGlobalStruct {
  Bitstream *bs;

  int first;

  int awaitIntra;
  int skip_until_next_tr;

  /* Flag if another layer has been received for this particular
     time instant */
  int baseLayerFlag;

  int temp_ref, prev_temp_ref, next_temp_ref;
  int trd;

  int ptype;
  int PicSize;
  int dSize;
  int PicType;
  int ScalType;
  int currScale;       /* = SCALE_MIN + SCALE_STEP * currQuant; */
  int currQuant;
  int GOBFrameID;
  int GOBNumber;

  unsigned char decGOBs[MAX_GOBS];
  int decGOBsCounter;
  int GOBs_in_pict;
  int MBs_in_GOB;
  int MB_rows_in_GOB;
  int MBs_in_row;

  int width;
  int height;
  int widthSub;
  int heightSub;

  /* Internal variables for VQ decoding */
  int Yrowbytes;
  int Crowbytes;

  int YRowOffset[8];
  int CRowOffset[8];
  int *CurrRowOffset;

  int Y4x4BlockOffset[16];
  int C4x4BlockOffset[4];

  /* Pointer to VQ codebooks */
  float *Shell1Codebook;
  float *Shell2Codebook;

  /* Pointer to appropriate Huffman codebooks */
  int (*GetClassHuffCode)(Bitstream *bs);
  int (*GetCBPHuffCode)(Bitstream *bs);
  int (*GetShellCombHuffCode)(Bitstream *bs);
  int (*GetShell1HuffCode)(Bitstream *bs);
  int (*GetShell2HuffCode)(Bitstream *bs);

  MVField mvf;

  Picture *SpatRefPic;
  Picture *TempRefPic;
  Picture *DecPic;

  Picture *BlockPyra[4]; /* Holds a block pyramid */

} PyraGlobal;


#include "pyradecoder.p"
#endif    /* #ifndef PYRA_H */
