#ifndef _MY_H263_H
#define _MY_H263_H
/*
 */

typedef struct h263streamheader { 
	unsigned int	syncword:17; 	/* must be 1 */
	unsigned int	gobnr:5;	/* must be 0 */
	unsigned int	tr:8;		/* temporal ref */
	/* ptype */
	
		unsigned int	reserved0:1;	/* must be 1 */
		unsigned int	reserved1:1;	/* must be 0 */

		unsigned int	splitscreen:1;
		unsigned int	doccamera:1;
		unsigned int	freeze_picture_release:1;
		unsigned int	srcformat:3;
		unsigned int	picture_coding_type:1;
		unsigned int	unrestricted_motion_vector:1;
		unsigned int	syntax_based_arithmetic:1;
		unsigned int	advanced_prediction:1;
		unsigned int	pb_frames:1;
	unsigned int	pquant:5;
	unsigned int	cpm:1;

	/* ... optional fields ... not used by this code ... */
	unsigned int	psbi:2;
	unsigned int	trb:3;
	unsigned int	dbq:2;
} h263streamheader;

typedef struct h263rtpheader_A {
	unsigned int	ftype:1;	/* 0 for mode A */
	unsigned int	pbframes:1;	/* 0 for mode A */
	unsigned int	sbit:3;
	unsigned int	ebit:3;
	unsigned int	srcformat:3;
	unsigned int	picture_coding_type:1;	
	unsigned int	unrestricted_motion_vector:1;
	unsigned int	syntax_based_arithmetic:1;
	unsigned int	advanced_prediction:1;
	unsigned int	reserved:4;
	unsigned int	dbq:2;
	unsigned int	trb:3;
	unsigned int	tr:8;
} h263rtpheader_A;

typedef struct h263rtpheader_B {
	unsigned int	ftype:1;	/* 1 for mode B */
	unsigned int	pbframes:1;	/* 0 for mode B */
	unsigned int	sbit:3;
	unsigned int	ebit:3;
	unsigned int	srcformat:3;
	unsigned int	quant:5;
	unsigned int	gobn:5;
	unsigned int	mba:9;
	unsigned int	reserved:2;
	/* second 32 bit word */
	unsigned int	picture_coding_type:1;
	unsigned int	unrestricted_motion_vector:1;
	unsigned int	syntax_based_arithmetic:1;
	unsigned int	advanced_prediction:1;
	unsigned int	hmv1:7;
	unsigned int	vmv1:7;
	unsigned int	hmv2:7;
	unsigned int	vmv2:7;
} h263rtpheader_B;

typedef struct h263_rtp_packet {
	union {
		h263rtpheader_A h263a;
		h263rtpheader_B h263b;
	} header;
	int	headersize; /* could be dedicated from the h263a header */
	unsigned char	*data;
	int	 datasize;
} h263_rtp_packet;

#endif
