
#ifndef _RTP_DEFINES_H
#define _RTP_DEFINES_H

/***************** Defines **************************************************/
/*!! #define PRINT_MY_DEBUG_MESSAGES */
/*!! #define PRINT_CONCEAL_MESSAGES */

/************* Allgemein  *************/
#define MAX_FILENAME_LEN             21
#define MAX_PATHNAME_LEN             80
#define BYTES_FOR_PACKLEN             4     /* Anzahl Bytes, mit denen die Laenge eines Paketes im File
					       abgespeichert werden soll (darf 4 nicht ueberschreiten) */
#define DOCU_FILENAME            "docu"
#define DEFAULT_MEAS_FILENAME    "meas"     /* name of file for objective video measurement data */

/**************** RTP *****************/
#define RTP_VERSION                   2
#define MAX_PACKETSIZE             1024     /*!! (incl. Header) noch rausfinden fuer UDP */
#define H263_PAYLOAD                 34     /* ITU H.263 */
#define PYRA_PAYLOAD                 35     /* Lehrstuhl NT and IMMD4 ScalVico, vgl. rtp.h */
#define RTP_M                    0x0080     /* zur Kontrolle, ob M-Flag gesetzt */

/*************** Layer ****************/
#define MAX_LAYERS                    4
#define MAX_FRAMESIZE            102400     /*!! 100 kByte (evtl. noch modifizieren) */

#define H263_ID      	              1
#define PYRA_ID                       2
#define LAYERTYPE_H263                1
#define LAYERTYPE_PYRA                2

/*************** H.263 ****************/
#define HDRSIZE_A	              4
#define HDRSIZE_B	              8
#define H263_LAYERFREQ_INI            1     /* initialization value for layerfrequency */

/************ Entpacker ***************/
#define MAX_NEXTPACKETS               5     /* werden mehr Pakete vom naechsten Zeitpunkt empfangen,
					       einlesen fuer akt. Zeitpunkt beenden */
#define MAX_TIMEDISTANCE            128     /* ist Zeitabstand zw. Paket und akt. Zeitpunkt groesser,
					       Paket wegwerfen */
#define NUM_OF_NEXT_PACKETS          10     /* if NUM_OF_NEXT_PACKETS packets of next timestamps read in
					       assume end of packets for current timestamp */
#define MAX_DIFF_TS                   3     /* if packets of MAX_DIFF_TS different timestamps read in
					       assume end of packets for current timestamp */

#define PACKET_USED                   0
#define PACKET_THROWN_AWAY            1

#define B_SLOTS	                    256
#define B_SLOTMASK	  (B_SLOTS - 1)

#define EXPECT_FRAME                  1
#define EXPECT_NO_FRAME               0

/************** Decoder ***************/
#define DECODE_ALL                    0     /*       4        */
#define LOOK_FOR_INTRA                1     /*    possible    */
#define LOOK_FOR_PIC_SYNC             2     /*   states of    */
#define THROW_AWAY_ALL                3     /*    decoder     */

/********** Loss evaluation ***********/
#define COMPUTE_LOSS                 -1
#define NO_LOSS_AT_INTRA             -2 
#define NO_LOSS                       0
#define COMPLETE_LOSS               100

/************ Concealment *************/
#define TEMP_CONCEALMENT              1     /* temporal concealment */
#define SPAT_CONCEALMENT              2     /* spatial concealment */

#define DEFAULT_STRATEGY              1     /*!! strategy for error concealment */
#define DEFAULT_MAX_LOSS_QUOTAS       2     /*!! number of relevant previous gob loss quotas (minimum:2)*/
#define DEFAULT_MAX_PERCENT_LOSS     40     /*!! if losses are greater switch off that layer */
#define DEFAULT_MAX_PERCENT_LOSS_SUM 60     /*!! if sum of previous losses is greater switch off that layer */
#define DEFAULT_CONCEAL_MESSAGES      0     /*!! if 0 print no messages concerning concealment */
#define DEFAULT_PREV_LOSS_FADING    0.8
#define DEFAULT_CUR_LOSS_WEIGHT     1.0
#define DEFAULT_PSNR                 36

/************** Display ***************/
#define SHOW_LAYER                    1
#define HIDE_LAYER                    0

#define DEFAULT_DISPLAY_CRITERIUM     0     /*!! criterium if layer should (not) be displayed */
#define DEFAULT_DISPLAY_WAIT          0     /*!! wait (at least) DEFAULT_DISPLAY_WAIT timesteps until
                                                 layer is switched on again */
#define INTRA_MB_LOSS_WEIGTH          0     /* weighting of a lost MB in intra mode */
/***** Objective quality measure  *****/
#define REF_PICTURESIZE_W           352
#define REF_PICTURESIZE_H           288
#define PSNR                          1

#endif /* #ifndef _RTP_DEFINES_H */
