#ifndef _MY_RTPDEC_H
#define _MY_RTPDEC_H

#include <stdio.h>
#include "defs.h" 
#include "rtp_defs.h"
#include "h263.h"
#include "pyra.h"


typedef struct Slot {
    unsigned short              seqno;
    unsigned int		rtflags;
    unsigned int		cc;
    unsigned char* 		bp;
  /* unsigned char		layernr;*/
  /* int				layertype;*/
    unsigned long int		tr;       /* timestamp of RTP-Header */
    union {
        unsigned char		pad[32];
        PyraLayerRtpHeader 	prh;
        h263rtpheader_A		h263a;
        h263rtpheader_B		h263b;
    } header;
} Slot;

/* information concerning a layer
 * for every layer one struct is allocated */
typedef struct layerDecData {
    int layernr;
    int layertype;
    char picCodType;       /* picture coding type (inter/intra/unknown) (bisher nur fuer pyra) */
    char gfid; /*prev_gfid;*/    /* GobFrameId */

    FILE *stream;
    Slot slot[B_SLOTS];
    unsigned char slot_f[B_SLOTS];    /* 1:slot contains current packet */
    int curstart;          /* start of current slots */
    int curend;            /* end of current slots */
    int lastseqno;         /* last seqno of previous received frame */

    int pcktsinbuf;        /* # of packets in buffer */
    int curpackets;        /* # of packets of current timestamp in buffer */
    int diffTsPackets;        /* # of packets in buffer with timestamps different from current one */
    int numOfDiffTs;          /* # of timestamps different from current one in buffer */
    unsigned long int diffTs[MAX_DIFF_TS];  /* timestamps different from current one in buffer */
    
    /* int layeruncoded;         /  */
    int wait;                 /*  */
    char expectFrame;         /*  */

    /* statistics for decisions (decode/conceal/display) */
    unsigned long int prevDecTime;
    unsigned long int prevRecTime;
    char state;               /* tells us what to do with packets */

    /* statistics concerning (packet/frame/gob) losses */
    char unperfectGobs[MAX_GOBS];     /* x = gob has been concealed x times since last intra
                                         0 = gob has always been decoded */
    int curIndex;             /* current index of percentloss */
    int percentloss[DEFAULT_MAX_LOSS_QUOTAS];/* gob losses of previous frames in percent (ring) */
    int accuPercentLoss;      /* sum of previous losses since last intra frame (in %) */
    unsigned long mv_loss;    /* measure of loss considering motion vectors */
    int prevFramesMissing;    /* missing frames since last decoded frame */
    int missFramesSinceI;     /* missing frames since last decoded intra frame */
    char display;             /* -1 = display layer only if displaywait == 0
                                  0 = don't display layer
                                  1 = display layer */
    int displaywait;          /* if display = -1 und displaywait = 0 -> display */
    float psnr;               /* average PSNR value */
    
    /* statistics */
    unsigned long int recpackets;        /* # of (complete) packets received for that layer */
    unsigned long int lostpackets;       /* # of packets lost for that layer */
    unsigned long int handledpackets;    /* # of packets already evaluated or thrown away */
    unsigned long int thrownawaypackets; /* # of packets already thrown away */
    unsigned long int recframenr;        /* # of frames received for this layer */

} layerDecData;



/* values concerning concealment of gob losses and diplay decisions */
typedef struct concealDispVal {
    /* concealment */
    int strategy;                        /* one of our own concealment strategies */
    int considered;                      /* # of relevant previous gob loss quotas */
    int maxP100Loss;                     /* if losses are greater switch off that layer */
    int maxP100LossSum;                  /* if sum of previous losses is greater switch off that layer */
    char ConcealMessages;                /* if nonzero print messages concerning concealment */
    /* diplay */
    int displayCriterium;                /* one of our own criteria if layer should (not) be displayed  */
    int displayWait;                     /* wait (at least) displayWait timesteps until layer is
                                            switched on again */
    float prevLossFading;                /* fading of the influence of previous losses on display decision */
    float curLossWeight;                 /*  */
    float psnr[NUM_LAYERS];              /* PSNR values of different layers */
} concealDispVal;

#endif /* #ifndef _MY_RTPDEC_H */
