#include "Buffers.h"
#include "Parameter.h"
#include "Image.h"
#include "Input.h"
#include "Headers.h"
#include "DecodeSymbol.h"
#include "BlockDecoder.h"
#include "Syntax.h"
#include "Interpolation.h"
#include "Motion.h"
#include "Crop.h"
#include "config.h"

#define MEAN_CODING

extern int TableIndex;

static int gbw, gbh;
static int pmvfx, pmvfy;

static void PrintImageBlock(Byte *b, int w, int bs) {
  int i, j;

  for (j=0; j<bs; j++) {
    for (i=0; i<bs; i++) {
      fprintf(stderr,"%3d ", b[(j*w)+i]);
    }
    fprintf(stderr,"\n");
  }
}
    

static void ResetMVPredictor() {
  pmvfx = pmvfy = 0;
}

static void UpsampleMeans4 (int *b1, Byte *b2, int bs, int rb) {
  int i, j;

  for (j=0; j<4*bs; j++)
    for (i=0; i<4*bs; i++) 
      b2[j*rb+i] = (Byte) b1[(j/4)*bs+(i/4)];
      
}

static void DecodeLowestPLayer(FramePtr Decoded, FramePtr Ref, FramePtr MotComp, MVFieldPtr mv) {

  int fx, fy;
  int pmode;
  int i,j;

  Byte *ydec, *udec, *vdec;
  Byte *yref, *uref, *vref;
  Byte *ymot, *umot, *vmot;

  InitBlockDecoder(Decoded->Y->w);

  for (j=0; j<Decoded->Y->h; j+=gbh) {

    ResetMVPredictor(); 
    ResetMeanPredictors();
   
    ydec = Decoded->Y->data + (j*Decoded->Y->w);
    udec = Decoded->U->data + ((j/2)*Decoded->U->w);
    vdec = Decoded->V->data + ((j/2)*Decoded->V->w);

    yref = Ref->Y->data + (j*Ref->Y->w);
    uref = Ref->U->data + ((j/2)*Ref->U->w);
    vref = Ref->V->data + ((j/2)*Ref->V->w);

    ymot = MotComp->Y->data + (j*MotComp->Y->w);
    umot = MotComp->U->data + ((j/2)*MotComp->U->w);
    vmot = MotComp->V->data + ((j/2)*MotComp->V->w);

    for (i=0; i<Decoded->Y->w; i+=gbw) {

      pmode = GetPLowPredTypeHuffCode();

      switch (pmode) {
      case 0:
	SetMotionVector (mv,i,j,0,0);

	CopyMB16(ydec, udec, vdec, yref, uref, vref);
#ifdef MEAN1
	DecodeMeans(ydec, udec, vdec);
#endif
#ifdef MEAN2
	DecodeAndInterRec2YVects(ydec);
	DecodeAndInterRec1UVVect(udec, vdec);
#endif

#ifdef BPMC
	CopyMB16(ymot, umot, vmot, yref, uref, vref); 
#endif
	ResetMVPredictor();
	ResetMeanPredictors();

	break;
      case 1:
	fx = DecodeMVComponent(pmvfx); pmvfx = fx;
	fy = DecodeMVComponent(pmvfy); pmvfy = fy;

	SetMotionVector (mv,i,j,fx,fy);
	CompensateTPLP_MB(ydec, udec, vdec, yref, uref, vref, fx, fy); 
	/*
	if ((Decoded->TempRef==1)&&(i==96)&&(j==80)) {
	  fprintf(stderr,"fx=%d fy=%d\n", fx, fy);
	  PrintImageBlock(ydec, Decoded->Y->w, 16);
	  fprintf(stderr,"\n");
	  PrintImageBlock(udec, Decoded->U->w, 8);
	}
	*/

#ifdef BPMC
	CopyMB16(ymot, umot, vmot, ydec, udec, vdec);
#endif
#ifdef MEAN1
	DecodeMeans(ydec, udec, vdec);
	/*
	if ((Decoded->TempRef==1)&&(i==96)&&(j==80)) {
	  fprintf(stderr,"\n");
	  PrintImageBlock(udec, Decoded->U->w, 8);
	}
	*/
#endif
#ifdef MEAN2
	DecodeAndInterRec2YVects(ydec);
	DecodeAndInterRec1UVVect(udec, vdec);
#endif
	DecodeTPMB(ydec, udec, vdec, SeqHdr.PPreset[LayerHdr.Number], gbw/2);
	/*
	if ((Decoded->TempRef==1)&&(i==96)&&(j==80)) {
	  fprintf(stderr,"\n");
	  PrintImageBlock(udec, Decoded->U->w, 8);
	}
	*/
	ResetMeanPredictors();

	break;
      case 2:
	SetMotionVector (mv,i,j,0,0);
	ResetMVPredictor();
#ifdef BPMC
	CopyMB16(ymot, umot, vmot, yref, uref, vref);
#endif
	/*
	for (n=0; n<16; n++) mean[n] = GetBits(8);
	UpsampleMeans4(mean, ydec, 4, Decoded->Y->w);

	for (n=0; n<4; n++) mean[n] = GetBits(8);
	UpsampleMeans4(mean, udec, 2, Decoded->U->w);

	for (n=0; n<4; n++) mean[n] = GetBits(8);
	UpsampleMeans4(mean, vdec, 2, Decoded->V->w);
	*/

	DecodeIntraMeans(ydec, udec, vdec);
	DecodeSPMB(ydec, udec, vdec, SeqHdr.IPreset[LayerHdr.Number], gbw/2);

	break;
      case 3:
	SetMotionVector (mv,i,j,0,0);
	ResetMVPredictor();
#ifdef BPMC
	CopyMB16(ymot, umot, vmot, yref, uref, vref);
#endif
	/*
	for (n=0; n<16; n++) mean[n] = GetBits(8);
	UpsampleMeans4(mean, ydec, 4, Decoded->Y->w);

	for (n=0; n<4; n++) mean[n] = GetBits(8);
	UpsampleMeans4(mean, udec, 2, Decoded->U->w);

	for (n=0; n<4; n++) mean[n] = GetBits(8);
	UpsampleMeans4(mean, vdec, 2, Decoded->V->w);
	*/

	DecodeIntraMeans(ydec, udec, vdec);

	break;
      }
      ydec += 16; udec += 8; vdec += 8;
      yref += 16; uref += 8; vref += 8;
      ymot += 16; umot += 8; vmot += 8;
    }
  }
}

static void DecodePLayer(FramePtr Decoded, FramePtr DecodedLow, FramePtr Ref, FramePtr RefLow, FramePtr MotComp, FramePtr MotCompLow, MVFieldPtr mv, MVFieldPtr mvLow) {

  int fx0, fy0, fx, fy, dfx, dfy;
  int pmode, coding_mode, coded;
  int i,j;
  Byte *ydec, *udec, *vdec;
  Byte *yref, *uref, *vref;
  Byte *ymot, *umot, *vmot;

  InitBlockDecoder(Decoded->Y->w);

  for (j=0; j<Decoded->Y->h; j+=gbh) {

    ydec = Decoded->Y->data + (j*Decoded->Y->w);
    udec = Decoded->U->data + ((j/2)*Decoded->U->w);
    vdec = Decoded->V->data + ((j/2)*Decoded->V->w);

    yref = Ref->Y->data + (j*Ref->Y->w);
    uref = Ref->U->data + ((j/2)*Ref->U->w);
    vref = Ref->V->data + ((j/2)*Ref->V->w);

    ymot = MotComp->Y->data + (j*MotComp->Y->w);
    umot = MotComp->U->data + ((j/2)*MotComp->U->w);
    vmot = MotComp->V->data + ((j/2)*MotComp->V->w);

    for (i=0; i<Decoded->Y->w; i+=gbw) {

      pmode = GetPPredTypeHuffCode();
      switch (pmode) {
      case 0: coding_mode = SP_BLOCK; coded = 0; break;
      case 1: coding_mode = SP_BLOCK; coded = 1; break;

      case 2: coding_mode = FWD_TPLP_BLOCK; coded = 0; break;
      case 3: coding_mode = FWD_TPLP_BLOCK; coded = 1; break;
      }
      switch (coding_mode) {
      case FWD_TPLP_BLOCK:
      case FWD_TPBP_BLOCK:
	GetMotionVector (mv, i, j, &fx0, &fy0);
	if (coded) {
	  dfx = DecodeRefineMVComponent();
	  dfy = DecodeRefineMVComponent();

	  fx = 2*fx0 + dfx;
	  fy = 2*fy0 + dfy;

	} else { fx = 2*fx0; fy = 2*fy0; }

	SetMotionVector (mv,i,j,fx,fy);
	CompensateTPLP_MB(ydec, udec, vdec, yref, uref, vref, fx, fy); 

	if (coding_mode == FWD_TPLP_BLOCK) {

	  if (coded)
	    DecodeTPMB(ydec, udec, vdec, SeqHdr.PPreset[LayerHdr.Number], gbw/2);

	} else {

#ifdef BPMC
	  /* Spatial Interpolation of motion compensated low resolution */
	  InterpolateBlockHV (MotCompLow->Y->data, MotComp->Y->data, i/2, j/2, gbw/2, gbh/2, MotCompLow->Y->w, MotCompLow->Y->h);
	  InterpolateBlockHV (MotCompLow->U->data, MotComp->U->data, i/4, j/4, gbw/4, gbh/4, MotCompLow->U->w, MotCompLow->U->h);
	  InterpolateBlockHV (MotCompLow->V->data, MotComp->V->data, i/4, j/4, gbw/4, gbh/4, MotCompLow->V->w, MotCompLow->V->h);

	  /* Spatial Interpolation of reconstructed low resolution */
	  InterpolateBlockHV (DecodedLow->Y->data, Decoded->Y->data, i/2, j/2, gbw/2, gbh/2, DecodedLow->Y->w, DecodedLow->Y->h);
	  InterpolateBlockHV (DecodedLow->U->data, Decoded->U->data, i/4, j/4, gbw/4, gbh/4, DecodedLow->U->w, DecodedLow->U->h);
	  InterpolateBlockHV (DecodedLow->V->data, Decoded->V->data, i/4, j/4, gbw/4, gbh/4, DecodedLow->V->w, DecodedLow->V->h);

	  CompensateTPBP_MB(ydec, udec, vdec, yref, uref, vref, ymot, umot, vmot, fx, fy);

	  if (coded)
	    DecodeTPMB(ydec, udec, vdec, SeqHdr.PPreset[LayerHdr.Number], gbw/2);
#endif
	}
	break;

      case SP_BLOCK:
	GetMotionVector (mv, i, j, &fx0, &fy0);
	SetMotionVector (mv,i,j,2*fx0,2*fy0);

	InterpolateBlockHV (DecodedLow->Y->data, Decoded->Y->data, i/2, j/2, gbw/2, gbh/2, DecodedLow->Y->w, DecodedLow->Y->h);
	InterpolateBlockHV (DecodedLow->U->data, Decoded->U->data, i/4, j/4, gbw/4, gbh/4, DecodedLow->U->w, DecodedLow->U->h);
	InterpolateBlockHV (DecodedLow->V->data, Decoded->V->data, i/4, j/4, gbw/4, gbh/4, DecodedLow->V->w, DecodedLow->V->h);

	if (coded) {
	  DecodeSPMB(ydec, udec, vdec, SeqHdr.PPreset[LayerHdr.Number], gbw/2);
	}
	break;
      }
      ydec += 16; udec += 8; vdec += 8;
      yref += 16; uref += 8; vref += 8;
      ymot += 16; umot += 8; vmot += 8;
    }
  }
}

void DecodePPicture(PyramidPtr Decoded, PyramidPtr Ref, PyramidPtr RefInter, int TempRef, int StartLayer) {
  int l;
  int layerMode;
  char name[80];

  l = StartLayer;

  ResetLayerHeader();

  LayerHdr.IsLowestLayer = 1;

DECODE_LAYER:

#ifdef QCIF
  if (l==0) {
    while ((SyncCode & PICTURE_SYNC_MASK) != PICTURE_START_CODE) SyncCode = GotoSync();
    goto EXIT;
  }
#endif

  LayerHdr.Number = l;

  gbw = SeqHdr.BlockWidth[l];
  gbh = SeqHdr.BlockHeight[l];

  Decoded->Layer[l]->TempRef = TempRef;
  RefInter->Layer[l]->TempRef = TempRef;
  FwdMV->Layer[l]->ActTempRef = TempRef;
  FwdMV->Layer[l]->RefTempRef = TempRef;

  if (LayerHdr.IsLowestLayer) {
    TableIndex = l;
    DecodeLowestPLayer(Decoded->Layer[l], Ref->Layer[l], RefInter->Layer[l], FwdMV->Layer[l]);
    /* FutureLayerRefToPast(l); */
  } else {
    TableIndex = l;
    if (layerMode==1) {
      DecodePLayer(Decoded->Layer[l], Decoded->Layer[l+1], Ref->Layer[l], Ref->Layer[l+1], RefInter->Layer[l], RefInter->Layer[l+1], 
		   FwdMV->Layer[l], FwdMV->Layer[l+1]);
    } else {
      InterpolateImage (Decoded->Layer[l+1]->Y, Decoded->Layer[l]->Y);
      InterpolateImage (Decoded->Layer[l+1]->U, Decoded->Layer[l]->U);
      InterpolateImage (Decoded->Layer[l+1]->V, Decoded->Layer[l]->V);
      DecodeILayer(Decoded->Layer[l]);
    }

    /* FutureLayerRefToPast(l); */
  }

#ifdef SAVE_DECODED
  sprintf(name,"decoded.%d", l);
  SaveYUVKhorosFormat(Decoded->Layer[l], name, TempRef); 
#endif

  SyncCode = GotoSync();

  if ((SyncCode&LAYER_SYNC_MASK) == LAYER_START_CODE) {
    layerMode = SyncCode&3;
    if (layerMode==1)
      InterpolateMVField2(FwdMV->Layer[l], FwdMV->Layer[l-1], Ref->Layer[l]->TempRef, Decoded->Layer[l]->TempRef, Ref->Layer[l-1]->TempRef, TempRef, 1);
    LayerHdr.IsLowestLayer = 0;
    l--;
    goto DECODE_LAYER;
  } else if ((SyncCode & PICTURE_SYNC_MASK) == PICTURE_START_CODE) {
    while (l>0) {
      InterpolateImage (Decoded->Layer[l]->Y, Decoded->Layer[l-1]->Y);
      InterpolateImage (Decoded->Layer[l]->U, Decoded->Layer[l-1]->U);
      InterpolateImage (Decoded->Layer[l]->V, Decoded->Layer[l-1]->V);
#ifdef SAVE_DECODED
      sprintf(name,"decoded.%d", l-1);
      SaveYUVKhorosFormat(Decoded->Layer[l-1], name, TempRef); 
#endif
      l--;
    }
  }

 EXIT:
  while(l<=StartLayer) {
    FutureLayerRefToPast(l);
    l++;
  }
  /*
  FutureLayerRefToPast(2);
  FutureLayerRefToPast(1);
  FutureLayerRefToPast(0);
  */
}
