#include "global.h"

#include "Buffers.h"

void InitBuffers(Global *this)
{
  int ow, oh;

  ow = this->SeqHdr.HSize;
  oh = this->SeqHdr.VSize;

  this->Decoded = NewPyramid(ow, oh, this->SeqHdr.Layers);
  this->PastDecoded =  NewPyramid(ow, oh, this->SeqHdr.Layers+1);
  this->FutrDecoded =  NewPyramid(ow, oh, this->SeqHdr.Layers+1);
  this->PastSPInter =  NewPyramid(ow, oh, this->SeqHdr.Layers+1);
  this->FutrSPInter =  NewPyramid(ow, oh, this->SeqHdr.Layers+1);
}

void FutureRefToPast(Global *this) {

  int i;
  FramePtr tmp;

  for (i=0; i<=this->FutrDecoded->LowestLayer; i++) {
    tmp = this->PastDecoded->Layer[i];
    this->PastDecoded->Layer[i] = this->FutrDecoded->Layer[i];
    this->FutrDecoded->Layer[i] = tmp;

    if (i<this->FutrDecoded->LowestLayer) {
      tmp = this->PastSPInter->Layer[i];
      this->PastSPInter->Layer[i] = this->FutrSPInter->Layer[i];
      this->FutrSPInter->Layer[i] = tmp;
    }
  }
}

void FutureLayerRefToPast(Global *this, int l) {

  FramePtr tmp;

  tmp = this->PastDecoded->Layer[l];
  this->PastDecoded->Layer[l] = this->FutrDecoded->Layer[l];
  this->FutrDecoded->Layer[l] = tmp;

  tmp = this->PastSPInter->Layer[l];
  this->PastSPInter->Layer[l] = this->FutrSPInter->Layer[l];
  this->FutrSPInter->Layer[l] = tmp;
}
