#include "Util.h"

#include "global.h"

#include "BlockDecoder.h"
#include "Image.h"
#include "Input.h"
#include "DecodeSymbol.h"

static void DecodeDPCMImage(Global *this, ImagePtr image) {
  int i, j;
  int w;
  int p1, p2, p3, p;

  w = image->w;

  p = 128;
  for (i=0; i<w; i++) {
    image->data[i] = DecodeIntraMean(this, &p);
  } 

  for (j=1; j<image->h; j++) {
    p = image->data[(j-1)*w];
    image->data[j*w] = DecodeIntraMean(this, &p);
    for (i=1; i<w; i++) {
      p1=image->data[(j-1)*w+i-1];
      p2=image->data[(j-1)*w+i];
      p3=image->data[j*w+i-1];
      p = ROUND( ((-2*p1) + (3*p2) + (3*p3)) / 4.0);
      image->data[j*w+i] = DecodeIntraMean(this, &p);
    }
  }
}

void DecodeDPCMFrame(Global *this, FramePtr decoded)
{
  DecodeDPCMImage(this, decoded->Y);
  DecodeDPCMImage(this, decoded->U);
  DecodeDPCMImage(this, decoded->V);
}
