#include <string.h>

#include "global.h"
#include "extern.h"

#include "BlockDecoder.h"
#include "Input.h"
#include "Headers.h"
#include "Interpolation.h"
#include "DPCM.h"
#include "DecodeSymbol.h"

/* extern int TableIndex; */
static int gbw, gbh;

void DecodeILayer(Global *this, FramePtr Decoded) {

  Byte *ydata, *udata, *vdata;
  int i,j;
  int not_coded;

  InitBlockDecoder(Decoded->Y->w);

  for (j=0; j<Decoded->Y->h; j+=gbh) {

    ydata = Decoded->Y->data + (j*Decoded->Y->w);
    udata = Decoded->U->data + ((j/2)*Decoded->U->w);
    vdata = Decoded->V->data + ((j/2)*Decoded->V->w);

    for (i=0; i<Decoded->Y->w; i+=gbw) {

      not_coded = GetOneBit(this);

      if (! not_coded) {
	DecodeSPMB(this, ydata, udata, vdata, this->SeqHdr.IPreset[this->LayerHdr.Number], gbw/2);
      } 
      ydata += 16; udata += 8; vdata += 8;
    }
  }
}
  
void DecodeIPicture(Global *this, PyramidPtr Decoded, PyramidPtr SPInter, int TempRef, int FirstLayer) {
  int l;
  char name[80];

  l = FirstLayer;

  ResetLayerHeader(this);

  this->LayerHdr.IsLowestLayer = 1;

DECODE_LAYER:


  this->LayerHdr.Number = l;

  gbw = this->SeqHdr.BlockWidth[l];
  gbh = this->SeqHdr.BlockHeight[l];

  if (this->LayerHdr.IsLowestLayer) {
    DecodeDPCMFrame(this, Decoded->Layer[l]);
    /* DecodeLowestILayer(Decoded->Layer[l]); */
  } else {
    if (l != (FirstLayer - 1)) {
      /* TableIndex = l; */
      DecodeILayer(this, Decoded->Layer[l]);
    }
  }

  Decoded->Layer[l]->TempRef = TempRef;
  SPInter->Layer[l]->TempRef = TempRef;

  if (this->Options.save_decoded)
    {
      sprintf(name,"decoded.%d", l);
      SaveYUVKhorosFormat(Decoded->Layer[l], name, TempRef); 
    }
  this->SyncCode = GotoSync(this);

  if (this->Options.qcif)
    {
      if (l==1) {
	if (this->Options.visexpand) {
	  InterpolateImage (Decoded->Layer[l]->Y, Decoded->Layer[l-1]->Y);
	  InterpolateImage (Decoded->Layer[l]->U, Decoded->Layer[l-1]->U);
	  InterpolateImage (Decoded->Layer[l]->V, Decoded->Layer[l-1]->V);
	}
	if ((this->SyncCode&SYNC_MASK)!= PICTURE_START_CODE)
	  NextPictureStartCode(this);
	goto EXIT;
      }
    }

  if ((this->SyncCode&SYNC_MASK) == LAYER_START_CODE) {
    InterpolateImage (Decoded->Layer[l]->Y,Decoded->Layer[l-1]->Y); 
    /*    InterpolateBlockwise (Decoded->Layer[l]->Y,Decoded->Layer[l-1]->Y);  */
    InterpolateImage (Decoded->Layer[l]->U,Decoded->Layer[l-1]->U);
    InterpolateImage (Decoded->Layer[l]->V,Decoded->Layer[l-1]->V);   

    this->LayerHdr.IsLowestLayer = 0;
    l--;
    goto DECODE_LAYER;
  } else if ((this->SyncCode & SYNC_MASK) == PICTURE_START_CODE) {
    while (l>0) {
      InterpolateImage (Decoded->Layer[l]->Y, Decoded->Layer[l-1]->Y);
      InterpolateImage (Decoded->Layer[l]->U, Decoded->Layer[l-1]->U);
      InterpolateImage (Decoded->Layer[l]->V, Decoded->Layer[l-1]->V);
      if (this->Options.save_decoded)
	{
	  sprintf(name,"decoded.%d", l-1);
	  SaveYUVKhorosFormat(Decoded->Layer[l-1], name, TempRef); 
	}
      l--;
    }
  }
    
EXIT:
  ;
  /* fprintf(stderr,"IPicture at %d\n", TempRef); */
}
