#include "global.h"
#include "extern.h"

#include "BlockDecoder.h"
#include "Buffers.h"
#include "Input.h"
#include "Headers.h"
#include "Interpolation.h"
#include "DecodeSymbol.h"

/* extern int TableIndex; */

static int gbw, gbh;
static int pmvfx, pmvfy;

void PrintImageBlock(Byte *b, int w, int bs) {
  int i, j;

  for (j=0; j<bs; j++) {
    for (i=0; i<bs; i++) {
      fprintf(stderr,"%3d ", b[(j*w)+i]);
    }
    fprintf(stderr,"\n");
  }
}
    

static void ResetMVPredictor() {
  pmvfx = pmvfy = 0;
}

void UpsampleMeans4 (int *b1, Byte *b2, int bs, int rb) {
  int i, j;

  for (j=0; j<4*bs; j++)
    for (i=0; i<4*bs; i++) 
      b2[j*rb+i] = (Byte) b1[(j/4)*bs+(i/4)];
      
}

static void DecodeLowestPLayer(Global *this, FramePtr Decoded, FramePtr Ref, FramePtr MotComp, MVFieldPtr mv) {

  int fx, fy;
  int pmode;
  int i,j;

  Byte *ydec, *udec, *vdec;
  Byte *yref, *uref, *vref;
  Byte *ymot, *umot, *vmot;

  InitBlockDecoder(Decoded->Y->w);

  for (j=0; j<Decoded->Y->h; j+=gbh) {

    ResetMVPredictor(); 
    ResetMeanPredictors();
   
    ydec = Decoded->Y->data + (j*Decoded->Y->w);
    udec = Decoded->U->data + ((j/2)*Decoded->U->w);
    vdec = Decoded->V->data + ((j/2)*Decoded->V->w);

    yref = Ref->Y->data + (j*Ref->Y->w);
    uref = Ref->U->data + ((j/2)*Ref->U->w);
    vref = Ref->V->data + ((j/2)*Ref->V->w);

    ymot = MotComp->Y->data + (j*MotComp->Y->w);
    umot = MotComp->U->data + ((j/2)*MotComp->U->w);
    vmot = MotComp->V->data + ((j/2)*MotComp->V->w);

    for (i=0; i<Decoded->Y->w; i+=gbw) {

      pmode = GetPLowPredTypeHuffCode(this);

      switch (pmode) {
      case 0:
	SetMotionVector (mv,i,j,0,0);

	CopyMB16(this, ydec, udec, vdec, yref, uref, vref);

	ResetMVPredictor();
	ResetMeanPredictors();

	break;
      case 1:
	fx = DecodeMVComponent(this, pmvfx); pmvfx = fx;
	fy = DecodeMVComponent(this, pmvfy); pmvfy = fy;

	SetMotionVector (mv,i,j,fx,fy);
	CompensateTPLP_MB(this, ydec, udec, vdec, yref, uref, vref, fx, fy); 
	DecodeTPMB(this, ydec, udec, vdec, this->SeqHdr.PPreset[this->LayerHdr.Number], gbw/2);

	ResetMeanPredictors();

	break;
      case 2:
	SetMotionVector (mv,i,j,0,0);
	ResetMVPredictor();
	DecodeIntraMeans(this, ydec, udec, vdec);
	DecodeSPMB(this, ydec, udec, vdec, this->SeqHdr.IPreset[this->LayerHdr.Number], gbw/2);
	break;
      case 3:
	SetMotionVector (mv,i,j,0,0);
	ResetMVPredictor();
	DecodeIntraMeans(this, ydec, udec, vdec);

	break;
      }
      ydec += 16; udec += 8; vdec += 8;
      yref += 16; uref += 8; vref += 8;
      ymot += 16; umot += 8; vmot += 8;
    }
  }
}

static void DecodePLayer(Global *this, FramePtr Decoded, FramePtr DecodedLow, FramePtr Ref, FramePtr RefLow, FramePtr MotComp, FramePtr MotCompLow, MVFieldPtr mv, MVFieldPtr mvLow) {

  int fx0, fy0, fx, fy, dfx, dfy;
  int pmode, coding_mode = 0, coded = 0;
  int i,j;
  Byte *ydec, *udec, *vdec;
  Byte *yref, *uref, *vref;
  Byte *ymot, *umot, *vmot;

  InitBlockDecoder(Decoded->Y->w);

  for (j=0; j<Decoded->Y->h; j+=gbh) {

    ydec = Decoded->Y->data + (j*Decoded->Y->w);
    udec = Decoded->U->data + ((j/2)*Decoded->U->w);
    vdec = Decoded->V->data + ((j/2)*Decoded->V->w);

    yref = Ref->Y->data + (j*Ref->Y->w);
    uref = Ref->U->data + ((j/2)*Ref->U->w);
    vref = Ref->V->data + ((j/2)*Ref->V->w);

    ymot = MotComp->Y->data + (j*MotComp->Y->w);
    umot = MotComp->U->data + ((j/2)*MotComp->U->w);
    vmot = MotComp->V->data + ((j/2)*MotComp->V->w);

    for (i=0; i<Decoded->Y->w; i+=gbw) {

      pmode = GetPPredTypeHuffCode(this);
      switch (pmode) {
      case 0: coding_mode = SP_BLOCK; coded = 0; break;
      case 1: coding_mode = SP_BLOCK; coded = 1; break;

      case 2: coding_mode = FWD_TPLP_BLOCK; coded = 0; break;
      case 3: coding_mode = FWD_TPLP_BLOCK; coded = 1; break;
      }
      switch (coding_mode) {
      case FWD_TPLP_BLOCK:
	GetMotionVector (mv, i, j, &fx0, &fy0);
	if (coded) {
	  dfx = DecodeRefineMVComponent(this);
	  dfy = DecodeRefineMVComponent(this);

	  fx = 2*fx0 + dfx;
	  fy = 2*fy0 + dfy;

	} else { fx = 2*fx0; fy = 2*fy0; }

	SetMotionVector (mv,i,j,fx,fy);
	CompensateTPLP_MB(this, ydec, udec, vdec, yref, uref, vref, fx, fy); 

	if (coded) DecodeTPMB(this, ydec, udec, vdec, this->SeqHdr.PPreset[this->LayerHdr.Number], gbw/2);

	break;

      case SP_BLOCK:
	GetMotionVector (mv, i, j, &fx0, &fy0);
	SetMotionVector (mv,i,j,2*fx0,2*fy0);

	InterpolateBlockHV (this, DecodedLow->Y->data, Decoded->Y->data, i/2, j/2, gbw/2, gbh/2, DecodedLow->Y->w, DecodedLow->Y->h);
	InterpolateBlockHV (this, DecodedLow->U->data, Decoded->U->data, i/4, j/4, gbw/4, gbh/4, DecodedLow->U->w, DecodedLow->U->h);
	InterpolateBlockHV (this, DecodedLow->V->data, Decoded->V->data, i/4, j/4, gbw/4, gbh/4, DecodedLow->V->w, DecodedLow->V->h);

	if (coded) {
	  DecodeSPMB(this, ydec, udec, vdec, this->SeqHdr.PPreset[this->LayerHdr.Number], gbw/2);
	}
	break;
      }
      ydec += 16; udec += 8; vdec += 8;
      yref += 16; uref += 8; vref += 8;
      ymot += 16; umot += 8; vmot += 8;
    }
  }
}

void DecodePPicture(Global *this, PyramidPtr Decoded, PyramidPtr Ref, PyramidPtr RefInter, int TempRef, int StartLayer) {
  int l;
  int layerMode = 0;
  char name[80];

  l = StartLayer;

  ResetLayerHeader(this);

  this->LayerHdr.IsLowestLayer = 1;

DECODE_LAYER:

  this->LayerHdr.Number = l;

  gbw = this->SeqHdr.BlockWidth[l];
  gbh = this->SeqHdr.BlockHeight[l];

  Decoded->Layer[l]->TempRef = TempRef;
  RefInter->Layer[l]->TempRef = TempRef;
  this->FwdMV->Layer[l]->ActTempRef = TempRef;
  this->FwdMV->Layer[l]->RefTempRef = TempRef;

  if (this->LayerHdr.IsLowestLayer) {
    /* TableIndex = l; */
    DecodeLowestPLayer(this, Decoded->Layer[l], Ref->Layer[l], RefInter->Layer[l], this->FwdMV->Layer[l]);
    /* FutureLayerRefToPast(this, l); */
  } else {
    /* TableIndex = l; */
    if (layerMode==1) {
      DecodePLayer(this, Decoded->Layer[l], Decoded->Layer[l+1], Ref->Layer[l], Ref->Layer[l+1], RefInter->Layer[l], RefInter->Layer[l+1], 
		   this->FwdMV->Layer[l], this->FwdMV->Layer[l+1]);
    } else {
      InterpolateImage (Decoded->Layer[l+1]->Y, Decoded->Layer[l]->Y);
      InterpolateImage (Decoded->Layer[l+1]->U, Decoded->Layer[l]->U);
      InterpolateImage (Decoded->Layer[l+1]->V, Decoded->Layer[l]->V);
      DecodeILayer(this, Decoded->Layer[l]);
    }

    /* FutureLayerRefToPast(this, l); */
  }

  if (this->Options.save_decoded)
    {
      sprintf(name,"decoded.%d", l);
      SaveYUVKhorosFormat(Decoded->Layer[l], name, TempRef); 
    }

  this->SyncCode = GotoSync(this);

  if (this->Options.qcif)
    {
      if (l==1) {
	if (this->Options.visexpand) {
	  InterpolateImage (Decoded->Layer[l]->Y, Decoded->Layer[l-1]->Y);
	  InterpolateImage (Decoded->Layer[l]->U, Decoded->Layer[l-1]->U);
	  InterpolateImage (Decoded->Layer[l]->V, Decoded->Layer[l-1]->V);
	}
	if ((this->SyncCode&SYNC_MASK)!= PICTURE_START_CODE)
	  NextPictureStartCode(this);
	goto EXIT;
      }
    }

  if ((this->SyncCode&SYNC_MASK) == LAYER_START_CODE) {
    layerMode = (this->SyncCode>>2)&3;
    if (layerMode==1)
      InterpolateMVField2(this->FwdMV->Layer[l], this->FwdMV->Layer[l-1], Ref->Layer[l]->TempRef, Decoded->Layer[l]->TempRef, Ref->Layer[l-1]->TempRef, TempRef, 1);
    this->LayerHdr.IsLowestLayer = 0;
    l--;
    goto DECODE_LAYER;
  } else if ((this->SyncCode & SYNC_MASK) == PICTURE_START_CODE) {
    while (l>0) {
      InterpolateImage (Decoded->Layer[l]->Y, Decoded->Layer[l-1]->Y);
      InterpolateImage (Decoded->Layer[l]->U, Decoded->Layer[l-1]->U);
      InterpolateImage (Decoded->Layer[l]->V, Decoded->Layer[l-1]->V);
      if (this->Options.save_decoded)
	{
	  sprintf(name,"decoded.%d", l-1);
	  SaveYUVKhorosFormat(Decoded->Layer[l-1], name, TempRef); 
	}
      l--;
    }
  }

 EXIT:
  while(l<=StartLayer) {
    FutureLayerRefToPast(this, l);
    l++;
  }
  /*
  FutureLayerRefToPast(this, 2);
  FutureLayerRefToPast(this, 1);
  FutureLayerRefToPast(this, 0);
  */
}
