#include <string.h>

#include "Util.h"

#include "global.h"
#include "extern.h"

#include "Input.h"
#include "DecodeSymbol.h"

#define CBSIZE 64

static int Table17[8+1];
static int Table26[28+1];
static int Table35[56+1];
static int Table44[70+1];

static int Table116[56+1];
static int Table125[168+1];
static int Table134[280+1];
static int Table224[420+1];
static int Table233[560+1];

static int Table1115[336+1];
static int Table1124[840+1];
static int Table1133[1120+1];
static int Table1223[1680+1];
static int Table2222[2520+1];

static int SignType[CBSIZE] = { 2, 0, 0, 0, 1, 2, 0, 0, 0, 3, 2, 1, 1, 1, 3, 2, 0, 0, 2, 2, 2, 0, 0, 3, 0, 2, 1, 0, 0, 1, 2, 1, 0, 0, 3, 0, 0, 2, 0, 0, 2, 2, 0, 2, 3, 2, 2, 0, 3, 2, 1, 0, 2, 1, 3, 1, 1, 3, 2, 2, 0, 0, 0, 0 };


/* How many bits to we need for one index ? */

static int CompBits[CBSIZE] = { 5, 5, 8, 9, 6, 7, 9, 9, 6, 0, 8, 6, 6, 9, 5, 5, 5, 9, 9, 9, 3, 10, 9, 7, 11, 9, 10, 9, 11, 8, 5, 8, 9, 7, 8, 8, 9, 10, 11, 8, 6, 0, 6, 5, 9, 9, 6, 12, 9, 9, 8, 10, 11, 10, 5, 3, 9, 9, 7, 9, 10, 11, 11, 9 };


static int IndexSize[CBSIZE] = {
  1, 1, 2, 2, 1, 1, 2, 2, 2, 0, 2, 2, 1, 2, 1, 1, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 0, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 2 };

static int *CodingTables[CBSIZE] = { 
Table26, Table26, Table125, Table134, Table35, Table44, Table224, Table224, Table116, NULL, Table125, Table116, Table35, Table134, Table26, Table26, Table26, Table134, Table134, Table224, Table17, Table233, Table224, Table44, Table1133, Table224, Table233, Table134, Table1223, Table125, Table26, Table125, Table1115, Table44, Table125, Table125, Table1115, Table233, Table1133, Table125, Table116, NULL, Table116, Table26, Table134, Table134, Table116, Table2222, Table224, Table224, Table125, Table1124, Table1133, Table233, Table26, Table17, Table134, Table224, Table44, Table134, Table1124, Table1223, Table1223, Table224
};


static int NSignTab[CBSIZE] = { 7,6,3,5,7,7,6,4,7,8,7,7,7,7,8,7,2,7,7,7,7,5,6,8,5,7,7,4,6,7,7,7,3,4,8,6,7,7,7,7,7,7,2,7,8,7,7,6,8,7,7,4,7,7,8,7,7,8,7,7,7,7,5,6,};

static double MagTab[CBSIZE][4] = { {1.5,0.5,-1.0,-1.0,},{0.0,1.0,-1.0,-1.0,},{2.0,1.0,0.0,-1.0,},{2.0,0.0,1.0,-1.0,},{1.5,0.5,-1.0,-1.0,},{0.5,1.5,-1.0,-1.0,},{0.0,2.0,1.0,-1.0,},{1.0,2.0,0.0,-1.0,},{0.0,2.0,1.0,-1.0,},{1.0,-1.0,-1.0,-1.0,},{2.5,1.5,0.5,-1.0,},{1.5,2.5,0.5,-1.0,},{0.5,1.5,-1.0,-1.0,},{2.5,1.5,0.5,-1.0,},{2.0,1.0,-1.0,-1.0,},{0.5,1.5,-1.0,-1.0,},{2.0,0.0,-1.0,-1.0,},{0.0,2.0,1.0,-1.0,},{2.5,0.5,1.5,-1.0,},{1.5,2.5,0.5,-1.0,},{2.5,0.5,-1.0,-1.0,},{1.0,0.0,2.0,-1.0,},{0.0,1.0,2.0,-1.0,},{1.0,2.0,-1.0,-1.0,},{2.0,3.0,0.0,1.0,},{0.5,2.5,1.5,-1.0,},{2.5,0.5,1.5,-1.0,},{3.0,1.0,0.0,-1.0,},{3.0,0.0,2.0,1.0,},{1.5,2.5,0.5,-1.0,},{2.5,0.5,-1.0,-1.0,},{2.5,0.5,1.5,-1.0,},{1.0,2.0,3.0,0.0,},{0.0,2.0,-1.0,-1.0,},{3.0,2.0,1.0,-1.0,},{3.0,0.0,1.0,-1.0,},{0.0,2.0,3.0,1.0,},{1.5,0.5,2.5,-1.0,},{0.0,3.0,1.0,2.0,},{0.0,1.0,2.0,-1.0,},{0.5,2.5,1.5,-1.0,},{1.5,-1.0,-1.0,-1.0,},{1.0,3.0,0.0,-1.0,},{2.5,1.5,-1.0,-1.0,},{3.0,1.0,2.0,-1.0,},{0.5,2.5,1.5,-1.0,},{1.5,3.5,0.5,-1.0,},{0.0,1.0,2.0,3.0,},{1.0,3.0,2.0,-1.0,},{0.5,1.5,2.5,-1.0,},{0.5,2.5,1.5,-1.0,},{1.0,3.0,2.0,0.0,},{2.5,3.5,0.5,1.5,},{0.5,1.5,2.5,-1.0,},{1.0,2.0,-1.0,-1.0,},{0.5,1.5,-1.0,-1.0,},{1.5,2.5,0.5,-1.0,},{2.0,3.0,1.0,-1.0,},{1.5,2.5,-1.0,-1.0,},{3.5,1.5,0.5,-1.0,},{0.0,2.0,3.0,1.0,},{0.0,1.0,3.0,2.0,},{2.0,1.0,3.0,0.0,},{0.0,3.0,1.0,-1.0,}, };

static int DecEvenSignTable[256];
static int DecOddSignTable[256];

static int DecodeOtherVector(Global *this, double v[8]) {

  int i;
  int translate, sc, s1, s2, vc, v1, v2;

  translate = GetOneBit(this);

  for (i=0; i<4; i++) {
    sc = GetCombSignHuffCode(this);
    s1 = (sc/3) - 1;
    s2 = (sc%3) - 1;
    if ((s1 != 0)&&(s2 !=0)) {
      vc = GetVCombHuffCode(this);
      v1 = (vc>>3);
      v2 = (vc&7);
    } else {
      if (s1 == 0) v1 = 0; else v1 = GetVMagHuffCode(this);
      if (s2 == 0) v2 = 0; else v2 = GetVMagHuffCode(this); 
    }
    if (translate) {
      if (s1==1) v[i] = v1 + 0.5; 
      else if (s1==-1) v[i] = -v1 - 0.5;
      if (s2==1) v[i+4] = v2 + 0.5; 
      else if (s2==-1) v[i+4] = -v2 - 0.5;
    } else {
      v[i] = s1*v1;
      v[i+4] = s2*v2;
    }
  }
  return(1);
}

static int DecodeExtVect(Global *this, double v[8], int index) {
  int i;
  int comp, nsign, sign, signpos, type;

  if (CompBits[index]!=0) {
    comp = GetBits(this, CompBits[index]);
    if ((comp&3)==0) GetOneBit(this); /* ignore one bit, sync code faking prevention */
  }
  nsign = NSignTab[index];
  type = SignType[index];

  switch(type) {
  case 0: 
    sign = GetBits(this, nsign); 
    if ((nsign>2)&&((sign&3)==0)) GetOneBit(this); /* ignore one bit, sync code faking prevention */
    break;
  case 1: 
    sign = GetBits(this, 7); 
    if ((sign&3)==0) GetOneBit(this); /* ignore one bit, sync code faking prevention */
    sign = DecOddSignTable[sign]; 
    nsign = 8; 
    break;
  case 2: sign = GetEvenSignHuffCode(this); sign = DecEvenSignTable[sign]; nsign = 8; break;
  case 3: sign = GetAllSignsHuffCode(this); break;
  }

  if (CodingTables[index] == NULL)
    comp = 0;
  else comp = (CodingTables[index])[comp+1];

  signpos = nsign - 1;
  if (IndexSize[index]==1) {
    for (i=0; i<8; i++) {
      v[i] = MagTab[index][(comp>>(7-i))&1];
      if (v[i]!=0) {
	if (sign&(1<<signpos)) v[i] = -v[i];
	signpos--;
      }
    }
  } else {
    for (i=0; i<8; i++) {
      v[i] = MagTab[index][(comp>>(2*(7-i)))&3];
      if (v[i]!=0) {
	if (sign&(1<<signpos)) v[i] = -v[i];
	signpos--;
      }
    }
  }

  return(1);
}

int DecodeExteriorVector(Global *this, double v[8], int comp, int intra) {
  
  int index;

  if (comp==0) {
    if (intra)
      index = this->GetSPYClassHuffCode(this); 
    else
      index = this->GetTPYClassHuffCode(this); 
  } else {
    if (intra)
      index = this->GetSPCClassHuffCode(this); 
    else
      index = this->GetTPCClassHuffCode(this); 
  }

  if (index==64)
    DecodeOtherVector(this, v);
  else
    DecodeExtVect(this, v, index);

  return(1);
}


static int CountOnes(int number) {
  int n;
  int one = 0;
  for (n=0; n<8; n++) if ((1<<n)&number) one++;
  return(one);
}

static int CheckHisto(int number, int *matchhist, int size) {

  int i;
  int comp;
  int histo[4];
  int match;

  histo[0] = histo[1] = histo[2] = histo[3] = 0;

  for (i=0; i<8; i++) {
    comp = (number>>((7-i)*2))&3;
    if (comp<size) histo[comp]++;
  }

  match = 1;

  for (i=0; i<size; i++) {
    if (histo[i]!=matchhist[i]) {
      match = 0;
      break;
    }
  }
  return(match);
}

void SetupExtVectTables(int (*fn)(void *data, int count), void *data) {
  int i, count = 12;
  int ones;
  int index;
  int oddIndex = 0;
  int evenIndex = 0;
  int hist[4];
 
  if (fn) fn(data, count--);
  
  memset(DecOddSignTable, -1, 256*sizeof(int));
  memset(DecEvenSignTable, -1, 256*sizeof(int));

  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones&1) {
      DecOddSignTable[oddIndex] = i;
      oddIndex++;
    } else {
      DecEvenSignTable[evenIndex] = i;
      evenIndex++;
    }
  }

  memset(Table17, -1, 9*sizeof(int));
  Table17[0] = 8;
  index = 1;
  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones==7) {
      Table17[index++] = i;
    }
  }

  memset(Table26, -1, 29*sizeof(int));
  Table26[0] = 28;
  index = 1;
  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones==6) {
      Table26[index++] = i;
    }
  }

  memset(Table35, -1, 57*sizeof(int));
  Table35[0] = 56;
  index = 1;
  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones==5) Table35[index++] = i;
  }

  memset(Table44, -1, 71*sizeof(int));
  Table44[0]=70;
  index = 1;
  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones==4) Table44[index++] = i;
  }

  if (fn) fn(data, count--);

  hist[0] = 1; hist[1] = 1; hist[2] = 6;
  memset(Table116, -1, 57*sizeof(int));
  Table116[0]=56;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table116[index++] = i;
    }
  }

  if (fn) fn(data, count--);

  hist[0] = 1; hist[1] = 2; hist[2] = 5;
  memset(Table125, -1, 169*sizeof(int));
  Table125[0]=168;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table125[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 3; hist[2] = 4;

  if (fn) fn(data, count--);

  memset(Table134, -1, 281*sizeof(int));
  Table134[0]=280;

  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table134[index++] = i;
    }
  }

  hist[0] = 2; hist[1] = 2; hist[2] = 4;

  if (fn) fn(data, count--);

  memset(Table224, -1, 421*sizeof(int));
  Table224[0]=420;

  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table224[index++] = i;
    }
  }

  hist[0] = 2; hist[1] = 3; hist[2] = 3;

  if (fn) fn(data, count--);

  memset(Table233, -1, 561*sizeof(int));
  Table233[0] = 560;

  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table233[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 1; hist[2] = 3; hist[3] = 3;

  if (fn) fn(data, count--);

  memset(Table1133, -1, 1121*sizeof(int));
  Table1133[0] = 1120;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1133[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 1; hist[2] = 1; hist[3] = 5;

  if (fn) fn(data, count--);

  memset(Table1115, -1, 337*sizeof(int));
  Table1115[0] = 336;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1115[index++] = i;
    }
  }

  /* Component 0 occurs 1 times, component 1 2 times and so forth */
  hist[0] = 1; hist[1] = 2; hist[2] = 2; hist[3] = 3;

  if (fn) fn(data, count--);

  memset(Table1223, -1, 1681*sizeof(int));
  Table1223[0] = 1680;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1223[index++] = i;
    }
  }

  hist[0] = 2; hist[1] = 2; hist[2] = 2; hist[3] = 2;

  if (fn) fn(data, count--);

  memset(Table2222, -1, 2521*sizeof(int));
  Table2222[0] = 2520;

  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table2222[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 1; hist[2] = 2; hist[3] = 4;

  if (fn) fn(data, count--);

  memset(Table1124, -1, 841*sizeof(int));
  Table1124[0] = 840;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1124[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 2; hist[2] = 2; hist[3] = 3;

  if (fn) fn(data, count--);

  memset(Table1223, -1, 1681*sizeof(int));
  Table1223[0] = 1680;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1223[index++] = i;
    }
  }

  if (fn) fn(data, count--);

}
