#include <string.h>
#include "global.h"
#include "extern.h"
#include "debug.h"

#include "Input.h"
#include "Headers.h"
#include "Buffers.h"	/* InitBuffers */

static void ResetSequenceHeader(Global *this)
{
  memset(&(this->SeqHdr),0, sizeof(SequenceHeaderStruct));
}

static void ResetPictureHeader(Global *this)
{
  memset(&(this->PictHdr),0,sizeof(PictureHeaderStruct));
}

void ResetLayerHeader(Global *this)
{
  memset(&(this->LayerHdr),0,sizeof(LayerHeaderStruct));
}

void DecodeSequenceHeader(Global *this)
{
  int i;

  ResetSequenceHeader(this);

  this->SeqHdr.HSize = GetBits(this, 12);  
  this->SeqHdr.VSize = GetBits(this, 12);  

  this->SeqHdr.Layers = GetBits(this, 3);

  for (i=0; i<this->SeqHdr.Layers; i++)
    this->SeqHdr.BlockWidth[i] = GetBits(this, 5);

  for (i=0; i<this->SeqHdr.Layers; i++)
    this->SeqHdr.BlockHeight[i] = GetBits(this, 5);

  for (i=0; i<this->SeqHdr.Layers; i++)
    this->SeqHdr.XSubsamp[i] = GetBits(this, 5);

  for (i=0; i<this->SeqHdr.Layers; i++)
    this->SeqHdr.YSubsamp[i] = GetBits(this, 5);

  for (i=0; i<this->SeqHdr.Layers; i++)
    this->SeqHdr.IPreset[i] = GetBits(this, 8);

  for (i=0; i<this->SeqHdr.Layers; i++)
    this->SeqHdr.PPreset[i] = GetBits(this, 8);

  for (i=0; i<this->SeqHdr.Layers; i++)
    this->SeqHdr.BPreset[i] = GetBits(this, 8);
}

void DecodePictureHeader(Global *this)
{
  /* int err; */

  ResetPictureHeader(this);

  this->PictHdr.TempRef = GetBits(this, 8);
  this->PictHdr.CodingType = GetBits(this, 2);

  /*
  if ((this->PictHdr.CodingType<1) || (this->PictHdr.CodingType>3))
    longjmp(PictureSyncEnv,1); 

  err = setjmp (LowestLayerSyncEnv);
  if (err) {
#ifdef REPORT_NOSYNC
    fprintf(stderr,"*** Lost sync ... Trying to resync on lowest layer\n");
#endif
    GotoSync();
  } 
  */
}

int DecodeSequenceSetup(Global *this) 
{

  this->SyncCode = NextSequenceStartCode(this);

  if (this->SyncCode == -1) {
    debug("No more sequences in bitstream\n");
    return(0);
  }

  DecodeSequenceHeader(this);

  InitBuffers(this);
  this->FwdMV = NewVectorField(this);
/*  ComputeMVScaling(); */

  return(1);
}
