#include <string.h>

#include "Image.h"

int gprint_on = 0;	/* global o.k. only for debug */

/* ========================================================================================== */

static ImagePtr NewImage(int w, int h) {
  ImagePtr tmp;

  tmp = NEW(ImageStruct);
  tmp->w = w;
  tmp->h = h;
  tmp->ow = w;
  tmp->oh = h;
  tmp->size = tmp->w*tmp->h;

  tmp->data = NEWELEMS(Byte, tmp->w*tmp->h);
  memset(tmp->data,0, tmp->size);
  return(tmp);
}

static void DeleteImage(ImagePtr image) {
  free(image->data);
  free(image);
}

/* ========================================================================================== */

FramePtr NewFrame(int w, int h) {
  FramePtr tmp;

  tmp = NEW(FrameStruct);

  tmp->Y = NewImage(w, h);
  tmp->U = NewImage((w+1)/2, (h+1)/2);
  tmp->V = NewImage((w+1)/2, (h+1)/2);

  return(tmp);
}

/* ========================================================================================== */

void DeleteFrame(FramePtr frame) {
  DeleteImage(frame->Y);
  DeleteImage(frame->U);
  DeleteImage(frame->V);
  free(frame);
}

/* ========================================================================================== */

PyramidPtr NewPyramid(int w, int h, int size) {
  int i;
  PyramidPtr tmp;

  tmp = NEW(PyramidStruct);
  tmp->Layer = (FramePtr *) malloc (size*sizeof(void *));
  tmp->size = size;

  for (i=0; i<size; i++) {
    tmp->Layer[i] = NewFrame((w + ((1<<i)>>1)) / (1<<i), (h + ((1<<i)>>1)) / (1<<i));
  }
  return(tmp);
}

void DeletePyramid(PyramidPtr pyra) {

  int i;

  for (i=0; i<pyra->size; i++) {
    DeleteFrame(pyra->Layer[i]);
  }

  free(pyra);
}

/* ========================================================================================== */

void PrintIntBlock(int *data, char *comm, int n, int size) {
  int i;

  if (gprint_on) {
    fprintf(stderr,"\n%s %d\n", comm, n);

    for (i=0; i<size; i++)
      fprintf(stderr,"%3d ", data[i]);
  }
}

void PrintFloatBlock(double *data, char *comm, int n, int size) {
  int i;

  if (gprint_on) {
    fprintf(stderr,"\n%s %d\n", comm, n);

    for (i=0; i<size; i++)
      fprintf(stderr,"%4.1f ", data[i]);
  }
}

