#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "Util.h"
#include "DataTypes.h"

#include "global.h"
#include "extern.h"	/* Common Functions */
#include "display.h"	/* init_display */

#include "Process.h"	/* ProcessPicture() */
#include "Input.h"
#include "audio.h"	/* PlayAudioPacket() */
#include "debug.h"

/* #define CHECK_SYNC  */
/* #define COUNT_BITS */

#define BITLEFT_MIN 16

static unsigned int msk[33] =
{
  0x00000000,0x00000001,0x00000003,0x00000007,
  0x0000000f,0x0000001f,0x0000003f,0x0000007f,
  0x000000ff,0x000001ff,0x000003ff,0x000007ff,
  0x00000fff,0x00001fff,0x00003fff,0x00007fff,
  0x0000ffff,0x0001ffff,0x0003ffff,0x0007ffff,
  0x000fffff,0x001fffff,0x003fffff,0x007fffff,
  0x00ffffff,0x01ffffff,0x03ffffff,0x07ffffff,
  0x0fffffff,0x1fffffff,0x3fffffff,0x7fffffff,
  0xffffffff
};

/*
static void ShowBits(val, size)
     long val;
     int size;
{
  int i;

  for (i=size-1; i>=0; i--)
    printf("%d", (int) (val>>i)&1);

  printf("\n");
}
*/

/*
static unsigned long ByteCount = 0;
static unsigned long SyncPositions[256];
*/


/* ============================================================================== */
#ifndef PICTBUF
static void FillBuffer(Global *this) {
#ifdef PICTBUF
  debug("bogus call to FillBuffer()\n");
  return;	/* buffer must be a complete picture, no need to refill! */
#else
  int WordsLeft;
  bitbuf *BBS = this->BBS;

  if (! BBS->streamEOF) {

    WordsLeft = (BBS->BufLast + 2) - BBS->BufNext; 

    memcpy(BBS->InputBuffer, BBS->BufNext, WordsLeft * 2);

    BBS->DataGot = fread(BBS->InputBuffer + WordsLeft, sizeof(unsigned short),
                         BBS->BufSize - WordsLeft, BBS->InputFile);
    if (BBS->DataGot < (BBS->BufSize - WordsLeft))
      BBS->streamEOF = 1;

    BBS->BufLast = &BBS->InputBuffer[WordsLeft + BBS->DataGot - 2];
    BBS->BufNext = BBS->InputBuffer;
  }
#endif
}
#endif

void InitBitBufferOdd (Global *this, unsigned int byte) {
  bitbuf *BBS = this->BBS;

  BBS->BitBuffer = (BBS->BitBuffer << 24) | ((byte & 0xff) << 16) |
		   *(BBS->BufNext++);
  BBS->BitsLeft = 24;			/* XXX: should this be 26? jw. */
}

void InitBitBuffer (Global *this) {
  bitbuf *BBS = this->BBS;

  BBS->BitBuffer = (BBS->BitBuffer << 16) |  *(BBS->BufNext++);
  BBS->BitsLeft = 16;			/* XXX: why can't this be 16? jw. */

#ifndef PICTBUF
  if (BBS->BufNext > BBS->BufLast) FillBuffer(this);
#endif
}

#ifndef PICTBUF
void 
RewindInputBitstream(Global *this)
{
  bitbuf *BBS = this->BBS;

  if (BBS != NULL)
    {
      rewind(BBS->InputFile);

      /* duplicated code from OpenInputBitstream */
      BBS->ZeroBits = 0;
      BBS->streamEOF = 0;
      BBS->BitBuffer = 0;
      BBS->BitsLeft = 0;
      BBS->OverallBits = 0;
      BBS->OverallBytes = 0;
      BBS->DecodedDataBits = 0;

      BBS->DataGot = fread (BBS->InputBuffer, 2, BBS->BufSize, BBS->InputFile); 

      if (BBS->DataGot==0) EXIT_WITH_ERR("Out of Bits");

      BBS->BufNext = BBS->InputBuffer;

      BBS->BufLast = &BBS->InputBuffer[BBS->DataGot - 2];

    }
}
#endif

void CloseInputBitstream(Global *this) {
  bitbuf *BBS = this->BBS;

  if (BBS != NULL) {
    if (BBS->InputFile)
      fclose(BBS->InputFile);
#ifdef PICTBUF
    if (BBS->buf)
      free(BBS->buf);
#endif
    if (BBS->InputFileName)
      free(BBS->InputFileName);
    free(BBS);
    this->BBS = NULL;
  }
}

#ifndef PICTBUF
void OpenInputBitstream(Global *this, String name, int BufferSize)
{
  bitbuf *BBS = (bitbuf *)malloc(sizeof(bitbuf) + (BufferSize & ~0x01));

  this->BBS = BBS;
  BBS->InputFile = fopen(name,"r"); 
  BBS->InputFileName = strdup(name);
  if (BBS->InputFile == NULL) {
    debug1("%s: ", name);
    free(BBS);
    EXIT_WITH_ERR("Cannot open input file"); 
  }

  BBS->ZeroBits = 0;
  BBS->streamEOF = 0;
  BBS->BitBuffer = 0;
  BBS->BitsLeft = 0;
  BBS->OverallBits = 0;
  BBS->OverallBytes = 0;
  BBS->DecodedDataBits = 0;

  BBS->BufSize = (BufferSize / 2);

  BBS->DataGot = fread (BBS->InputBuffer, 2, BBS->BufSize, BBS->InputFile); 

  if (BBS->DataGot==0) EXIT_WITH_ERR("Out of Bits");

  BBS->BufNext = BBS->InputBuffer;

  BBS->BufLast = &BBS->InputBuffer[BBS->DataGot - 2];

  InitBitBuffer(this);
}
#else
void SetupInputBitstream(Global *this, String name, int BufferSize)
{
  bitbuf *BBS = (bitbuf *)malloc(sizeof(bitbuf));

  this->BBS = BBS;
  BBS->InputFileName = strdup(name);	/* possibly only an URL */
  BBS->InputFile = NULL;	/* have no FILE ptr then */

  BBS->ZeroBits = 0;
  BBS->streamEOF = 0;
  BBS->BitBuffer = 0;
  BBS->BitsLeft = 0;
  BBS->OverallBits = 0;
  BBS->OverallBytes = 0;
  BBS->DecodedDataBits = 0;

  BBS->BufSize = (BufferSize / 2);
  BBS->buf = NULL;	/* to be initialized before calling ProcessPicture */
}

int FindPictureSync(buf, n, s)
unsigned char *buf;
int n;
int *s;
{
   unsigned char *p = buf;
   unsigned char *e = p + n - 2;
   int t;

   while (p < e)
     {
       if ((*p == 0x00) && (p[1] == 0x00) && (((t = p[2]) & 0xff) == 1))
         {
	   t = p[3];
	   /* find only picture sync or sequence end words */
           if (((t & SYNC_MASK) == PICTURE_START_CODE) ||
	       (t == SEQUENCE_END_CODE))
	     {
	       *s = t;
	       return p - buf;
	     }
         }
       p++;
     }
   return -1;
}
#endif

#if 0
static void CheckSync(Global *this) {
  bitbuf *BBS = this->BBS;

  if ( (BBS->BitBuffer & 0x00ffffff) == 1) {
#ifdef REPORT_NOSYNC
    debug("Probably behind sync"); 
#endif
    longjmp(ResyncEnv,1);
  }
}
#endif


int GetOneBit(Global *this)
{
  bitbuf *BBS = this->BBS;
  int bit;

#ifdef COUNT_BITS
  BBS->DecodedDataBits++;
  BBS->OverallBits++;
#endif

  BBS->BitsLeft--;
  bit = ((BBS->BitBuffer>>BBS->BitsLeft)&1);

#ifdef CHECK_SYNC
  if ((bit==1)&&(BBS->ZeroBits==23)) {
    debug("++ GetOneBit: Unexpected Sync ++\n");
    BBS->ZeroBits = 0;
  }

  if (bit==0) {
    BBS->ZeroBits++;
  } else BBS->ZeroBits=0;
#endif

  if (BBS->BitsLeft < BITLEFT_MIN) {
    /*    CheckSync(this); */
#ifdef PICTBUF
    if (BBS->BufNext > BBS->BufLast)
      abort();	/* buffer must be a complete picture, but was not! */
#endif
    BBS->BitBuffer = (BBS->BitBuffer<<16) | *(BBS->BufNext++);
    BBS->BitsLeft += 16;
    /* Check underflow */
#ifndef PICTBUF
    if (BBS->BufNext > BBS->BufLast) FillBuffer(this);
#endif
  }
  return(bit);
}

int GetBits(Global *this, int n)
{
  bitbuf *BBS = this->BBS;
  int val;

#ifdef COUNT_BITS
  BBS->OverallBits += n;
  BBS->DecodedDataBits += n;
#endif

  BBS->BitsLeft -= n;
  val = (BBS->BitBuffer >> BBS->BitsLeft) & msk[n];
  
  while (BBS->BitsLeft < BITLEFT_MIN) {
/*    CheckSync(this); */
#ifdef PICTBUF
    if (BBS->BufNext > BBS->BufLast)
      abort();	/* buffer must be a complete picture, but was not! */
#endif
    BBS->BitBuffer = (BBS->BitBuffer<<16) | *(BBS->BufNext++);
    BBS->BitsLeft += 16;
#ifndef PICTBUF
    if (BBS->BufNext>BBS->BufLast) FillBuffer(this);
#endif
  }

  return(val);
}

int CheckBits(Global *this, int n) {
  bitbuf *BBS = this->BBS;

  return ((BBS->BitBuffer >> (BBS->BitsLeft-n)) & msk[n]);
}

void ConsumeBits(Global *this, int n) {
  bitbuf *BBS = this->BBS;

#ifdef COUNT_BITS
  BBS->OverallBits += n;
  BBS->DecodedDataBits += n;
#endif

  BBS->BitsLeft -= n;
  if (BBS->BitsLeft < BITLEFT_MIN) {
/*    CheckSync(this); */
    BBS->BitBuffer = (BBS->BitBuffer<<16) | *(BBS->BufNext++);
    BBS->BitsLeft += 16;
#ifndef PICTBUF
    if (BBS->BufNext > BBS->BufLast) FillBuffer(this);
#endif
  }
}

unsigned long GetOverallBits(Global *this) {
  bitbuf *BBS = this->BBS;

  return(BBS->OverallBits);
}

unsigned long GetDecodedDataBits(Global *this) {
  bitbuf *BBS = this->BBS;

  return(BBS->DecodedDataBits);
}

static int SearchSync(Global *this)
{
  bitbuf *BBS = this->BBS;
  int tmp;

  BBS->OverallBits += (BBS->BitsLeft & 0x07);

#if 1
  if (BBS->BufNext > BBS->BufLast + 10) abort();
#endif

  while (1) {
    if((BBS->BitBuffer & 0x00ffffff) == 0x1) {
      tmp = (*(BBS->BufNext++) >> 8) & 0xff;
#ifdef COUNT_BITS
      BBS->OverallBits += 32;
#endif
      InitBitBufferOdd(this, *(BBS->BufNext-1)&0xff);
      /* InitBitBuffer(this); */
      break;
    }
    /* sync-word is misaligned */
    else if((BBS->BitBuffer & 0xffffff00) == 0x0100) {
      tmp = (BBS->BitBuffer) & 0xff;
#ifdef COUNT_BITS
      BBS->OverallBits += 24;
#endif
      InitBitBuffer(this);
      break;
    }
    BBS->BitBuffer = (BBS->BitBuffer<<16) | *(BBS->BufNext++);
#ifndef PICTBUF
    if (BBS->BufNext > BBS->BufLast) FillBuffer(this);
#endif
#ifdef COUNT_BITS
    BBS->OverallBits += 16;
#endif
    if (BBS->streamEOF & (BBS->BufNext > BBS->BufLast + 1)) {
      /* debug("Unexpected EOF\n"); */
      return(SEQUENCE_END_CODE);
    }
  }
  this->NextSyncPos++;
  return(tmp);
}

int GotoSync(Global *this)
{
  this->SyncCode = SearchSync(this);
  return(this->SyncCode);
}

int NextPictureStartCode(Global *this) {
  
#ifdef VERBOSE
  int message = 0;
#endif

 SEARCH_PICTURE:
  this->SyncCode = SearchSync(this);

  if (( (this->SyncCode & SYNC_MASK) == PICTURE_START_CODE) 
      || (this->SyncCode == SEQUENCE_END_CODE)) {
    return(this->SyncCode);
  }
#ifdef VERBOSE
  if (! message) {
    debug("*** Skipping bits until next picture start code\n");
    message = 1;
  }
#endif
  goto SEARCH_PICTURE;
}

int NextLayerStartCode(Global *this) {

#ifdef VERBOSE
  int message = 0;
#endif

  if (this->SyncCode == LAYER_START_CODE) {
    return(this->SyncCode);
  }

 SEARCH_LAYER:
  this->SyncCode = SearchSync(this);

  if (this->SyncCode == LAYER_START_CODE) {
    return( this->SyncCode );
  }

  if (( (this->SyncCode & SYNC_MASK) == PICTURE_START_CODE) 
      || (this->SyncCode == SEQUENCE_END_CODE))
    return( this->SyncCode );
#ifdef VERBOSE
  if (! message) {
    debug("*** Skipping bits until next layer start code\n");
    message = 1;
  }
#endif
  goto SEARCH_LAYER;
}


int NextSequenceStartCode(Global *this) {
  bitbuf *BBS = this->BBS;
#ifdef VERBOSE
  int message = 0;
#endif

  if (BBS->streamEOF) return(-1);

 SEARCH_SEQUENCE:
  
  this->SyncCode = SearchSync(this);

  if ((this->SyncCode == SEQUENCE_START_CODE) || (this->SyncCode == SEQUENCE_END_CODE)) {
    return(this->SyncCode);
  }
#ifdef VERBOSE
  if (! message) {
    debug("*** Skipping bits until next picture start code\n");
    message = 1;
  }
#endif
  goto SEARCH_SEQUENCE;
}

static void SyntaxError(Global *this, char *tabname) {

  debug2("VLC error in table %s detected at bit %lu.\n", tabname, GetOverallBits(this));
  exit(1);
}

/*
#include "DecodeSymbolNeu.c"
*/

#include "DecodeSymbolFast.c"
