#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "Util.h"
#include "DataTypes.h"

#include "global.h"
#include "extern.h"	/* Common Functions */
#include "display.h"	/* init_display */

#include "Process.h"	/* ProcessPicture() */
#include "Input.h"
#include "Buffers.h"	/* InitBuffers */
#include "Headers.h"	/* DecodeSequenceHeader */
#include "audio.h"	/* PlayAudioPacket() */
#include "debug.h"

static void DisplayFrame(Global *this, PyramidPtr thePyra) 
{
  if (this->Options.audio)
    WaitForCompletion(this->Options.fps, this->PictHdr.TempRef);
  if (this->Options.display) {
    if ((this->Options.qcif==1)&&(this->Options.visexpand==0))
      yuv2rgb(this, thePyra->Layer[1]);
    else
      yuv2rgb(this, thePyra->Layer[0]);
  }
}

static int ProcessAudio(this, ptr)
Global *this;
unsigned char *ptr;
{
  int len = (ptr[0] << 8) + ptr[1];
  
  ptr += 2;
  debug2("%04d: ProcessAudio: %d bytes\n", this->PictHdr.TempRef, len);
  if (this->Options.audio)
    PlayAudioPacket(len, ptr);
  return len + 2;
}

int ProcessPicture(this, ptr, n, o)
Global *this;
unsigned char *ptr;
int n;
unsigned long o;
{
  bitbuf *BBS = this->BBS;
#ifdef DEBUG
  int t;

  t = (ptr[2] & 0x7c) >> 2;
  debug3("ProcessPicture: Frame start: %08d: %02x%02x ",
         (int)o, ptr[0], ptr[1]);
  debug3("%02x%02x, type %d, ", ptr[2], ptr[3], t);
  debug1("size %d\n", n);
#endif

  if (((ptr[3] & SYNC_MASK) == PICTURE_START_CODE) &&
      (ptr[3] & (1<<3)))
    {
      int b = ProcessAudio(this, ptr+4);

      if (b)
	{
	  ptr[b]   = ptr[0];
	  ptr[b+1] = ptr[1];
	  ptr[b+2] = ptr[2];
	  ptr[b+3] = ptr[3];
	  ptr += b;
	  n -= b;
	  o += b;
	}
    }


  BBS->BufLast = (unsigned short *)(((unsigned long)(ptr+n+1+2)) & ~1);
  BBS->BufNext = (unsigned short *)(((unsigned long)(ptr+  1  )) & ~1);
  BBS->DataGot = (n+2)/2;
  if ((unsigned long)ptr & 1)
    InitBitBufferOdd(this, (unsigned int)*ptr);
  else
    InitBitBuffer(this);

  if (!o)
    {
      DecodeSequenceSetup(this);
      if (this->Options.display)
	init_display(this, 
		     this->SeqHdr.HSize/(1+this->Options.qcif), 
		     this->SeqHdr.VSize/(1+this->Options.qcif));
      SetStartTime();
      return 0;
    }

  /* the Initialized BitBuffer holds a picture sync word */
  this->SyncCode = NextPictureStartCode(this);

  SetFrameStart();

  if (( this->SyncCode == SEQUENCE_END_CODE ) ||
      ( (this->SyncCode & SYNC_MASK) != PICTURE_START_CODE ))
    {
      /* SEQUENCE_END: */
#ifdef DEBUG
      if (this->SyncCode != SEQUENCE_END_CODE)
        debug("Can't sync to picture start\n");
#endif
#if 0
      debug1("%d frames decoded\n", this->PictHdr.TempRef+1);
      PrintTimeInfo(this->PictHdr.TempRef+1);
#endif

      CloseInputBitstream(this);

      if (this->Options.display)
	exit_display(this);
      return 0;
    }

  this->LowestLayer = this->SyncCode & 0x3;

  if (this->Options.qcif && this->LowestLayer<1)
    {
      return 0;
    }

  DecodePictureHeader(this);

  switch (this->PictHdr.CodingType) 
    {
    case 1:
      switch (this->BuffState) {
      case 0:
	/*      ReadYUVRawFormat("/SUN_HOME/mit/cids/mpeg4_vm/anchor/fm112/", 0, this->PastDecoded->Layer[0]);  */
	/* this->SyncCode = GotoSync(); */
	DecodeIPicture(this, this->PastDecoded, this->PastSPInter, this->PictHdr.TempRef, this->LowestLayer);
  /*
	ReadYUVKhorosFormat("stud263.0", 1, this->PastDecoded->Layer[0]); 
	ReadYUVKhorosFormat("stud263.1", 1, this->PastDecoded->Layer[1]);
  */
	DisplayFrame(this, this->PastDecoded);

	/* sleep(10); */
	this->BuffState = 1;
	break;
      case 1:
	DecodeIPicture(this, this->FutrDecoded, this->FutrSPInter, this->PictHdr.TempRef, this->LowestLayer);
	DisplayFrame(this, this->FutrDecoded);
	this->BuffState = 2;
	break;
      case 2:
	DecodeIPicture(this, this->FutrDecoded, this->FutrSPInter, this->PictHdr.TempRef, this->LowestLayer);
	DisplayFrame(this, this->FutrDecoded);

	break;
      }
      break;
    case 2:
      switch (this->BuffState) {
      case 0: break;
      case 1:
	DecodePPicture(this, this->FutrDecoded, this->PastDecoded, this->PastSPInter, this->PictHdr.TempRef, this->LowestLayer); 
	DisplayFrame(this, this->FutrDecoded);
	this->BuffState = 2;
	break;
      case 2:
	DecodePPicture(this, this->FutrDecoded, this->PastDecoded, this->PastSPInter, this->PictHdr.TempRef, this->LowestLayer); 
	DisplayFrame(this, this->FutrDecoded);
	break;
      }
      break;
    case 3:
      switch (this->BuffState) {
      case 0:
      case 1: break;
      case 2:
	break;
      }
      break;
    }

  if (!this->Options.audio && this->Options.fps)
    doframerate(this->Options.fps);

  return 0;
}
