#include <sys/time.h>
#include <stdio.h>
#include "global.h"
#include "extern.h"

static double realTimeStart;

static double ReadSysClock()
{
  struct timeval tv;
  gettimeofday(&tv, (struct timezone *)NULL);
  return (tv.tv_sec + tv.tv_usec / 1000000.0);
}

void SetStartTime() {
  realTimeStart = ReadSysClock();
}

double GetTimeInfo() {
  return ReadSysClock() - realTimeStart;
}

void PrintTimeInfo(int n) {

  double spent;

  spent = GetTimeInfo();

  fprintf(stderr,"Real Time Spent: %f secs. = %5.3f pictures/sec. \n", spent, n/spent);
}

static struct timeval tftarget;

void SetFrameStart() {
  gettimeofday(&tftarget,(struct timezone *)NULL);
}

void doframerate(int framerate)
{
  struct timeval tfdiff;

  /* Compute desired frame rate */
  if (framerate <= 0)
    return;
  tftarget.tv_usec += 1000000 / framerate;

  /* this is where we should be */
  if (tftarget.tv_usec >= 1000000)
  {
    tftarget.tv_usec -= 1000000;
    tftarget.tv_sec++;
  }

  /* this is where we are */
  gettimeofday(&tfdiff,(struct timezone *)NULL);

  tfdiff.tv_usec = tftarget.tv_usec - tfdiff.tv_usec;
  tfdiff.tv_sec  = tftarget.tv_sec  - tfdiff.tv_sec;
  if (tfdiff.tv_usec < 0)
  {
    tfdiff.tv_usec += 1000000;
    tfdiff.tv_sec--;
  }

  /* See if we are already lagging behind */
  if (tfdiff.tv_sec < 0 || (tfdiff.tv_sec == 0 && tfdiff.tv_usec <= 0))
    return;
  
  /* Spin for awhile */
  select(0,NULL,NULL,NULL,&tfdiff);
}
