#include <string.h>
#include "options.h"
#include "VLC.h"

static void InitHuffTable (VLCTree **code_table, String name, int size)
{
  int i;

  (*code_table) =  NEW(VLCTree);

  if ((*code_table) == NULL)
    EXIT_WITH_ERR ("Malloc failed");
  
  sprintf((*code_table)->name,"%s",name);
  (*code_table)->size = size;
  (*code_table)->maxlength = 0;

  (*code_table)->histo = NEWELEMS(unsigned long, size);
  memset((*code_table)->histo, 0, size*sizeof(long));

  (*code_table)->Encoder = NEWELEMS(VLCNodePtr, size);

  if ((*code_table)->Encoder == NULL)
    EXIT_WITH_ERR ("Malloc failed");

  for (i=0; i<size; i++)
    (*code_table)->Encoder[i] = NULL;

  (*code_table)->Decoder = NEW(VLCNodeStruct);

  (*code_table)->Decoder->Next[0] = NULL;
  (*code_table)->Decoder->Next[1] = NULL;
  (*code_table)->Decoder->HasSon = false;
  (*code_table)->Decoder->Symbol  = 0;
  (*code_table)->Decoder->length  = 0;
}

static void DefineVLC (String bitstring, int val, VLCTree *code_table)
{
  int index, length;
  unsigned long code;
  char c;
  VLCNodeStruct *node;

  node = code_table->Decoder;

  code = length = index = 0;

  while ( (c = *bitstring++) != '\0' ) {

    switch (c) {
    case '1':
      index = 1;
      break;
    case '0':
      index = 0;
      break;
    case ' ':
      index = -1;
      break;
    default:
      fprintf(stderr,"Unknown char in bitstring %c\n", c);
    }
    if ( index != -1 ) {
      length++;
      code = (code << 1) | (unsigned long) index;
      if ( node->Next[index] == NULL) {
	node->Next[index] = NEW(VLCNodeStruct);

	if ( node->Next[index] == NULL )
	  EXIT_WITH_ERR("Malloc failed");

	node->Next[index]->Next[0] = NULL;
	node->Next[index]->Next[1] = NULL;
	node->Next[index]->HasSon = false;
	node->HasSon = 1;
      }
      node = node->Next[index];
    }
  }
  node->Code = code;
  node->Symbol = val;
  node->length = length;

  if (length > code_table->maxlength)
    code_table->maxlength = length;

  code_table->Encoder[val] = node;

}
void DefineHuffTables() {

  InitHuffTable(&MVHuffCode,"MVHuffCode", 64);

  DefineVLC("0000000000101",  0, MVHuffCode);
  DefineVLC("0000000000111",  1, MVHuffCode);
  DefineVLC("000000000101",  2, MVHuffCode);
  DefineVLC("000000000111",  3, MVHuffCode);
  DefineVLC("000000001001",  4, MVHuffCode);
  DefineVLC("000000001011",  5, MVHuffCode);
  DefineVLC("000000001101",  6, MVHuffCode);
  DefineVLC("000000001111",  7, MVHuffCode);
  DefineVLC("00000001001",  8, MVHuffCode);
  DefineVLC("00000001011",  9, MVHuffCode);
  DefineVLC("00000001101", 10, MVHuffCode);
  DefineVLC("00000001111", 11, MVHuffCode);
  DefineVLC("00000010001", 12, MVHuffCode);
  DefineVLC("00000010011", 13, MVHuffCode);
  DefineVLC("00000010101", 14, MVHuffCode);
  DefineVLC("00000010111", 15, MVHuffCode);
  DefineVLC("00000011001", 16, MVHuffCode);
  DefineVLC("00000011011", 17, MVHuffCode);
  DefineVLC("00000011101", 18, MVHuffCode);
  DefineVLC("00000011111", 19, MVHuffCode);
  DefineVLC("00000100001", 20, MVHuffCode);
  DefineVLC("00000100011", 21, MVHuffCode);
  DefineVLC("0000010011", 22, MVHuffCode);
  DefineVLC("0000010101", 23, MVHuffCode);
  DefineVLC("0000010111", 24, MVHuffCode);
  DefineVLC("00000111", 25, MVHuffCode);
  DefineVLC("00001001", 26, MVHuffCode);
  DefineVLC("00001011", 27, MVHuffCode);
  DefineVLC("0000111", 28, MVHuffCode);
  DefineVLC("00011", 29, MVHuffCode);
  DefineVLC("0011", 30, MVHuffCode);
  DefineVLC("011", 31, MVHuffCode);
  DefineVLC("1", 32, MVHuffCode);
  DefineVLC("010", 33, MVHuffCode);
  DefineVLC("0010", 34, MVHuffCode);
  DefineVLC("00010", 35, MVHuffCode);
  DefineVLC("0000110", 36, MVHuffCode);
  DefineVLC("00001010", 37, MVHuffCode);
  DefineVLC("00001000", 38, MVHuffCode);
  DefineVLC("00000110", 39, MVHuffCode);
  DefineVLC("0000010110", 40, MVHuffCode);
  DefineVLC("0000010100", 41, MVHuffCode);
  DefineVLC("0000010010", 42, MVHuffCode);
  DefineVLC("00000100010", 43, MVHuffCode);
  DefineVLC("00000100000", 44, MVHuffCode);
  DefineVLC("00000011110", 45, MVHuffCode);
  DefineVLC("00000011100", 46, MVHuffCode);
  DefineVLC("00000011010", 47, MVHuffCode);
  DefineVLC("00000011000", 48, MVHuffCode);
  DefineVLC("00000010110", 49, MVHuffCode);
  DefineVLC("00000010100", 50, MVHuffCode);
  DefineVLC("00000010010", 51, MVHuffCode);
  DefineVLC("00000010000", 52, MVHuffCode);
  DefineVLC("00000001110", 53, MVHuffCode);
  DefineVLC("00000001100", 54, MVHuffCode);
  DefineVLC("00000001010", 55, MVHuffCode);
  DefineVLC("00000001000", 56, MVHuffCode);
  DefineVLC("000000001110", 57, MVHuffCode);
  DefineVLC("000000001100", 58, MVHuffCode);
  DefineVLC("000000001010", 59, MVHuffCode);
  DefineVLC("000000001000", 60, MVHuffCode);
  DefineVLC("000000000110", 61, MVHuffCode);
  DefineVLC("000000000100", 62, MVHuffCode);
  DefineVLC("0000000000110", 63, MVHuffCode);

  InitHuffTable(&PLowPredTypeHuffCode,"PLowPredTypeHuffCode", 4);

  DefineVLC ("01", 0, PLowPredTypeHuffCode);
  DefineVLC ("00", 1, PLowPredTypeHuffCode);
  DefineVLC ("11", 2, PLowPredTypeHuffCode);
  DefineVLC ("10", 3, PLowPredTypeHuffCode);

  InitHuffTable(&PPredTypeHuffCode,"PPredTypeHuffCode", 4);

  DefineVLC ("010", 0, PPredTypeHuffCode);
  DefineVLC ("011", 1, PPredTypeHuffCode);
  DefineVLC ("10", 2, PPredTypeHuffCode);
  DefineVLC ("11", 3, PPredTypeHuffCode);

  InitHuffTable(&MeanSizeHuffCode,"MeanSizeHuffCode", 9);

  DefineVLC ("011", 0, MeanSizeHuffCode);
  DefineVLC ("010", 1, MeanSizeHuffCode);
  DefineVLC ("11", 2, MeanSizeHuffCode);
  DefineVLC ("10", 3, MeanSizeHuffCode);
  DefineVLC ("001", 4, MeanSizeHuffCode);
  DefineVLC ("0001 ", 5, MeanSizeHuffCode);
  DefineVLC ("0000 1", 6, MeanSizeHuffCode);
  DefineVLC ("0000 01", 7, MeanSizeHuffCode);
  DefineVLC ("0000 001", 8, MeanSizeHuffCode);

  InitHuffTable(&ClassHuffCode,"ClassHuffCode", 36);

  DefineVLC ("0001 11", 0, ClassHuffCode);
  DefineVLC ("11", 1, ClassHuffCode);
  DefineVLC ("10", 2, ClassHuffCode);
  DefineVLC ("0000 0011 1", 3, ClassHuffCode);
  DefineVLC ("0001 10", 4, ClassHuffCode);
  DefineVLC ("011", 5, ClassHuffCode);
  DefineVLC ("0011 ", 6, ClassHuffCode);
  DefineVLC ("0000 0011 0", 7, ClassHuffCode);
  DefineVLC ("0000 0000 0000 11", 8, ClassHuffCode);
  DefineVLC ("0000 111", 9, ClassHuffCode);
  DefineVLC ("0001 01", 10, ClassHuffCode);
  DefineVLC ("0000 0101 ", 11, ClassHuffCode);
  DefineVLC ("0010 ", 12, ClassHuffCode);
  DefineVLC ("0000 0000 0000 10", 13, ClassHuffCode);
  DefineVLC ("0000 0000 001", 14, ClassHuffCode);
  DefineVLC ("0000 110", 15, ClassHuffCode);
  DefineVLC ("0000 0010 1", 16, ClassHuffCode);
  DefineVLC ("0000 101", 17, ClassHuffCode);
  DefineVLC ("0000 0000 0000 011", 18, ClassHuffCode);
  DefineVLC ("0000 0000 0001 1", 19, ClassHuffCode);
  DefineVLC ("0000 0010 0", 20, ClassHuffCode);
  DefineVLC ("0000 100", 21, ClassHuffCode);
  DefineVLC ("0000 0000 0000 010", 22, ClassHuffCode);
  DefineVLC ("0000 0000 11", 23, ClassHuffCode);
  DefineVLC ("0000 0000 10", 24, ClassHuffCode);
  DefineVLC ("0000 011", 25, ClassHuffCode);
  DefineVLC ("0000 0000 0000 0011 ", 26, ClassHuffCode);
  DefineVLC ("0000 0000 0001 0", 27, ClassHuffCode);
  DefineVLC ("0000 0000 0000 0010 ", 28, ClassHuffCode);
  DefineVLC ("0001 00", 29, ClassHuffCode);
  DefineVLC ("0000 0001 1", 30, ClassHuffCode);
  DefineVLC ("0000 0000 0000 0001 ", 31, ClassHuffCode);
  DefineVLC ("0000 0001 0", 32, ClassHuffCode);
  DefineVLC ("0000 0000 01", 33, ClassHuffCode);
  DefineVLC ("0000 0100 ", 34, ClassHuffCode);
  DefineVLC ("010", 35, ClassHuffCode);

#include "intra.vlc"
#include "inter.vlc"
}


