#!/bin/sh
#

log=./download.log

set -f
date >> $log

# setting of NPX_PLUGIN_PATH in our /local/netscape-x.x/bin/netscape script
# shall be compatible with the following switch:
case "$HTTP_USER_AGENT" in
  Mozilla/3.0*SunOS\ 5.*\ sun4u*)	ARCH_OS=sun4u.sos5 ;;
  Mozilla/3.0*SunOS\ 5.*)		ARCH_OS=sun4.sos5 ;;
  Mozilla/3.0*SunOS\ 4.*)		ARCH_OS=sun4.sos4 ;;
  Mozilla/3.0*IRIX\ 5.*)		ARCH_OS=irix.irix5 ;;
  Mozilla/4.0b2*)			complaint="Mozilla/4.0b2 does not recognize the mime-type of embedded streams at all" ;;
  Mozilla/4.0*SunOS\ 5.*\ sun4u*)	ARCH_OS=sun4u.sos5 ;;
  *Mac*|*Win*)				complaint="You are entering UNIX World, don't expect binaries for your machine here." ;;
  *Proxy*)				complaint="Hi Proxy, what'd ya want?" ;;
  *)		 complaint="Hello stranger!" ;;
esac

echo "  HOST         = $REMOTE_HOST($REMOTE_ADDR) $HTTP_USER_AGENT" >> $log
echo "  ARCH_OS      = $ARCH_OS $complaint" >> $log
echo "  SCRIPT_URL   = $SCRIPT_URI" >> $log
echo "  HTTP_REFERER = $HTTP_REFERER" >> $log

pinfo=`echo $PATH_INFO | sed -e 's/.//'`
pat=`echo $QUERY_STRING | sed -e 's/file=//' -e 's/%2F/\//g'`

if [ -f "$pat" ]; then
  echo "  `ls -lL $pat`" >> $log
  echo Content-type: x
  echo Content-length: `wc -c < "$pat"`
  echo 
  exec cat "$pat"
fi

cat << EOF_1
Content-type: text/html

<HEADER>
<TITLE>Download architecture dependant executable $pat</TITLE>
</HEADER>

<HTML>
EOF_1

if [ -z "$pat" ]; then
  cat << EOF_2
<H1>No architecture selected</H1>
Please go back and specify your desired architecture. Thank you.
<FORM ACTION=$SCRIPT_NAME/$pinfo METHOD=get>
<INPUT TYPE=hidden NAME=file VALUE=arch.os/*/$pinfo>
<INPUT TYPE=submit VALUE=Back>
</FORM>
EOF_2
  exit
fi

file=`basename $pat`

set +f
matches=`echo $pat`
set -f

if [ "$matches" = "$pat" ]; then
  cat << EOF_3
<H1>Sorry,</H1>
<H2>$file <FONT SIZE=+1>is currently not available for any architecture.</FONT></H2>
Please try again later <FONT SIZE=-2>(Q=$QUERY_STRING, P=$PATH_INFO)</FONT>.
EOF_3
  exit
fi

cat << EOF_4
<H2>$file 
<FONT SIZE=+1>is available for the following architectures:</FONT></H2>

<FORM ACTION=$SCRIPT_NAME/$file METHOD=get>
<TABLE BORDER=0 CELLPADDING=10>
<TH align=left>architecture<TH>size<TH align=left>date</TH>
EOF_4
for i in $matches; do
  d=`dirname $i`
  f=`basename $i`
  a=`basename $d`
  c=
  ll=`ls -lL $i`
  test "$ARCH_OS" = "$a" && c=checked
  echo "<TR><TD align=left><INPUT TYPE=radio NAME=file $c VALUE=\"$i\">"
  echo "<TT><FONT SIZE=+2><A HREF=$SCRIPT_NAME/$f?$i>$a</A>"
  echo "</TT></FONT><TD align=right>`echo $ll | cut -d ' ' -f 5` bytes"
  echo "<TD align=left><TT>`echo $ll | cut -d ' ' -f 6-8`</TT></TR>"
done
echo "</TABLE><INPUT TYPE=submit VALUE=Download></FORM>"

if [ -n "$complaint" ]; then
  echo "<P>$complaint. You identify as $HTTP_USER_AGENT.<P>"
fi
case "$pinfo" in
  NPX_PLUGIN_PATH)	cat << EOF_5
<BR><BR>Please save the binary as
<blockquote><code>~/.netscape/plugins/$ARCH_OS/$file</code>
</blockquote>
(or wherever your environment variable <code>$pinfo</code> points to).
<BR><BR><BR>
Note:<BR>
<strong>To use the newly downloaded plugin, you can either click on the following line<br>
<A HREF="javascript:navigator.plugins.refresh()">javascript:navigator.plugins.refresh()</A><br>
or simply exit and restart the browser.
</strong>
<P>
EOF_5
	;;
esac


cat << EOF
<BR><BR><BR><BR><BR><HR>If your architecture is not listed, contact me.
<A HREF=mailto:Juergen.Weigert@informatik.uni-erlangen.de>Mailto:</A>
<A HREF=http://www4.informatik.uni-erlangen.de/~jnweiger>J&uuml;rgen Weigert</A>
</HTML>
EOF
