#!/bin/sh
#
# Useful environment variables are 
# ../thisscript.cgi${PATH_INFO}?${QUERY_STRING}

oifs="$IFS"
IFS="&"
set dummy $QUERY_STRING
IFS="$oifs"

want_audio=
audio=1
fps=25
width=360
height=290
qcif=
qual=CIF
size=CIF
for i in "$@"; do
  case $i in
    quality=qcif)	qual=QCIF; qcif="qcif"	;;
    display=qcif)	size=QCIF		;;
    display=raw)	raw=1			;;
    speed=unlimit*)	speed_limit=0		;;
    speed=slow*)	speed_limit=5		;;
    audio=0)		want_audio=0		;;
    audio=1)		want_audio=1		;;
    *.x=*)	name="`echo \"$i\" | sed -e 's/\.x=.*//'`"	;;
  esac
done

bname=`basename $name .pyra| sed -e 's/%26/\&amp;/'`

if [ -f "PStreams/$bname.rc" ]; then
  . PStreams/$bname.rc
fi

if [ "$want_audio" = "0" ]; then
  audio=0
fi

if [ -n "$qcif" ]; then
  fps=`expr $fps / 2`
fi

if [ -n "$speed_limit" ]; then
  fps=$speed_limit
fi

fps_name=$fps
if [ "$fps_name" = "0" ]; then
  fps_name=unlimited
fi

if [ -n "$raw" ]; then
  test -n "$qcif" && qcif="qcif" 
  cat << EOF_1
Content-type: text/html

<HTML>
<HEAD>
<TITLE> ScalVico Decoder - $name</TITLE>
<META HTTP-EQUIV="refresh" CONTENT="1; URL=PStreams.cgi/$name?raw&$qcif&audio=$audio">
</HEAD>
<BODY>
Retrieving <A HREF="PStreams.cgi/$name?raw&$qcif&audio=$audio&fps=$fps">
PStreams.cgi/$name?$qcif&audio=$audio&fps=$fps</A>...
<FORM ACTION="" METHOD=get><INPUT TYPE=submit VALUE="Back"></FORM>
</BODY>
</HTML>
EOF_1
  exit 0
fi

cat << EOF
Content-type: text/html

<HEADER>
<TITLE>ScalVico - NetClip - ntcodec - Pyramid decoder - npPDecoder.so</TITLE>
</HEADER>
<HTML>
<CENTER><H1>$bname</H1></CENTER>
<table cellpadding=20 border=0><tr>
<td><H3>Quality: <FONT SIZE=+2>$qual</H3>
<td><H3>   Size: <FONT SIZE=+2>$size</H3>
<TD><H3>    Fps: <FONT SIZE=+2>$fps_name</H3>
</table>
<p>
<EMBED type=video/x-netclip2 height=$height width=$width audio=$audio fps=$fps $size src=PStreams.cgi/$name?$qcif&audio=$audio&fps=$fps PLUGINSPAGE=trampolin.html>

<HR>
<FORM ACTION="" METHOD=get><INPUT TYPE=submit VALUE="Back"></FORM>
</HTML>
EOF
