#ifndef _IMAGE_
#define _IMAGE_

#include "DataTypes.h"
#include "Util.h"

typedef struct {
  Byte *data;
  int ow, oh;
  int w,h;
  long size;
} ImageStruct;

typedef ImageStruct *ImagePtr;

typedef struct { 
  int TempRef;
  int SeqIndex;
  ImagePtr Y;
  ImagePtr U;
  ImagePtr V;
  void *thread_data;	/* this is a pointer is a pointer is a pointer */
} FrameStruct;

typedef FrameStruct *FramePtr;

typedef struct {
  int size;
  int LowestLayer;
  FramePtr *Layer;
} PyramidStruct;

typedef PyramidStruct *PyramidPtr;

PyramidPtr NewPyramid(int w, int h, int size);
FramePtr NewFrame(int w, int h);
void DeleteFrame(FramePtr frame);

GLOBAL int gprint_on;

void PrintIntBlock(int *data, char *comm, int n, int size);
void PrintFloatBlock(double *data, char *comm, int n, int size);

#endif
