#ifndef _INPUT_H
#define _INPUT_H

#include <setjmp.h>
#include "Util.h"
#include "DataTypes.h"

#define PICTBUF		/* essential for becoming a library */
/* #define REPORT_NOSYNC */

#ifdef PICTBUF
extern void SetupInputBitstream(Global *this, String name, int size);
extern int FindPictureSync(unsigned char *buf, int len, int *syncbits);
#else
extern void OpenInputBitstream(Global *this, String name, int size);
extern void RewindInputBitstream(Global *this);
#endif
extern void CloseInputBitstream(Global *this);
extern void InitBitBufferOdd (Global *this, unsigned int byte);
extern void InitBitBuffer (Global *this);

extern int GetOneBit	(Global *this);
extern int GetBits	(Global *this, int n);
extern int CheckBits	(Global *this, int n);
extern void ConsumeBits	(Global *this, int n);

extern unsigned long GetOverallBits	(Global *this);
extern unsigned long GetDecodedDataBits	(Global *this);

extern int GotoSync		(Global *this);
extern int NextPictureStartCode(Global *this);
extern int NextLayerStartCode(Global *this);
extern int NextSequenceStartCode(Global *this);

/* XXX: Fixme: no globals please! */
GLOBAL jmp_buf ErrorHandlerEnv;
GLOBAL jmp_buf SliceSyncEnv;
GLOBAL jmp_buf LowestLayerSyncEnv;
GLOBAL jmp_buf LayerSyncEnv;
GLOBAL jmp_buf PictureSyncEnv;
GLOBAL jmp_buf ResyncEnv;
GLOBAL jmp_buf restartenv;

enum {
  NO_ERR = 0,
  VLC_ERR,
  CBP_ERR,
  MVFX_ERR,
  MVFY_ERR,
  MVBX_ERR,
  MVBY_ERR,
  MODE_ERR,
  HEADER_ERR,
  MEAN_ERR,
  VECT_ERR,
  BLOCK_ERR,
  GN_ERR
};

/*
 *  This struct holds all static global variables for Bit-Buffer handling
 *  Once allocated for each opened stream
 */

struct bitbuf_s {
  FILE *InputFile;
  int streamEOF;
  int BufSize;
  unsigned short *BufNext;
  unsigned short *BufLast;
  int DataGot;
  int ZeroBits;
   
  int BitsLeft;
  unsigned long OverallBits;
  unsigned long OverallBytes;
  unsigned long DecodedDataBits;
  unsigned long BitBuffer;

  char *InputFileName;		/* the src URL */
  unsigned char *buf;		/* buffer */
  int blen, nbytes; 		/* brutto/netto buffer contents */
  int processed;		/* total picture count */
  unsigned long offset;		/* buffer start in entire sequence */
#ifndef PICTBUF
  unsigned short InputBuffer[1];
  /* array extended as long as needed */
#endif
};
typedef struct bitbuf_s bitbuf;

/*
 *  Trick: (long long) is implemented by the C-compiler as 2 seperate
 *         32-bit registers, hence we can cheaply return 2 different values.
 */

#endif /* _INPUT_H */
