#include <stdio.h>

#include "Util.h"

#ifndef _PARAMETER_
#define _PARAMETER_

typedef struct _Parameter_struct {
  char InputBase[80];
  char OutputBase[80];
  char Codebook[80];
  char Stream[80];
  int FirstFrame;
  int LastFrame;
  int N;
  int M;
  int SearchRange;
  int PyraLength;
  int *LayerCoding;

  int FwdScaling[4];
  int BakScaling[4];
  int FwdXRange[4], FwdYRange[4];
  int BakXRange[4], BakYRange[4];

} Parameter_struct;

typedef struct SequenceHeader {
  int HSize;
  int VSize;
  int BlockWidth[4];
  int BlockHeight[4];
  int XSubsamp[4];
  int YSubsamp[4];
  int IPreset[4];
  int PPreset[4];
  int BPreset[4];
  int Layers;
} SequenceHeaderStruct;

typedef struct _PictureHeader {
  int TempRef;
  int CodingType;
} PictureHeaderStruct;

typedef struct _LayerHeader {
  int Number;
  int w;
  int h;
  int FXMVSize, FYMVSize;
  int BXMVSize, BYMVSize;
  int IsLowestLayer;
  int ResiduumCoded;
  int ClassVar[3][3][3]; /* [mode][signal][Class] */
} LayerHeaderStruct;

typedef struct _BlockHeader {
  int MCMode;
  int fx, fy;
  int bx, by;
  int Coded;
} BlockHeaderStruct;

#endif

