/*
 * global.h -- collection all global variabls in struct global
 *
 * 9.jan.97, jw.
 */

struct GlobalStruct;		/* here for Crop.h */

#include "Image.h"		/* PyramidPtr */
#include "Motion.h"		/* FwdMV */
#include "Crop.h"		/* cropTbl */
#include "Parameter.h"		/* SeqHdr PictHdr LayerHdr */
#include "Syntax.h"		/* SyncCode */
#include "options.h"		/* Options */

typedef struct GlobalStruct
{
  MultiScaleFieldPtr FwdMV;		/* Motion.h */
  /* GLOBAL MultiScaleFieldPtr BakMV; */

  Byte cropTbl[NUM_CROP_ENTRIES];	/* Crop.h */

  SequenceHeaderStruct SeqHdr;		/* Parameter.h */
  /* GLOBAL Parameter_struct ParBlk; */
  PictureHeaderStruct PictHdr;
  LayerHeaderStruct LayerHdr;

  PyramidPtr Decoded;			/* Image.h */
  PyramidPtr PastDecoded;
  PyramidPtr FutrDecoded;
  PyramidPtr PastSPInter;
  PyramidPtr FutrSPInter;

  enum SyncCodeType SyncCode;		/* Syntax.h */

  OptionsStruct Options;		/* options.h */

  int NextSyncPos;		/* private for Input.c/DecodeSymbolFast.c */
  struct bitbuf_s *BBS;		/* private for Input.c/DecodeSymbolFast.c */

  int (*GetIntraCBPYHuffCode)(struct GlobalStruct *this);	/* from BlockDecoder.c */
  int (*GetIntraCBPCHuffCode)(struct GlobalStruct *this);
  int (*GetIntraZVYHuffCode)(struct GlobalStruct *this);
  int (*GetIntraZVCHuffCode)(struct GlobalStruct *this);
  int (*GetIntraShellCombCHuffCode)(struct GlobalStruct *this);
  int (*GetIntraShellCombYHuffCode)(struct GlobalStruct *this);
  int (*GetShell1SPYHuffCode)(struct GlobalStruct *this);
  int (*GetShell2SPYHuffCode)(struct GlobalStruct *this);
  int (*GetShell1SPCHuffCode)(struct GlobalStruct *this);
  int (*GetShell2SPCHuffCode)(struct GlobalStruct *this);
  int (*GetSPYClassHuffCode)(struct GlobalStruct *this);
  int (*GetSPCClassHuffCode)(struct GlobalStruct *this);

  int (*GetInterCBPYHuffCode)(struct GlobalStruct *this);
  int (*GetInterCBPCHuffCode)(struct GlobalStruct *this);
  int (*GetInterZVYHuffCode)(struct GlobalStruct *this);
  int (*GetInterZVCHuffCode)(struct GlobalStruct *this);
  int (*GetInterShellCombYHuffCode)(struct GlobalStruct *this);
  int (*GetInterShellCombCHuffCode)(struct GlobalStruct *this);
  int (*GetShell1TPYHuffCode)(struct GlobalStruct *this);
  int (*GetShell1TPCHuffCode)(struct GlobalStruct *this);
  int (*GetShell2TPYHuffCode)(struct GlobalStruct *this);
  int (*GetShell2TPCHuffCode)(struct GlobalStruct *this);
  int (*GetTPYClassHuffCode)(struct GlobalStruct *this);
  int (*GetTPCClassHuffCode)(struct GlobalStruct *this);

  int LowestLayer;		/* from main() */
  int BuffState;

} Global;

