
#include "KhorosIO.h"

#include "global.h"	/* Common Variables */
#include "extern.h"	/* Common Functions */
#include "config.h"	/* Options initializers */
#include "display.h"	/* init_display() */

#include "Input.h"
#include "Buffers.h"
#include "Headers.h"
#include "Interpolation.h"

OptionsStruct Init_Options =
{
  NULL,
  SAVE_DECODED,
  USE_VIS,
  USE_DGA,
  USE_SHM,
  DISPLAY,
  THREAD_YUV,
  GRAY,
  PSEUDOCOLOR,
  EXPAND,
  QCIF,
  0,		/* Default for fps */
  LOOP
#error this strutcure is out o date.
};

static int DecodeSequenceSetup(Global *this) {

  this->SyncCode = NextSequenceStartCode(this);

  if (this->SyncCode == -1) {
    fprintf(stderr,"No more sequences in bitstream\n");
    return(0);
  }

  DecodeSequenceHeader(this);

  InitBuffers(this);
  this->FwdMV = NewVectorField(this);
/*  ComputeMVScaling(); */

  return(1);
}

static void ExitWithUsage(Global *this, char *msg, int ret)
{
#define O(txt, def, opt) fprintf(stderr, "  -%s. Default: -%s%s.\n", txt, def ? "" : "no", opt);
  fprintf(stderr, "Usage: %s [-[no]option ...] file.pyra\n", this->Options.argv0);
#ifndef WITHOUT_DGA
  O("dga        Use Direct Graphics Access", USE_DGA, "dga");
#endif
  O("nodisplay  Don't show the decoded frames", DISPLAY, "display");
  O("expand     Double the size of the image", EXPAND, "expand");
  O("gray       Show video in grayscale", GRAY, "gray");
  O("loop       Repeat the input stream infinitly", LOOP, "loop");
  O("pseudo     Show video in PseudoColor (8Bit)", PSEUDOCOLOR, "pseudo (TrueColor)");
  O("qcif       Show image in QCIF size", 1, QCIF ? "qcif" : "cif");
  O("save       Write frames as Khoros files", SAVE_DECODED, "save");
#ifndef WITHOUT_SHM
  O("noshm      Don't use shared memory", USE_SHM, "shm");
#endif
#ifndef WITHOUT_THREADS
  O("threads    Spawn a thread for color conversion", THREAD_YUV, "threads");
#endif
#ifndef WITHOUT_VIS
  O("vis        Use UltraSparc Visual Instruction Set", USE_VIS, "vis");
  O("fps        If set, use given framerate", 1, "nofps (unlimited)");
#endif
  if (msg)
    fprintf(stderr, "\nHmmm: %s\n", msg);
  exit(ret);
}

static int printdot(void *ptr, int count)
{
  fprintf((FILE *)ptr, count ? "." : "\n");
  return 0;
}

int main(int argc, char *argv[]) {

  int LowestLayer;
  int BuffState;

  Global *this = (Global *)calloc(sizeof(Global), 1);

  if (!this)
    {
      fprintf(stderr, "Definitly out of memory!\n");
      exit(-1);
    }
  this->Options = Init_Options; 	/* struct copy */

  this->Options.argv0 = *argv++;

  while(*argv && **argv == '-') 
    {
      char *o = *argv++;
      int v = strncmp("no", o+1, 2) ? 1 : 0;

      o += v ? 1 : 3;
           if (!strcmp(o, "gray"))	this->Options.visgray = v;
      else if (!strcmp(o, "grey"))	this->Options.visgray = v;
      else if (!strcmp(o, "pseudo"))	this->Options.vis8 = v;
      else if (!strcmp(o, "save"))	this->Options.save_decoded = v;
      else if (!strcmp(o, "vis"))	this->Options.use_vis = v;
      else if (!strcmp(o, "dga"))	this->Options.use_dga = v;
      else if (!strcmp(o, "shm"))	this->Options.use_shm = v;
      else if (!strcmp(o, "shmem"))	this->Options.use_shm = v;
      else if (!strcmp(o, "display"))	this->Options.display = v;
      else if (!strcmp(o, "thread"))	this->Options.thread_yuv = v;
      else if (!strcmp(o, "threads"))	this->Options.thread_yuv = v;
      else if (!strcmp(o, "expand"))	this->Options.visexpand = v;
      else if (!strcmp(o, "qcif"))	this->Options.qcif = v;
      else if (!strcmp(o, "cif"))	this->Options.qcif = !v;
      else if (!strcmp(o, "fps"))	this->Options.fps = atoi(*argv++);
      else if (!strcmp(o, "loop"))	this->Options.loop = v;
      else 
        ExitWithUsage(this, "Unknown commandline option.", 1);
    }

  if (!*argv)
    ExitWithUsage(this, "Name of input file is missing.", 0);

  SetupCropTable(this);
  InitInterpolator();
  SetupExtVectTables(printdot, stderr);

  BuffState = 0;

  /*  ld = &base; */
  OpenInputBitstream(this, *argv, 8192);
  DecodeSequenceSetup(this);
  if (this->Options.display)
    init_display(this, this->SeqHdr.HSize/(1+this->Options.qcif), this->SeqHdr.VSize/(1+this->Options.qcif));
  this->SyncCode = NextPictureStartCode(this);

  SetStartTime();

 DECODE_FRAME:

  SetFrameStart();

  if ( this->SyncCode == SEQUENCE_END_CODE ) goto SEQUENCE_END;

  if ( (this->SyncCode & SYNC_MASK) != PICTURE_START_CODE ) {
    fprintf(stderr,"Can't sync to picture start\n");
    goto SEQUENCE_END;
  }

  LowestLayer = this->SyncCode & 0x3;

  if (this->Options.qcif)
    {
      if (LowestLayer<1) {
	NextPictureStartCode(this);
	/*
	this->SyncCode = GotoSync();
	while ((this->SyncCode & SYNC_MASK) != PICTURE_START_CODE) this->SyncCode = GotoSync();
	*/
	goto WAIT;
      }
    }

  DecodePictureHeader(this);
  
  switch (this->PictHdr.CodingType) {
  case 1:
    switch (BuffState) {
    case 0:
      /*      ReadYUVRawFormat("/SUN_HOME/mit/cids/mpeg4_vm/anchor/fm112/", 0, this->PastDecoded->Layer[0]);  */
      /* this->SyncCode = GotoSync(); */
      DecodeIPicture(this, this->PastDecoded, this->PastSPInter, this->PictHdr.TempRef, LowestLayer);
/*
      ReadYUVKhorosFormat("stud263.0", 1, this->PastDecoded->Layer[0]); 
      ReadYUVKhorosFormat("stud263.1", 1, this->PastDecoded->Layer[1]);
*/
      if (this->Options.display)
	yuv2rgb(this, this->PastDecoded->Layer[this->Options.qcif]);
      /* sleep(10); */
      BuffState = 1;
      break;
    case 1:
      DecodeIPicture(this, this->FutrDecoded, this->FutrSPInter, this->PictHdr.TempRef, LowestLayer);
      if (this->Options.display)
        yuv2rgb(this, this->FutrDecoded->Layer[this->Options.qcif]);

      BuffState = 2;
      break;
    case 2:
      DecodeIPicture(this, this->FutrDecoded, this->FutrSPInter, this->PictHdr.TempRef, LowestLayer);
      if (this->Options.display)
        yuv2rgb(this, this->FutrDecoded->Layer[this->Options.qcif]);

      break;
    }
    break;
  case 2:
    switch (BuffState) {
    case 0: break;
    case 1:
      DecodePPicture(this, this->FutrDecoded, this->PastDecoded, this->PastSPInter, this->PictHdr.TempRef, LowestLayer); 
      if (this->Options.display)
        yuv2rgb(this, this->FutrDecoded->Layer[this->Options.qcif]);
      BuffState = 2;
      break;
    case 2:
      DecodePPicture(this, this->FutrDecoded, this->PastDecoded, this->PastSPInter, this->PictHdr.TempRef, LowestLayer); 
      if (this->Options.display)
        yuv2rgb(this, this->FutrDecoded->Layer[this->Options.qcif]);
      break;
    }
    break;
  case 3:
    switch (BuffState) {
    case 0:
    case 1: break;
    case 2:
      break;
    }
    break;
  }
WAIT:
  if (this->Options.fps) doframerate(this->Options.fps);

  goto DECODE_FRAME;

 SEQUENCE_END:

  fprintf(stderr,"%d frames decoded\n", this->PictHdr.TempRef+1);
  PrintTimeInfo(this->PictHdr.TempRef+1);

  if (this->Options.loop)
    {
      BuffState = 0;
      RewindInputBitstream(this);
      /*
      CloseInputBitstream(this);
      OpenInputBitstream(this, *argv, 8192);
      */
      DecodeSequenceSetup(this);
      this->SyncCode = NextPictureStartCode(this);
      SetStartTime();
      goto DECODE_FRAME;
    }

  CloseInputBitstream(this);

  if (this->Options.display)
    exit_display(this);
  return(0);
}
