/*
 * This file is printed by modmake -template.
 * It is an example of a simple but complete jittr module.
 * <basename>_modname
 * <basename>_modhelp
 * <basename>_modstruct
 * <basename>_modmain
 * <basename>_modexit
 *
 * have to be present in all modules that are statically linked.
 * For dynamic loading only <basename>_modmain is compulsory.
 * My dynamic module loader also accepts "ZZZ" as a basename.
 *
 * Notice:
 *	Write bullet-proof code here. Check every step! You may share the
 *	process with other modules, be nice. Do not exit() or abort() the
 *	process, unless you proved that the library is at fault!
 *
 * 07.06.96 (c) Juergen Weigert
 */

#include <stdio.h>              /* NULL */
#include <errno.h>		/* for strerror(errno) */
#include <string.h>		/* for strdup() */

#include <sys/types.h>          /* for sys/socket.h */
#include <sys/socket.h>         /* SOCK_STREAM */
#include <sys/time.h>           /* struct timeval for net.h */

#include <jittr/atom.h>		/* TRACE_WRITE, atom_value() */
#include <jittr/parse.h>	/* jarg_*() methods */
#include <jittr/jittr.h>	/* jittr_error(), jittr_arg[cv] */
#include <jittr/net.h>		/* struct client */
#include <jittr/doio.h>		/* TurnClient() */

/* extern int fprintf(); */	/* you should not use it */

#undef JITTR_DEFAULT_TTY	/* /dev/ttya, dev/term/a, /dev/ttyS1, ... */
#define JITTR_DEFAULT_TTY	"/dev/null"

static int ZZZ_trace __P((int idx, int flag, void *data));
static int ZZZ_input __P((void *cli, char *bufp, int len));

char ZZZ_modname[] = "modmake builtin template V1.0";

char *ZZZ_modhelp[] = 
{
  /* name	description */
  ".",		"the template module testcommand",
  "./foo",	"some local command of the template module, which has a lengthy description",
  "./foo [barefoot [foobar]]",	"this too has a lengthy description",
  "bar",	"some global command",
  NULL
};

char *ZZZ_modstruct[] =
{
/*off   name		type	value */
  /* -- ------------------------------  ------  ------- */
  NULL, "./foo",			"a",	"17",
  NULL, "./.widget",			"v",	"button",
  NULL, "./.label",			"v",	"the panic button",
  NULL, NULL
};

int ZZZ_modmain(atom_index, flag, private_data)
int atom_index, flag;
void **private_data;
{
  int i, l;
  char *s, *port = JITTR_DEFAULT_TTY;
  struct client *cl;

  /* triggered by jittr_store_argv() */
  if (!*private_data && (flag & TRACE_WRITE))
    {
      for (i = 0; i < jittr_argc; i++)
        {
	  if ((l = strlen(jittr_argv[i])) < 2)
	    continue;
	  if (!strncmp(jittr_argv[i], "-device", l))
	    {
	      jittr_shift_argv(i);
	      if (!(port = jittr_argv[i]) || !*port)
	        return jittr_error("%s: option -dev: parameter missing.\n",
			ZZZ_modname, 0, 0, 0);
	      jittr_shift_argv(i--);
	    }
	  else if (!strncmp(jittr_argv[i], "-name", l))
	    {
	      jittr_shift_argv(i);
	      if (jittr_change_name(atom_index, jittr_argv[i]))
	        return jittr_error("%s: option -name: bad parameter.\n",
			ZZZ_modname, 0, 0, 0);
	      jittr_shift_argv(i--);
	    }
	  else if (!strncmp(jittr_argv[i], "-help", l))
	    {
	      jittr_error("%s:\n  -dev <serial-line>\t\tDefault: %s\n",
			  ZZZ_modname, port, 0, 0);
	      jittr_error("  -name <logical-name>\t\tDefault: %s\n",
	      		  atom_name(atom_index), 0, 0, 0);
	      /* no shift here, because -h shall be seen by other modules */
	      return 0;
	    }
	}
      *private_data = NULL;
    }

  debug3("Template modmain(%s) with %d arg%s.\n",
	      atom_value(atom_index), jittr_argc, (jittr_argc!=1)?"s":"");

  if (!*private_data && (flag & TRACE_EXEC))
    {
      debug("ZZZ_modmain EXEC\n");
      if ((s = jarg_first_word(NULL)) && *s)
	port = s;
      debug2("running ZZZ after modload on atom %d. device=%s.\n",
      	atom_index, port);
    }

  if (*private_data)
    return jittr_error("%s already initialized on atom %d.\n", 
      		ZZZ_modname, atom_index, 0, 0);

  if (!(cl = jittr_init_tty(atom_index, port, NULL)))
    return jittr_error("%s: atom %d: init_tty %s failed: %s.\n",
    		ZZZ_modname, atom_index, port, strerror(errno));

  *private_data = (void *)cl;		/* or whatever structure you have */
  
  cl->input_notify_fn = ZZZ_input;
  cl->input_notify_data = *private_data;

  if (jittr_mount(atom_index, ZZZ_modstruct, NULL))
    return jittr_error("%s: atom %d: mount failed.\n",
    		ZZZ_modname, atom_index, 0, 0);

  atom_trace_set(atom_index, TRACE_EXEC|TRACE_WRITE, ZZZ_trace, (void *)cl);

  /* shall return negative on severe error, 
   * may return positive to trigger a debug notification,
   * but should 0 normally.
   */
  return 0;
}

/*
 * modexit() is responsible to remove all traces that have been set on any
 * atoms by this instance of the module
 */
int ZZZ_modexit(atom_index, private_data)
int atom_index;
void **private_data;
{
  struct client *cl = (struct client *)*private_data;

  jittr_error("This is the template modexit on atom %d. Private data is '%s'\n",
  	atom_index, (char *)*private_data, 0, 0);

  if (cl)
    {    
      /*
       * remove hierarchy, kill, close things, ...
       */
      cl->input_notify_data = NULL;  /* tell ZZZ_input() what happened */
      TurnClient(ClientByFd(NULL, cl->i->fd), 1);
      jittr_umount(atom_index);

      debug2("modexit done '%s' atom %d.\n", ZZZ_modname, atom_index);
    }

  /*
   * must return 0 to allow destruction of atom
   */
  return 0;
}

static int
ZZZ_input(cli, bufp, len)
void *cli;
char *bufp;
int len;
{
  debug2("Oops! input on %s: '%s'\n", ((struct client *)cli)->name->buf, bufp);
  return -1;
}

static int
ZZZ_trace(idx, flag, data)
int idx;
int flag;
void *data;
{
  struct client *cl = (struct client *)data;
  struct dstring **o = &cl->o->obuf;
  char *s;
  int l;

  if (flag & TRACE_EXEC)
    {
      s = jarg_first_word(&l);
      debug1("ZZZ_trace EXEC: Writing %s to device! What do you expect?\n", s);
      dstring_append(o, -1, s, l);
      return 0;
    }

  ASSERT(flag & TRACE_WRITE);

  s = atom_value(idx);
  debug1("ZZZ_trace WRITE: Writing %s to device! Did you expect that?\n", s);
  dstring_append(o, -1, s, l);
  return 0;
}
