/*
 * np_main.c - a main in the style of a netscape plugin
 *
 * 25.1.97, jw.
 */
#include <stdio.h>
#include "KhorosIO.h"

#include "global.h"	/* Common Variables */
#include "extern.h"	/* Common Functions */
#include "config.h"	/* Options initializers */

#include "Process.h"	/* ProcessPicture() */
#include "Input.h"
#include "Interpolation.h"	/* InitInterpolator */
#include "audio.h"	/* InitAudio() */
#include "debug.h"

#ifdef DEBUG
FILE *debugfp = stderr;
char *debugfilename = NULL;
#endif

OptionsStruct Init_Options =
{
  NULL,
  SAVE_DECODED,
  USE_VIS,
  USE_DGA,
  USE_SHM,
  DISPLAY,
  0,		/* Default for cover_window: use own toplevel */
  THREAD_YUV,
  GRAY,
  PSEUDOCOLOR,
  EXPAND,
  QCIF,
  0,		/* Default for fps */
  LOOP,
  QUIET,
  AUDIO
};

#if defined(__sun) && defined(FILE)
# define memmove(d, s, n) bcopy(s, d, n)
#endif

static int try_to_free_mem()
{
  fprintf(stderr, "Out of memory, malloc failed\n");
  return 0;
}

int NPP_Write(this, ptr, n)
Global *this; 
char *ptr; /* Netscape data buffer */
int n; /* size of data buffer */
{
  int s, x, start, checked;
  bitbuf *BBS = this->BBS;

  /* see if we already have a buffer */
  if (!BBS->buf)
    {
      /* new buffer */
      BBS->blen = BBS->BufSize * 2;
      BBS->buf = (unsigned char *)malloc(BBS->blen);
      BBS->nbytes = 0;
      BBS->processed = 0;
      BBS->offset = 0;

      if (!BBS->buf)
	{
	  /* we cannot accept input without a buffer */
	  try_to_free_mem();
	  return 0;
	}
    }
  
  /* see if n bytes can be appended to buffer */
  while (BBS->nbytes + n > BBS->blen)
    {
      unsigned char *p = BBS->buf;
      int pl = BBS->blen;

      /* check if it is sane to increase buffer size */
      if (pl > 4*1024*1024)
        {
	  /* looks like there is something wrong..., don't accept bytes */
          fprintf(stderr, "No sync word found after reading 4MB\n");
          return 0;
        }

      /* double the size */
      BBS->blen *= 2;
      /* fprintf(stderr, "incr buffer to %d\n", BBS->blen); */
      BBS->buf = (unsigned char *)malloc(BBS->blen);
      if (!BBS->buf)
        {
	  /* dubbing failed, cannot accept bytes */
          BBS->buf = p;
          BBS->blen = pl;
          try_to_free_mem();
          return 0;
        }
      memcpy(BBS->buf, p, BBS->nbytes);
      free((char *)p);
    }

  /* append n bytes */
  memcpy(BBS->buf+BBS->nbytes, ptr, n);

  /* checking starts 2 bytes before the previous end to catch split syncs */
  checked = (BBS->nbytes > 4) ? (BBS->nbytes - 2) : 3;
  BBS->nbytes += n;
  start = 0;

  /* locate all syncs in buffer and process the pictures between them */
  for (;;)
    {
      if ((x = FindPictureSync(BBS->buf+checked, BBS->nbytes-checked, &s)) < 0)
        break;

      ProcessPicture(this, BBS->buf+start, checked+x-start, BBS->offset+start);
      BBS->processed++;

      start = checked += x;
      checked += 3;

      if ((s & SYNC_MASK) == SEQUENCE_END_CODE)
        {
	  ProcessPicture(this, BBS->buf+start, 0, BBS->offset+start);
	  return n;
	}
    }

  /* if we processed something, move the trailing half frame fwd */
  if (start)
    {
      BBS->offset += start;
      BBS->nbytes -= start;
      if (BBS->nbytes)
        memmove(BBS->buf, BBS->buf+start, BBS->nbytes);
    }
  
  /* accept n bytes */
  return n;
}

static void ExitWithUsage(Global *this, char *msg, int ret)
{
#define O(txt, def, opt) fprintf(stderr, "  -%s. Default: -%s%s.\n", txt, def ? "" : "no", opt);
  fprintf(stderr, "Usage: %s [-[no]option ...] file.pyra\n", this->Options.argv0);
#ifndef WITHOUT_DGA
  O("dga        Use Direct Graphics Access", USE_DGA, "dga");
#endif
  O("windowid   Use given window as parent", 1, " own toplevel");
  O("nodisplay  Don't show the decoded frames", DISPLAY, "display");
  O("expand     Double the size of the image", EXPAND, "expand");
  O("gray       Show video in grayscale", GRAY, "gray");
  O("noaudio    Disable audio", AUDIO, "audio");
/*  O("loop       Repeat the input stream infinitly", LOOP, "loop"); */
  O("pseudo     Show video in PseudoColor (8Bit)", PSEUDOCOLOR, "pseudo (TrueColor)");
  O("qcif       Show image in QCIF size", 1, QCIF ? "qcif" : "cif");
  O("save       Write frames as Khoros files", SAVE_DECODED, "save");
  O("quiet      Suppress almost all messages", QUIET, "quiet");
#ifndef WITHOUT_SHM
  O("noshm      Don't use shared memory", USE_SHM, "shm");
#endif
#ifndef WITHOUT_THREADS
  O("threads    Spawn a thread for color conversion", THREAD_YUV, "threads");
#endif
#ifndef WITHOUT_VIS
  O("vis        Use UltraSparc Visual Instruction Set", USE_VIS, "vis");
#endif
  O("fps        If set, use given framerate", 1, "nofps (unlimited)");
  if (msg)
    fprintf(stderr, "\nHmmm: %s\n", msg);
  exit(ret);
}

static int printdot(void *ptr, int count)
{
  fprintf((FILE *)ptr, count ? "." : "\n");
  return 0;
}

int mod_main(int argc, char *argv[]) 
{
  FILE *fp;
  char *buf;
  int n, len;

  Global *this = (Global *)calloc(sizeof(Global), 1);

  if (!this)
    {
      fprintf(stderr, "Definitly out of memory!\n");
      exit(-1);
    }
  this->Options = Init_Options; 	/* struct copy */

  this->Options.argv0 = *argv++;

  while(*argv && **argv == '-' && argv[0][1]) 
    {
      char *o = *argv++;
      int v = strncmp("no", o+1, 2) ? 1 : 0;

      o += v ? 1 : 3;
           if (!strcmp(o, "gray"))	this->Options.visgray = v;
      else if (!strcmp(o, "grey"))	this->Options.visgray = v;
      else if (!strcmp(o, "pseudo"))	this->Options.vis8 = v;
      else if (!strcmp(o, "save"))	this->Options.save_decoded = v;
      else if (!strcmp(o, "vis"))	this->Options.use_vis = v;
      else if (!strcmp(o, "dga"))	this->Options.use_dga = v;
      else if (!strcmp(o, "shm"))	this->Options.use_shm = v;
      else if (!strcmp(o, "shmem"))	this->Options.use_shm = v;
      else if (!strcmp(o, "display"))	this->Options.display = v;
      else if (!strcmp(o, "thread"))	this->Options.thread_yuv = v;
      else if (!strcmp(o, "threads"))	this->Options.thread_yuv = v;
      else if (!strcmp(o, "expand"))	this->Options.visexpand = v;
      else if (!strcmp(o, "audio"))	this->Options.audio = v;
      else if (!strcmp(o, "qcif"))	this->Options.qcif = v;
      else if (!strcmp(o, "cif"))	this->Options.qcif = !v;
      else if (!strcmp(o, "quiet"))	this->Options.quiet = v;
      else if (!strcmp(o, "fps"))	this->Options.fps = atoi(*argv++);
      else if (!strcmp(o, "window"))	
        this->Options.cover_window = strtol(*argv++, NULL, 0);
      else if (!strcmp(o, "windowid"))	
        this->Options.cover_window = strtol(*argv++, NULL, 0);
      else if (!strcmp(o, "id"))	
        this->Options.cover_window = strtol(*argv++, NULL, 0);
/*    else if (!strcmp(o, "loop"))	this->Options.loop = v;	*/
      else 
        ExitWithUsage(this, "Unknown commandline option.", 1);
    }

  if (!this->Options.fps)
    {
      if (this->Options.audio && !this->Options.quiet)
	fprintf(stderr, "Audio disabled, -fps missing.\n");
      this->Options.audio = 0;
    }

  if (!*argv)
    ExitWithUsage(this, "Name of input file is missing.", 0);

  SetupCropTable(this);
  InitInterpolator();
  if (this->Options.quiet)
    SetupExtVectTables(NULL, NULL);
  else
    SetupExtVectTables(printdot, stderr);
  if (this->Options.audio)
    InitAudio();


  this->BuffState = 0;

  if (argv[0][0] == '-' && argv[0][1] == '\0')
    fp = stdin;
  else if (!(fp = fopen(*argv, "r")))
    fprintf(stderr, "%s: ", *argv),perror("fopen"),exit(0);
  
  len = 8192;
  if (!(buf = (char *)malloc(len)))
    EXIT_WITH_ERR("Really out of memory");

  SetupInputBitstream(this, *argv, len);
  while ((n = fread(buf, 1, len, fp)) > 0)
    NPP_Write(this, buf, n); 
  if (!this->Options.quiet)
    fprintf(stderr,"TempRef of last decoded picture: %d\n", this->PictHdr.TempRef);

  if (this->Options.audio)
    CloseAudio();
  return 0;
}

