#include "Util.h"

void Vect2ImageOrder8x8(int *b1, int *b2, int w) {
  int i, j, n;

  n = 0;

  for (j=0; j<8; j+=4) {
    for (i=0; i<8; i+=2) {
      b2[((j+0)*w)+i+0] = b1[n++];
      b2[((j+1)*w)+i+0] = b1[n++];
      b2[((j+2)*w)+i+0] = b1[n++];
      b2[((j+3)*w)+i+0] = b1[n++];

      b2[((j+0)*w)+i+1] = b1[n++];
      b2[((j+1)*w)+i+1] = b1[n++];
      b2[((j+2)*w)+i+1] = b1[n++];
      b2[((j+3)*w)+i+1] = b1[n++];
    }
  }
}

void Vect2ImageOrder16x16(int *b1, int *b2, int w) {
  Vect2ImageOrder8x8(b1, b2, w);
  Vect2ImageOrder8x8(b1+64, b2+8, w);
  Vect2ImageOrder8x8(b1+128, b2+128, w);
  Vect2ImageOrder8x8(b1+192, b2+136, w);
}


void BlockSubsamp4 (int *b1, int *b2, int w, int h) {
  int i, j, ii, jj;
  int sum;

  for (j=0; j<h; j+=4)
    for (i=0; i<w; i+=4) {
      sum = 0;
      for (jj=0; jj<4; jj++)
	for (ii=0; ii<4; ii++)
	  sum += b1[w*(j+jj)+i+ii];

      b2[(j/4)*(w/4)+(i/4)] = ROUND(sum/16.0);
    }
}

void BlockUpsamp4 (int *b1, int *b2, int w, int h) {
  int i, j;

  for (j=0; j<4*h; j++)
    for (i=0; i<4*w; i++) 
      b2[j*(4*w)+i] = b1[(j/4)*w+(i/4)];
      
}

void Image2VectOrder8x8(int *b1, int *b2, int w) {
  int i, j, n;

  n = 0;

  for (j=0; j<8; j+=4) {
    for (i=0; i<8; i+=2) {
      b2[n++] = b1[((j+0)*w)+i+0];
      b2[n++] = b1[((j+1)*w)+i+0];
      b2[n++] = b1[((j+2)*w)+i+0];
      b2[n++] = b1[((j+3)*w)+i+0];

      b2[n++] = b1[((j+0)*w)+i+1];
      b2[n++] = b1[((j+1)*w)+i+1];
      b2[n++] = b1[((j+2)*w)+i+1];
      b2[n++] = b1[((j+3)*w)+i+1];
    }
  }
}

void Image2VectOrder16x16(int *b1, int *b2, int w) {
  Image2VectOrder8x8(b1, b2, w);
  Image2VectOrder8x8(b1+8, b2+64, w);
  Image2VectOrder8x8(b1+128, b2+128, w);
  Image2VectOrder8x8(b1+136, b2+192, w);
}

