#include "Image.h"
#include "Buffers.h"
#include "Filter.h"
#include "Parameter.h"

static int GetLowestLayer(int TempRef) {
  int Position;
  int l;
  int *CodingOfLayers;

  Position = TempRef % ParBlk.PyraLength;
  CodingOfLayers = ParBlk.LayerCoding+(Position*SeqHdr.Layers);

  for (l=SeqHdr.Layers-1; l>=0; l--) {
    if (CodingOfLayers[l]) break;
  }
  return(l+1);
}

void InitBuffers()
{
  int i;
  int size;
  int ow, oh;

  ow = SeqHdr.HSize;
  oh = SeqHdr.VSize;

/*  size = ParBlk.M + 1; */

  size = 3;

  Decoded = NewPyramid(ow, oh, SeqHdr.Layers+1);
  PastDecoded =  NewPyramid(ow, oh, SeqHdr.Layers+1);
  FutrDecoded =  NewPyramid(ow, oh, SeqHdr.Layers+1);

  refNorm[0] = (uint16*) malloc(ow*oh*sizeof(uint16));
  actNorm[0] = (uint16*) malloc(ow*oh*sizeof(uint16));

  refNorm[1] = (uint16*) malloc(ow*oh*sizeof(uint16)/4);
  actNorm[1] = (uint16*) malloc(ow*oh*sizeof(uint16)/4);

  SPInter = NewPyramid(ow, oh, SeqHdr.Layers+1);
  PastSPInter =  NewPyramid(ow, oh, SeqHdr.Layers+1);
  FutrSPInter =  NewPyramid(ow, oh, SeqHdr.Layers+1);

  MakeLocalIntraBuffers(ow, oh, SeqHdr.Layers);

  FrameBuffer = NEWELEMS(PyramidPtr, size);

  for (i=0; i<size; i++) {
    FrameBuffer[i] = NewPyramid(ow, oh, SeqHdr.Layers+1);
  }
}

void FutureLayerRefToPast (int l) {

  uint16 *tmpNorm;
  FramePtr tmp;

  fprintf(stderr,"Moving Future Layer Ref to Past Ref\n");

  tmp = FrameBuffer[0]->Layer[l];
  FrameBuffer[0]->Layer[l] = FrameBuffer[2]->Layer[l];
  FrameBuffer[2]->Layer[l] = tmp;

  tmp = PastDecoded->Layer[l];
  PastDecoded->Layer[l] = FutrDecoded->Layer[l];
  FutrDecoded->Layer[l] = tmp;

  tmpNorm = refNorm[l];
  refNorm[l] = actNorm[l];
  actNorm[l] = tmpNorm;
}

int FrameToBuffer (FramePtr frame, int BufPos)
{
  int LowestLayer;
  int Yw,Yh,Cw,Ch,layer;

  Yh = frame->Y->h;
  Yw = frame->Y->w;

  Ch = frame->U->h;
  Cw = frame->U->w;

  LowestLayer = GetLowestLayer(frame->TempRef);

  FrameBuffer[BufPos]->size = SeqHdr.Layers;
  FrameBuffer[BufPos]->LowestLayer = LowestLayer;

  FrameBuffer[BufPos]->Layer[0]->TempRef = frame->TempRef;
  FrameBuffer[BufPos]->Layer[0]->SeqIndex = frame->SeqIndex;

  memcpy(FrameBuffer[BufPos]->Layer[0]->Y->data, frame->Y->data, Yw*Yh);
  memcpy(FrameBuffer[BufPos]->Layer[0]->U->data, frame->U->data, Cw*Ch);
  memcpy(FrameBuffer[BufPos]->Layer[0]->V->data, frame->V->data, Cw*Ch);

  for (layer=0; layer<LowestLayer; layer++) {
    FrameBuffer[BufPos]->Layer[layer+1]->SeqIndex = frame->SeqIndex;
    FrameBuffer[BufPos]->Layer[layer+1]->TempRef = frame->TempRef;

    DownsampleFrame(FrameBuffer[BufPos]->Layer[layer], FrameBuffer[BufPos]->Layer[layer+1]);

    /* BlockDownsampleFrame(FrameBuffer[BufPos]->Layer[0], FrameBuffer[BufPos]->Layer[layer+1], (1<<(layer+1))); */
  }

  return(1);
}

int FrameToBufferFromLayer (FramePtr frame, int BufPos, int startlayer)
{
  int LowestLayer;
  int Yw,Yh,Cw,Ch,layer;

  Yh = frame->Y->h;
  Yw = frame->Y->w;

  Ch = frame->U->h;
  Cw = frame->U->w;

  LowestLayer = GetLowestLayer(frame->TempRef);

  FrameBuffer[BufPos]->size = SeqHdr.Layers;
  FrameBuffer[BufPos]->LowestLayer = LowestLayer;

  FrameBuffer[BufPos]->Layer[startlayer]->TempRef = frame->TempRef;
  FrameBuffer[BufPos]->Layer[startlayer]->SeqIndex = frame->SeqIndex;

  memcpy(FrameBuffer[BufPos]->Layer[startlayer]->Y->data, frame->Y->data, Yw*Yh);
  memcpy(FrameBuffer[BufPos]->Layer[startlayer]->U->data, frame->U->data, Cw*Ch);
  memcpy(FrameBuffer[BufPos]->Layer[startlayer]->V->data, frame->V->data, Cw*Ch);

  for (layer=startlayer; layer<LowestLayer; layer++) {
    FrameBuffer[BufPos]->Layer[layer+1]->SeqIndex = frame->SeqIndex;
    FrameBuffer[BufPos]->Layer[layer+1]->TempRef = frame->TempRef;

    BlockDownsampleFrame(FrameBuffer[BufPos]->Layer[startlayer], FrameBuffer[BufPos]->Layer[layer+1], (1<<((layer+1-startlayer))));
  }

  return(1);
}

int FrameToBufferOneLayer (FramePtr frame, int BufPos, int layer)
{
  int LowestLayer;
  int Yw,Yh,Cw,Ch;

  Yh = frame->Y->h;
  Yw = frame->Y->w;

  Ch = frame->U->h;
  Cw = frame->U->w;

  FrameBuffer[BufPos]->size = SeqHdr.Layers;
  FrameBuffer[BufPos]->LowestLayer = LowestLayer;

  FrameBuffer[BufPos]->Layer[layer]->TempRef = frame->TempRef;
  FrameBuffer[BufPos]->Layer[layer]->SeqIndex = frame->SeqIndex;

  memcpy(FrameBuffer[BufPos]->Layer[layer]->Y->data, frame->Y->data, Yw*Yh);
  memcpy(FrameBuffer[BufPos]->Layer[layer]->U->data, frame->U->data, Cw*Ch);
  memcpy(FrameBuffer[BufPos]->Layer[layer]->V->data, frame->V->data, Cw*Ch);

  return(1);
}

void CopyFrame (FramePtr dest, FramePtr src) {
  int Yh, Yw, Ch, Cw;
  
  Yh = src->Y->h; Yw = src->Y->w;

  Ch = src->U->h; Cw = src->U->w;

  memcpy(dest->Y->data, src->Y->data, Yw*Yh);
  memcpy(dest->U->data, src->U->data, Cw*Ch);
  memcpy(dest->V->data, src->V->data, Cw*Ch);

}
