#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <values.h>

#include "Crop.h"
#include "Buffers.h"
#include "KhorosIO.h"
#include "Parameter.h"
#include "Image.h"
#include "BlockFuncs.h"
#include "Headers.h"
#include "VLC.h"
#include "Syntax.h"
#include "BlockCoder.h"
#include "CodeSymbol.h"
#include "Filter.h"
#include "Output.h"
#include "Statistics.h"
#include "Lattice.h"

#include "dpcm.h"
#include "config.h"
#include "compand.h"

static int gbw, gbh;
static int gyact[256], guact[64], gvact[64];
static int gypre[256], gupre[64], gvpre[64];
static int gytmp[256], gutmp[64], gvtmp[64];
static PyramidPtr Inter;

double gyVar, guVar, gvVar;

void MakeLocalIntraBuffers(int w, int h, int layers) {
  Inter = NewPyramid(w, h, layers);
}

static void CodeILayerData (FramePtr Actual, FramePtr Decoded, int l)
{
  int i,j;

  SetMBCodingInfo(gbw/2, SeqHdr.IPreset[l], SP_BLOCK, 0,0,0,0);

  /*
  gyVar = SignalVAR(Actual->Y, Decoded->Y);
  guVar = SignalVAR(Actual->U, Decoded->U);
  gvVar = SignalVAR(Actual->V, Decoded->V);

  fprintf(stderr,"%f %f %f\n", gyVar, guVar, gvVar);
  */
  for (j=0; j<Actual->Y->h; j+=gbh) {

    if (j!=0 && SLICE_SYNC==1)
      SendStartOfSlice();

    for (i=0; i<Actual->Y->w; i+=gbw) {

      GetMB(Actual, i, j, gbw, gyact, guact, gvact);
      GetMB(Decoded, i, j, gbw, gypre, gupre, gvpre);

      GetMB(Inter->Layer[l], i, j, gbw, gytmp, gutmp, gvtmp);

      QuantizeInterMB(gyact, guact, gvact, gypre, gupre, gvpre);

      SendMB(gyact, guact, gvact, gypre, gupre, gvpre, NULL, NULL, NULL);

      PutMB(Decoded, i, j, gbw, gyact, guact, gvact); 
    }
    fprintf(stderr,"\n");
  }
}

void CodeIFrameLayer (FramePtr Actual, FramePtr dec, int l, int IsFirstLayer, int IsLastLayer) {
  int scale;

  SMStartLayerCoding(l);

  dec->TempRef = Actual->TempRef;
  dec->SeqIndex = Actual->SeqIndex;

  gbw = SeqHdr.BlockWidth[l];
  gbh = SeqHdr.BlockHeight[l];

  SetLayerCodingInfo(IsFirstLayer,IsLastLayer, l);
  SetFrameCodingInfo(I_FRAME, Actual->TempRef);

  if (IsFirstLayer) {
    EncodeFrameDPCM(Actual,dec);
  } else {
    CodeILayerData(Actual, dec, l);
  }

  SMEndLayerCoding();
  SMLayerQuantizationError(Actual, dec);
}

extern unsigned long layerBits[4];

void CodeIFrame (PyramidPtr Actual, PyramidPtr Decoded, int TempRef, int start, int end) {

  char name[80];
  int l;
  unsigned long Count, currBits;

  SMStartFrameCoding(TempRef);

  ResetPictureHeader();
  PictHdr.CodingType = 1;
  PictHdr.TempRef = TempRef;

  SendStartOfPicture(start,I_CODED);

  CodePictureHeader();

  for (l=start; l>=end; l--) {

    Count = GlobalBitCount;

    if (l != start - 1)
      CodeIFrameLayer(Actual->Layer[l], Decoded->Layer[l], l, (l==start), (l==end));

    /*
    CodeIFrameLayer(Actual->Layer[l], Decoded->Layer[l], l, (l==start), (l==end));
    */
    layerBits[l] += GlobalBitCount - Count;

    if ((l-1) >= 0) {
      SendStartOfLayer(l-1, I_CODED);
      InterpolateFrameOnepass (Decoded->Layer[l], Decoded->Layer[l-1]);
    }

#ifdef SAVE_DECODED
    sprintf(name,"decoded.%d", l);
    SaveYUVKhorosFormat(Decoded->Layer[l], name,TempRef);
#endif
  }
  SMEndFrameCoding();

  PrintMeanHist();

  currBits = 0;
  for (l=3; l>=0; l--) {
    currBits += layerBits[l];
    fprintf(stderr,"I-Rate %d: %7.2f kbit/s\n", l, 25 * ((currBits) / (double) (1000*(TempRef+1))));
  }
}

