#include <string.h>
#include "VLC.h"
#include "Output.h"

static int PutVLC (VLCRoot table, int val) {
  if ( val < table->size ) {
    table->histo[val]++;
    table->Bits += table->HuffCode[2*val+1];
    EmitBits (table->HuffCode[2*val], table->HuffCode[2*val+1], table->name);
  }
  else {
    fprintf(stderr,"Using table %s. Coding value %d.\n", table->name, val);
    fprintf (stderr,"PutVLC ERROR: No Code defined for value.\n");
  }
  return(table->HuffCode[2*val+1]);
}

static void PrintCodeHist(VLCRoot table) {
  int i;
  int sum;
  fprintf(stderr,"\n%s %d ", table->name, table->size);
  sum = 0;
  for (i=0; i<table->size; i++) {
    sum += table->histo[i];
    fprintf(stderr,"%lu ", table->histo[i]);
  }
  /* fprintf(stderr,"Overall=%d BitsUsed=%d\n", sum, table->Bits); */
}

static void ResetCodeHist(VLCRoot table) {
  memset(table->histo, 0, table->size*sizeof(long));
}

static void PrintBitCounter(VLCRoot table) {
  fprintf(stderr,"%s: %lu\n", table->name, table->Bits);
}

static int GetBitCounter(VLCRoot table) {
  return (table->Bits);
}

static void ResetBitCounter(VLCRoot table) {
  table->Bits = 0;
}

static VLCTree *AllTrees[100];
static int nextTree = 0;

static void AddVLCTree(VLCTree *t) {
  AllTrees[nextTree++] = t;
  AllTrees[nextTree] = NULL;
}

void AddAllTrees() {
  /* general codes */

  AddVLCTree(CombSignHuffCode);
  AddVLCTree(VCombHuffCode);
  AddVLCTree(VMagHuffCode);

  AddVLCTree(EvenSignHuffCode);
  AddVLCTree(AllSignsHuffCode);

  AddVLCTree(PLowPredTypeHuffCode);

  AddVLCTree(PPredTypeHuffCode);

  /* intra codes */

  AddVLCTree(IntraShellCombCHuffCode0);
  AddVLCTree(IntraShellCombCHuffCode1);

  AddVLCTree(Shell1SPYHuffCode0);
  AddVLCTree(Shell1SPYHuffCode1);

  AddVLCTree(Shell1SPCHuffCode0);
  AddVLCTree(Shell1SPCHuffCode1);

  AddVLCTree(Shell2SPYHuffCode0);
  AddVLCTree(Shell2SPYHuffCode1);

  AddVLCTree(Shell2SPCHuffCode0);
  AddVLCTree(Shell2SPCHuffCode1);

  AddVLCTree(SPYClassHuffCode0);
  AddVLCTree(SPYClassHuffCode1);

  AddVLCTree(SPCClassHuffCode0);
  AddVLCTree(SPCClassHuffCode1);

  AddVLCTree(IntraCBPYHuffCode0);
  AddVLCTree(IntraCBPYHuffCode1);
  AddVLCTree(IntraCBPCHuffCode0);
  AddVLCTree(IntraCBPCHuffCode1);

  AddVLCTree(IntraShellCombYHuffCode0);
  AddVLCTree(IntraShellCombYHuffCode1);

  /* inter codes */

  AddVLCTree(InterCBPYHuffCode0);
  AddVLCTree(InterCBPYHuffCode1);
  AddVLCTree(InterCBPCHuffCode0);
  AddVLCTree(InterCBPCHuffCode1);

  AddVLCTree(InterShellCombCHuffCode0);
  AddVLCTree(InterShellCombCHuffCode1);

  AddVLCTree(InterShellCombYHuffCode0);
  AddVLCTree(InterShellCombYHuffCode1);

  AddVLCTree(TPYClassHuffCode0);
  AddVLCTree(TPYClassHuffCode1);

  AddVLCTree(TPCClassHuffCode0);
  AddVLCTree(TPCClassHuffCode1);

  AddVLCTree(Shell1TPYHuffCode0);
  AddVLCTree(Shell1TPYHuffCode1);

  AddVLCTree(Shell1TPCHuffCode0);
  AddVLCTree(Shell1TPCHuffCode1);

  AddVLCTree(Shell2TPYHuffCode0);
  AddVLCTree(Shell2TPYHuffCode1);

  AddVLCTree(Shell2TPCHuffCode0);
  AddVLCTree(Shell2TPCHuffCode1);

}


void PrintHistograms() {
  int i = 0;

  while(AllTrees[i] != NULL) {
    PrintCodeHist(AllTrees[i]);
    i++;
  }
  fprintf(stderr,"\n");
}

void PrintBitCounters() {
  int i = 0;

  while(AllTrees[i] != NULL) {
    PrintBitCounter(AllTrees[i]);
    i++;
  }
  fprintf(stderr,"\n");
}

void ResetBitCounters() {

  int i = 0;

  while(AllTrees[i] != NULL) {
    ResetBitCounter(AllTrees[i]);
    i++;
  }
}

void ResetHistograms() {
  int i = 0;

  while(AllTrees[i] != NULL) {
    ResetCodeHist(AllTrees[i]);
    i++;
  }
}

static unsigned long FrameBits;

void ResetFrameBits() {
  FrameBits = 0;
}

unsigned long GetFrameBits() {
  return(FrameBits);
}

int PutVMagHuffCode(int code) {
  return(PutVLC(VMagHuffCode, code));
}

int PutVCombHuffCode(int code) {
  return(PutVLC(VCombHuffCode, code));
}

int PutCombSignHuffCode(int code) {
  return(PutVLC(CombSignHuffCode, code));
}

int PutEvenSignHuffCode(int code) {
  return(PutVLC(EvenSignHuffCode, code));
}

int PutAllSignsHuffCode(int code) {
  return(PutVLC(AllSignsHuffCode, code));
}

int PutSPYClassHuffCode(int code, int index)
{
  switch(index) {
  case 0: return(PutVLC (SPYClassHuffCode0, code)); break;
  case 1: return(PutVLC (SPYClassHuffCode1, code)); break;
  }
  
}

int PutTPYClassHuffCode(int code, int index)
{
  switch(index) {
  case 0: return(PutVLC (TPYClassHuffCode0, code)); break;
  case 1: return(PutVLC (TPYClassHuffCode1, code)); break;
  }

}

int PutSPCClassHuffCode(int code, int index)
{
  switch(index) {
  case 0: return(PutVLC (SPCClassHuffCode0, code)); break;
  case 1: return(PutVLC (SPCClassHuffCode1, code)); break;
  }
}

int PutTPCClassHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (TPCClassHuffCode0, code)); break;
    case 1: return(PutVLC (TPCClassHuffCode1, code)); break;
    }
}

int PutIntraCBPYHuffCode(int code, int index)
{
  switch(index) {
  case 0: return(PutVLC (IntraCBPYHuffCode0, code)); break;
  case 1: return(PutVLC (IntraCBPYHuffCode1, code)); break;
  }
}

int PutIntraCBPCHuffCode(int code, int index)
{
  switch(index) {
  case 0: return(PutVLC (IntraCBPCHuffCode0, code)); break;
  case 1: return(PutVLC (IntraCBPCHuffCode1, code)); break;
  }
}

int PutInterCBPYHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (InterCBPYHuffCode0, code)); break;
    case 1: return(PutVLC (InterCBPYHuffCode1, code)); break;
    }
}
int PutInterCBPCHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (InterCBPCHuffCode0, code)); break;
    case 1: return(PutVLC (InterCBPCHuffCode1, code)); break;
    }
}

int PutMVHuffCode(int code)
{
  return(PutVLC (MVHuffCode, code));
}

int PutPMode(int code)
{
  return(PutVLC (PPredTypeHuffCode, code));
}

int PutPLowMode(int code)
{
  return(PutVLC (PLowPredTypeHuffCode, code));
}

int PutIntraShellCombYHuffCode(int code, int index)
{
  switch(index) {
  case 0: return(PutVLC (IntraShellCombYHuffCode0, code)); break;
  case 1: return(PutVLC (IntraShellCombYHuffCode1, code)); break;
  }
}

int PutInterShellCombYHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (InterShellCombYHuffCode0, code)); break;
    case 1: return(PutVLC (InterShellCombYHuffCode1, code)); break;
    }
}

int PutIntraShellCombCHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (IntraShellCombCHuffCode0, code)); break;
    case 1: return(PutVLC (IntraShellCombCHuffCode1, code)); break;
    }
}

int PutInterShellCombCHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (InterShellCombCHuffCode0, code)); break;
    case 1: return(PutVLC (InterShellCombCHuffCode1, code)); break;
    }
}

int PutShell1SPYHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (Shell1SPYHuffCode0, code)); break;
    case 1: return(PutVLC (Shell1SPYHuffCode1, code)); break;
    }
}

int PutShell1TPYHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (Shell1TPYHuffCode0, code)); break;
    case 1: return(PutVLC (Shell1TPYHuffCode1, code)); break;
    }
}

int PutShell1SPCHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (Shell1SPCHuffCode0, code)); break;
    case 1: return(PutVLC (Shell1SPCHuffCode1, code)); break;
    }
}

int PutShell1TPCHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (Shell1TPCHuffCode0, code)); break;
    case 1: return(PutVLC (Shell1TPCHuffCode1, code)); break;
    }
}

int PutShell2SPYHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (Shell2SPYHuffCode0, code)); break;
    case 1: return(PutVLC (Shell2SPYHuffCode1, code)); break;
    }
}

int PutShell2TPYHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (Shell2TPYHuffCode0, code)); break;
    case 1: return(PutVLC (Shell2TPYHuffCode1, code)); break;
    }
}

int PutShell2SPCHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (Shell2SPCHuffCode0, code)); break;
    case 1: return(PutVLC (Shell2SPCHuffCode1, code)); break;
    }
}

int PutShell2TPCHuffCode(int code, int index)
{
  switch(index) {
    case 0: return(PutVLC (Shell2TPCHuffCode0, code)); break;
    case 1: return(PutVLC (Shell2TPCHuffCode1, code)); break;
    }
}

int PutMeanSizeHuffCode(int code)
{
  return(PutVLC (MeanSizeHuffCode, code));
}
