#include "Codebook.h"

#define USE_SP_CENTROIDS
#define USE_TP_CENTROIDS

int GN2GroupIndex[255] = { 
  0, 1, 2, 3, 4, 5, 0, 6, 7, 8, 1, 9, 2, 3, 4, 10, 11, 12, 5, 13, 6, 7,
  8, 14, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 15, 19, 16, 17, 18, 20,
  19, 20, 21, 22, 23, 24, 21, 22, 25, 26, 27, 28, 29, 30, 23, 31, 32,
  33, 24, 34, 25, 26, 27, 28, 29, 30, 35, 31, 36, 37, 38, 32, 39, 40,
  41, 42, 43, 44, 33, 34, 45, 46, 47, 48, 49, 50, 35, 51, 52, 53, 36,
  54, 37, 38, 39, 40, 55, 56, 57, 58, 59, 60, 41, 61, 62, 63, 42, 64,
  43, 44, 45, 65, 66, 67, 46, 68, 47, 48, 49, 69, 50, 51, 52, 53, 54,
  55, 70, 71, 72, 56, 73, 57, 74, 58, 59, 60, 75, 61, 62, 63, 64, 76,
  65, 66, 77, 67, 68, 69, 70, 78, 71, 72, 73, 79, 74, 80, 75, 81, 82,
  76, 83, 77, 78, 79, 80, 84, 81, 82, 83, 85, 84, 86, 85, 87, 88, 86,
  87, 89, 88, 90, 89, 91, 92, 93, 90, 94, 95, 96, 97, 91, 98, 92, 99,
  93, 94, 95, 96, 100, 97, 98, 99, 101, 100, 102, 101, 103, 104, 102,
  103, 105, 104, 106, 105, 107, 108, 109, 106, 110, 111, 112, 113, 107,
  114, 108, 109, 115, 110, 116, 111, 117, 118, 119, 112, 120, 121, 122,
  123, 113, 124, 125, 114, 126, 127, 128, 129, 115, 130, 131, 132, 116,
  133, 117, 134, 118, 119
};

int Shell2Index2GN[800] = {
  7, 7, 7, 7, 11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13,
  13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 19, 19, 19, 19, 19, 19, 19,
  19, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23,
  25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27,
  27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29,
  29, 29, 30, 30, 30, 30, 35, 35, 35, 35, 37, 37, 37, 37, 38, 38, 38,
  38, 38, 38, 38, 38, 39, 39, 39, 39, 39, 39, 39, 39, 41, 41, 41, 41,
  41, 41, 41, 41, 42, 42, 42, 42, 43, 43, 43, 43, 44, 44, 44, 44, 45,
  45, 45, 45, 46, 46, 46, 46, 46, 46, 46, 46, 49, 49, 49, 49, 49, 49,
  49, 49, 50, 50, 50, 50, 51, 51, 51, 51, 52, 52, 52, 52, 53, 53, 53,
  53, 54, 54, 54, 54, 54, 54, 54, 54, 56, 56, 56, 56, 56, 56, 56, 56,
  57, 57, 57, 57, 57, 57, 57, 57, 58, 58, 58, 58, 60, 60, 60, 60, 67,
  67, 67, 67, 69, 69, 69, 69, 70, 70, 70, 70, 70, 70, 70, 70, 71, 71,
  71, 71, 71, 71, 71, 71, 73, 73, 73, 73, 73, 73, 73, 73, 74, 74, 74,
  74, 75, 75, 75, 75, 76, 76, 76, 76, 77, 77, 77, 77, 78, 78, 78, 78,
  78, 78, 78, 78, 81, 81, 81, 81, 81, 81, 81, 81, 82, 82, 82, 82, 83,
  83, 83, 83, 84, 84, 84, 84, 85, 85, 85, 85, 86, 86, 86, 86, 86, 86,
  86, 86, 88, 88, 88, 88, 88, 88, 88, 88, 89, 89, 89, 89, 89, 89, 89,
  89, 90, 90, 90, 90, 92, 92, 92, 92, 97, 97, 97, 97, 98, 98, 98, 98,
  98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 100, 100, 100, 100,
  100, 100, 100, 100, 101, 101, 101, 101, 101, 101, 101, 101, 102, 102,
  102, 102, 102, 102, 102, 102, 104, 104, 104, 104, 105, 105, 105, 105,
  106, 106, 106, 106, 106, 106, 106, 106, 108, 108, 108, 108, 108, 108,
  108, 108, 112, 112, 112, 112, 113, 113, 113, 113, 114, 114, 114, 114,
  114, 114, 114, 114, 116, 116, 116, 116, 116, 116, 116, 116, 120, 120,
  120, 120, 127, 127, 127, 127, 128, 128, 128, 128, 129, 129, 129, 129,
  131, 131, 131, 131, 131, 131, 131, 131, 133, 133, 133, 133, 133, 133,
  133, 133, 137, 137, 137, 137, 142, 142, 142, 142, 145, 145, 145, 145,
  150, 150, 150, 150, 154, 154, 154, 154, 154, 154, 154, 154, 156, 156,
  156, 156, 156, 156, 156, 156, 158, 158, 158, 158, 159, 159, 159, 159,
  161, 161, 161, 161, 161, 161, 161, 161, 166, 166, 166, 166, 166, 166,
  166, 166, 170, 170, 170, 170, 172, 172, 172, 172, 174, 174, 174, 174,
  174, 174, 174, 174, 175, 175, 175, 175, 175, 175, 175, 175, 178, 178,
  178, 178, 180, 180, 180, 180, 182, 182, 182, 182, 182, 182, 182, 182,
  183, 183, 183, 183, 183, 183, 183, 183, 184, 184, 184, 184, 184, 184,
  184, 184, 186, 186, 186, 186, 187, 187, 187, 187, 188, 188, 188, 188,
  189, 189, 189, 189, 191, 191, 191, 191, 191, 191, 191, 191, 193, 193,
  193, 193, 193, 193, 193, 193, 198, 198, 198, 198, 198, 198, 198, 198,
  202, 202, 202, 202, 204, 204, 204, 204, 206, 206, 206, 206, 206, 206,
  206, 206, 207, 207, 207, 207, 207, 207, 207, 207, 210, 210, 210, 210,
  212, 212, 212, 212, 214, 214, 214, 214, 214, 214, 214, 214, 215, 215,
  215, 215, 215, 215, 215, 215, 216, 216, 216, 216, 216, 216, 216, 216,
  218, 218, 218, 218, 219, 219, 219, 219, 220, 220, 220, 220, 221, 221,
  221, 221, 223, 223, 223, 223, 223, 223, 223, 223, 226, 226, 226, 226,
  226, 226, 226, 226, 228, 228, 228, 228, 228, 228, 228, 228, 230, 230,
  230, 230, 231, 231, 231, 231, 232, 232, 232, 232, 234, 234, 234, 234,
  234, 234, 234, 234, 235, 235, 235, 235, 235, 235, 235, 235, 236, 236,
  236, 236, 236, 236, 236, 236, 237, 237, 237, 237, 237, 237, 237, 237,
  239, 239, 239, 239, 240, 240, 240, 240, 242, 242, 242, 242, 242, 242,
  242, 242, 243, 243, 243, 243, 243, 243, 243, 243, 244, 244, 244, 244,
  244, 244, 244, 244, 245, 245, 245, 245, 245, 245, 245, 245, 247, 247,
  247, 247, 248, 248, 248, 248, 249, 249, 249, 249, 251, 251, 251, 251,
  251, 251, 251, 251, 253, 253, 253, 253, 253, 253, 253, 253
};


GroupDescriptorStruct Shell1Groups[120] = {
  { 2, 0, 0, { 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25 } },
  { 2, 1, 0, { 0.50, 0.00, 0.00, 0.00, 0.00, 0.00, 0.50, 0.00 } },
  { 2, 2, 0, { 0.25, -0.25, -0.25, -0.25, -0.25, -0.25, 0.25, -0.25 } },
  { 2, 3, 0, { 0.50, 0.00, 0.00, 0.00, 0.00, 0.50, 0.00, 0.00 } },
  { 2, 4, 0, { 0.25, -0.25, -0.25, -0.25, -0.25, 0.25, -0.25, -0.25 } },
  { 2, 5, 0, { 0.00, 0.00, 0.00, 0.00, 0.00, 0.50, -0.50, 0.00 } },
  { 2, 6, 0, { 0.50, 0.00, 0.00, 0.00, 0.50, 0.00, 0.00, 0.00 } },
  { 2, 7, 0, { 0.25, -0.25, -0.25, -0.25, 0.25, -0.25, -0.25, -0.25 } },
  { 2, 8, 0, { 0.00, 0.00, 0.00, 0.00, 0.50, 0.00, -0.50, 0.00 } },
  { 2, 9, 0, { 0.00, 0.00, 0.00, 0.00, 0.50, -0.50, 0.00, 0.00 } },
  { 2, 10, 0, { 0.50, 0.00, 0.00, 0.50, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 11, 0, { 0.25, -0.25, -0.25, 0.25, -0.25, -0.25, -0.25, -0.25 } },
  { 2, 12, 0, { 0.00, 0.00, 0.00, 0.50, 0.00, 0.00, -0.50, 0.00 } },
  { 2, 13, 0, { 0.00, 0.00, 0.00, 0.50, 0.00, -0.50, 0.00, 0.00 } },
  { 2, 14, 0, { 0.00, 0.00, 0.00, 0.50, -0.50, 0.00, 0.00, 0.00 } },
  { 2, 15, 0, { -0.25, -0.25, -0.25, 0.25, 0.25, 0.25, 0.25, -0.25 } },
  { 2, 16, 0, { 0.50, 0.00, 0.50, 0.00, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 17, 0, { 0.25, -0.25, 0.25, -0.25, -0.25, -0.25, -0.25, -0.25 } },
  { 2, 18, 0, { 0.00, 0.00, 0.50, 0.00, 0.00, 0.00, -0.50, 0.00 } },
  { 2, 19, 0, { 0.00, 0.00, 0.50, 0.00, 0.00, -0.50, 0.00, 0.00 } },
  { 2, 20, 0, { 0.00, 0.00, 0.50, 0.00, -0.50, 0.00, 0.00, 0.00 } },
  { 2, 21, 0, { -0.25, -0.25, 0.25, -0.25, 0.25, 0.25, 0.25, -0.25 } },
  { 2, 22, 0, { 0.00, 0.00, 0.50, -0.50, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 23, 0, { -0.25, -0.25, 0.25, 0.25, -0.25, 0.25, 0.25, -0.25 } },
  { 2, 24, 0, { -0.25, -0.25, 0.25, 0.25, 0.25, -0.25, 0.25, -0.25 } },
  { 2, 25, 0, { -0.25, -0.25, 0.25, 0.25, 0.25, 0.25, -0.25, -0.25 } },
  { 2, 26, 0, { 0.00, -0.50, 0.00, 0.00, 0.00, 0.00, 0.00, -0.50 } },
  { 2, 27, 0, { 0.25, -0.25, 0.25, 0.25, 0.25, 0.25, 0.25, -0.25 } },
  { 2, 28, 0, { 0.50, 0.50, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 29, 0, { 0.25, 0.25, -0.25, -0.25, -0.25, -0.25, -0.25, -0.25 } },
  { 2, 30, 0, { 0.00, 0.50, 0.00, 0.00, 0.00, 0.00, -0.50, 0.00 } },
  { 2, 31, 0, { 0.00, 0.50, 0.00, 0.00, 0.00, -0.50, 0.00, 0.00 } },
  { 2, 32, 0, { 0.00, 0.50, 0.00, 0.00, -0.50, 0.00, 0.00, 0.00 } },
  { 2, 33, 0, { -0.25, 0.25, -0.25, -0.25, 0.25, 0.25, 0.25, -0.25 } },
  { 2, 34, 0, { 0.00, 0.50, 0.00, -0.50, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 35, 0, { -0.25, 0.25, -0.25, 0.25, -0.25, 0.25, 0.25, -0.25 } },
  { 2, 36, 0, { -0.25, 0.25, -0.25, 0.25, 0.25, -0.25, 0.25, -0.25 } },
  { 2, 37, 0, { -0.25, 0.25, -0.25, 0.25, 0.25, 0.25, -0.25, -0.25 } },
  { 2, 38, 0, { 0.00, 0.00, -0.50, 0.00, 0.00, 0.00, 0.00, -0.50 } },
  { 2, 39, 0, { 0.25, 0.25, -0.25, 0.25, 0.25, 0.25, 0.25, -0.25 } },
  { 2, 40, 0, { 0.00, 0.50, -0.50, 0.00, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 41, 0, { -0.25, 0.25, 0.25, -0.25, -0.25, 0.25, 0.25, -0.25 } },
  { 2, 42, 0, { -0.25, 0.25, 0.25, -0.25, 0.25, -0.25, 0.25, -0.25 } },
  { 2, 43, 0, { -0.25, 0.25, 0.25, -0.25, 0.25, 0.25, -0.25, -0.25 } },
  { 2, 44, 0, { 0.00, 0.00, 0.00, -0.50, 0.00, 0.00, 0.00, -0.50 } },
  { 2, 45, 0, { 0.25, 0.25, 0.25, -0.25, 0.25, 0.25, 0.25, -0.25 } },
  { 2, 46, 0, { -0.25, 0.25, 0.25, 0.25, -0.25, -0.25, 0.25, -0.25 } },
  { 2, 47, 0, { -0.25, 0.25, 0.25, 0.25, -0.25, 0.25, -0.25, -0.25 } },
  { 2, 48, 0, { 0.00, 0.00, 0.00, 0.00, -0.50, 0.00, 0.00, -0.50 } },
  { 2, 49, 0, { 0.25, 0.25, 0.25, 0.25, -0.25, 0.25, 0.25, -0.25 } },
  { 2, 50, 0, { -0.25, 0.25, 0.25, 0.25, 0.25, -0.25, -0.25, -0.25 } },
  { 2, 51, 0, { 0.00, 0.00, 0.00, 0.00, 0.00, -0.50, 0.00, -0.50 } },
  { 2, 52, 0, { 0.25, 0.25, 0.25, 0.25, 0.25, -0.25, 0.25, -0.25 } },
  { 2, 53, 0, { 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, -0.50, -0.50 } },
  { 2, 54, 0, { 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, -0.25, -0.25 } },
  { 2, 55, 0, { 0.50, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, -0.50 } },
  { 2, 56, 0, { 0.50, 0.00, 0.00, 0.00, 0.00, 0.00, -0.50, 0.00 } },
  { 2, 57, 0, { 0.50, 0.00, 0.00, 0.00, 0.00, -0.50, 0.00, 0.00 } },
  { 2, 58, 0, { 0.00, 0.00, 0.00, 0.00, 0.00, -0.50, -0.50, 0.00 } },
  { 2, 59, 0, { 0.25, 0.25, 0.25, 0.25, 0.25, -0.25, -0.25, 0.25 } },
  { 2, 60, 0, { 0.50, 0.00, 0.00, 0.00, -0.50, 0.00, 0.00, 0.00 } },
  { 2, 61, 0, { 0.00, 0.00, 0.00, 0.00, -0.50, 0.00, -0.50, 0.00 } },
  { 2, 62, 0, { 0.25, 0.25, 0.25, 0.25, -0.25, 0.25, -0.25, 0.25 } },
  { 2, 63, 0, { 0.00, 0.00, 0.00, 0.00, -0.50, -0.50, 0.00, 0.00 } },
  { 2, 64, 0, { 0.25, 0.25, 0.25, 0.25, -0.25, -0.25, 0.25, 0.25 } },
  { 2, 65, 0, { -0.25, 0.25, 0.25, 0.25, -0.25, -0.25, -0.25, 0.25 } },
  { 2, 66, 0, { 0.50, 0.00, 0.00, -0.50, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 67, 0, { 0.00, 0.00, 0.00, -0.50, 0.00, 0.00, -0.50, 0.00 } },
  { 2, 68, 0, { 0.25, 0.25, 0.25, -0.25, 0.25, 0.25, -0.25, 0.25 } },
  { 2, 69, 0, { 0.00, 0.00, 0.00, -0.50, 0.00, -0.50, 0.00, 0.00 } },
  { 2, 70, 0, { 0.25, 0.25, 0.25, -0.25, 0.25, -0.25, 0.25, 0.25 } },
  { 2, 71, 0, { -0.25, 0.25, 0.25, -0.25, 0.25, -0.25, -0.25, 0.25 } },
  { 2, 72, 0, { 0.00, 0.00, 0.00, -0.50, -0.50, 0.00, 0.00, 0.00 } },
  { 2, 73, 0, { 0.25, 0.25, 0.25, -0.25, -0.25, 0.25, 0.25, 0.25 } },
  { 2, 74, 0, { -0.25, 0.25, 0.25, -0.25, -0.25, 0.25, -0.25, 0.25 } },
  { 2, 75, 0, { -0.25, 0.25, 0.25, -0.25, -0.25, -0.25, 0.25, 0.25 } },
  { 2, 76, 0, { 0.50, 0.00, -0.50, 0.00, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 77, 0, { 0.00, 0.00, -0.50, 0.00, 0.00, 0.00, -0.50, 0.00 } },
  { 2, 78, 0, { 0.25, 0.25, -0.25, 0.25, 0.25, 0.25, -0.25, 0.25 } },
  { 2, 79, 0, { 0.00, 0.00, -0.50, 0.00, 0.00, -0.50, 0.00, 0.00 } },
  { 2, 80, 0, { 0.25, 0.25, -0.25, 0.25, 0.25, -0.25, 0.25, 0.25 } },
  { 2, 81, 0, { -0.25, 0.25, -0.25, 0.25, 0.25, -0.25, -0.25, 0.25 } },
  { 2, 82, 0, { 0.00, 0.00, -0.50, 0.00, -0.50, 0.00, 0.00, 0.00 } },
  { 2, 83, 0, { 0.25, 0.25, -0.25, 0.25, -0.25, 0.25, 0.25, 0.25 } },
  { 2, 84, 0, { -0.25, 0.25, -0.25, 0.25, -0.25, 0.25, -0.25, 0.25 } },
  { 2, 85, 0, { -0.25, 0.25, -0.25, 0.25, -0.25, -0.25, 0.25, 0.25 } },
  { 2, 86, 0, { 0.00, 0.00, -0.50, -0.50, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 87, 0, { 0.25, 0.25, -0.25, -0.25, 0.25, 0.25, 0.25, 0.25 } },
  { 2, 88, 0, { -0.25, 0.25, -0.25, -0.25, 0.25, 0.25, -0.25, 0.25 } },
  { 2, 89, 0, { -0.25, 0.25, -0.25, -0.25, 0.25, -0.25, 0.25, 0.25 } },
  { 2, 90, 0, { -0.25, 0.25, -0.25, -0.25, -0.25, 0.25, 0.25, 0.25 } },
  { 2, 91, 0, { 0.00, 0.50, 0.00, 0.00, 0.00, 0.00, 0.00, -0.50 } },
  { 2, 92, 0, { 0.50, -0.50, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 93, 0, { 0.00, -0.50, 0.00, 0.00, 0.00, 0.00, -0.50, 0.00 } },
  { 2, 94, 0, { 0.25, -0.25, 0.25, 0.25, 0.25, 0.25, -0.25, 0.25 } },
  { 2, 95, 0, { 0.00, -0.50, 0.00, 0.00, 0.00, -0.50, 0.00, 0.00 } },
  { 2, 96, 0, { 0.25, -0.25, 0.25, 0.25, 0.25, -0.25, 0.25, 0.25 } },
  { 2, 97, 0, { -0.25, -0.25, 0.25, 0.25, 0.25, -0.25, -0.25, 0.25 } },
  { 2, 98, 0, { 0.00, -0.50, 0.00, 0.00, -0.50, 0.00, 0.00, 0.00 } },
  { 2, 99, 0, { 0.25, -0.25, 0.25, 0.25, -0.25, 0.25, 0.25, 0.25 } },
  { 2, 100, 0, { -0.25, -0.25, 0.25, 0.25, -0.25, 0.25, -0.25, 0.25 } },
  { 2, 101, 0, { -0.25, -0.25, 0.25, 0.25, -0.25, -0.25, 0.25, 0.25 } },
  { 2, 102, 0, { 0.00, -0.50, 0.00, -0.50, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 103, 0, { 0.25, -0.25, 0.25, -0.25, 0.25, 0.25, 0.25, 0.25 } },
  { 2, 104, 0, { -0.25, -0.25, 0.25, -0.25, 0.25, 0.25, -0.25, 0.25 } },
  { 2, 105, 0, { -0.25, -0.25, 0.25, -0.25, 0.25, -0.25, 0.25, 0.25 } },
  { 2, 106, 0, { -0.25, -0.25, 0.25, -0.25, -0.25, 0.25, 0.25, 0.25 } },
  { 2, 107, 0, { 0.00, 0.00, 0.50, 0.00, 0.00, 0.00, 0.00, -0.50 } },
  { 2, 108, 0, { 0.00, -0.50, -0.50, 0.00, 0.00, 0.00, 0.00, 0.00 } },
  { 2, 109, 0, { 0.25, -0.25, -0.25, 0.25, 0.25, 0.25, 0.25, 0.25 } },
  { 2, 110, 0, { -0.25, -0.25, -0.25, 0.25, 0.25, 0.25, -0.25, 0.25 } },
  { 2, 111, 0, { -0.25, -0.25, -0.25, 0.25, 0.25, -0.25, 0.25, 0.25 } },
  { 2, 112, 0, { -0.25, -0.25, -0.25, 0.25, -0.25, 0.25, 0.25, 0.25 } },
  { 2, 113, 0, { 0.00, 0.00, 0.00, 0.50, 0.00, 0.00, 0.00, -0.50 } },
  { 2, 114, 0, { -0.25, -0.25, -0.25, -0.25, 0.25, 0.25, 0.25, 0.25 } },
  { 2, 115, 0, { 0.00, 0.00, 0.00, 0.00, 0.50, 0.00, 0.00, -0.50 } },
  { 2, 116, 0, { 0.00, 0.00, 0.00, 0.00, 0.00, 0.50, 0.00, -0.50 } },
  { 2, 117, 0, { 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.50, -0.50 } },
  { 2, 118, 0, { -0.50, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, -0.50 } },
  { 2, 119, 0, { -0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, -0.25}  }
};

GroupDescriptorStruct Shell2Groups[135] = {
  { 4,0, 2, { 0.50, 4.00, 3.50, 1.00, -3.00, 1.50, 2.00, -2.50 } },
  { 4,4, 0, { -2.50, 1.00, 0.50, 0.00, 4.00, -0.50, 1.50, -5.00 } },
  { 4,12, 0, { -2.50, 1.00, 0.50, 0.00, 4.00, 1.50, -0.50, -5.00 } },
  { 4,20, 3, { -2.25, 0.75, -0.25, 4.75, 4.25, 0.25, 1.25, -1.75 } },
  { 4,24, 3, { -4.00, -1.00, -2.00, 3.00, 2.50, -1.50, -0.50, -3.50 } },
  { 4,28, 0, { -2.50, 1.00, 0.50, 4.00, 0.00, -0.50, 1.50, -5.00 } },
  { 4,36, 0, { -2.50, 1.00, 0.50, 4.00, 0.00, 1.50, -0.50, -5.00 } },
  { 4,44, 1, { -2.00, 0.00, 1.00, 4.00, -2.00, 0.00, 1.00, 5.00 } },
  { 4,48, 1, { -3.75, -1.75, -0.75, 2.25, -3.75, -1.75, -0.75, 3.25 } },
  { 4,52, 3, { -2.25, 0.25, 1.25, 4.25, 4.75, 0.75, -0.25, -1.75 } },
  { 4,56, 0, { -1.25, -0.25, -0.75, 2.75, 0.25, -1.25, 0.75, -6.25 } },
  { 4,64, 0, { 0.25, 1.25, 0.75, 4.25, 1.75, 0.25, 2.25, -4.75 } },
  { 4,72, 0, { -1.25, -0.25, -0.75, 2.75, 0.25, 0.75, -1.25, -6.25 } },
  { 4,80, 0, { 0.25, 1.25, 0.75, 4.25, 1.75, 2.25, 0.25, -4.75 } },
  { 4,88, 1, { 0.00, 1.00, 2.00, 4.00, 0.00, 1.00, 2.00, 5.00 } },
  { 4,92, 1, { 0.50, 4.00, 1.50, -3.00, 1.00, 3.50, 2.00, -2.50 } },
  { 4,96, 3, { -2.25, 0.25, 4.25, 1.25, 0.75, 4.75, -0.25, -1.75 } },
  { 4,100, 0, { -1.25, -0.25, 2.75, -0.75, -1.25, 0.25, 0.75, -6.25 } },
  { 4,108, 0, { 0.25, 1.25, 4.25, 0.75, 0.25, 1.75, 2.25, -4.75 } },
  { 4,116, 0, { -2.50, 1.00, 4.00, 0.50, 1.50, 0.00, -0.50, -5.00 } },
  { 4,124, 1, { 0.50, 3.00, 1.50, -4.00, 1.00, 2.50, 2.00, -3.50 } },
  { 4,128, 1, { -0.25, 2.25, 0.75, -4.75, 0.25, 1.75, 1.25, -4.25 } },
  { 4,132, 2, { -2.00, 5.00, 4.00, -2.00, 0.00, 1.00, 1.00, 0.00 } },
  { 4,136, 2, { -3.75, 3.25, 2.25, -3.75, -1.75, -0.75, -0.75, -1.75 } },
  { 4,140, 0, { 1.25, -0.25, 2.75, -0.75, 0.25, 0.75, 1.25, -6.25 } },
  { 4,148, 0, { -2.50, 1.00, 4.00, 1.50, 0.50, 0.00, -0.50, -5.00 } },
  { 4,156, 3, { -2.25, 0.75, 4.25, 0.25, -0.25, 4.75, 1.25, -1.75 } },
  { 4,160, 3, { -4.00, -1.00, 2.50, -1.50, -2.00, 3.00, -0.50, -3.50 } },
  { 4,164, 1, { -2.00, 1.00, 4.00, 0.00, -2.00, 1.00, 5.00, 0.00 } },
  { 4,168, 1, { -3.75, -0.75, 2.25, -1.75, -3.75, -0.75, 3.25, -1.75 } },
  { 4,172, 0, { 1.25, -0.25, 2.75, 0.25, -0.75, 0.75, 1.25, -6.25 } },
  { 4,180, 0, { -1.25, -0.25, 2.75, 0.25, 0.75, -0.75, -1.25, -6.25 } },
  { 4,188, 0, { 0.25, 1.25, 4.25, 1.75, 2.25, 0.75, 0.25, -4.75 } },
  { 4,196, 2, { 0.00, 5.00, 4.00, 0.00, 1.00, 2.00, 2.00, 1.00 } },
  { 4,200, 1, { 1.00, 2.00, 4.00, 0.00, 1.00, 2.00, 5.00, 0.00 } },
  { 4,204, 3, { -2.25, 4.25, 0.25, 1.25, 0.75, -0.25, 4.75, -1.75 } },
  { 4,208, 1, { 0.50, 1.50, 4.00, -3.00, 1.00, 2.00, 3.50, -2.50 } },
  { 4,212, 0, { -1.25, 2.75, -0.25, -0.75, -1.25, 0.25, 0.75, -6.25 } },
  { 4,220, 0, { 0.25, 4.25, 1.25, 0.75, 0.25, 1.75, 2.25, -4.75 } },
  { 4,228, 0, { -2.50, 4.00, 1.00, 0.50, 1.50, 0.00, -0.50, -5.00 } },
  { 4,236, 2, { -2.00, 4.00, 5.00, -2.00, 0.00, 1.00, 1.00, 0.00 } },
  { 4,240, 2, { -3.75, 2.25, 3.25, -3.75, -1.75, -0.75, -0.75, -1.75 } },
  { 4,244, 1, { 0.50, 1.50, 3.00, -4.00, 1.00, 2.00, 2.50, -3.50 } },
  { 4,248, 1, { -0.25, 0.75, 2.25, -4.75, 0.25, 1.25, 1.75, -4.25 } },
  { 4,252, 0, { 1.25, 2.75, -0.25, -0.75, 0.25, 0.75, 1.25, -6.25 } },
  { 4,260, 0, { -2.50, 4.00, 1.00, 1.50, 0.50, 0.00, -0.50, -5.00 } },
  { 4,268, 1, { -2.00, 4.00, 1.00, 0.00, -2.00, 5.00, 1.00, 0.00 } },
  { 4,272, 1, { -3.75, 2.25, -0.75, -1.75, -3.75, 3.25, -0.75, -1.75 } },
  { 4,276, 3, { -2.25, 4.25, 0.75, 0.25, -0.25, 1.25, 4.75, -1.75 } },
  { 4,280, 3, { -4.00, 2.50, -1.00, -1.50, -2.00, -0.50, 3.00, -3.50 } },
  { 4,284, 0, { 1.25, 2.75, -0.25, 0.25, -0.75, 0.75, 1.25, -6.25 } },
  { 4,292, 0, { -1.25, 2.75, -0.25, 0.25, 0.75, -0.75, -1.25, -6.25 } },
  { 4,300, 0, { 0.25, 4.25, 1.25, 1.75, 2.25, 0.75, 0.25, -4.75 } },
  { 4,308, 1, { 1.00, 4.00, 2.00, 0.00, 1.00, 5.00, 2.00, 0.00 } },
  { 4,312, 2, { 0.00, 4.00, 5.00, 0.00, 1.00, 2.00, 2.00, 1.00 } },
  { 4,316, 2, { 0.50, 2.50, 3.00, 1.00, -2.00, 4.00, 3.50, -1.50 } },
  { 4,320, 0, { -1.25, 3.25, -0.25, -0.75, -1.25, -1.75, 0.75, -5.75 } },
  { 4,328, 0, { 0.50, 5.00, 1.50, 1.00, 0.50, 0.00, 2.50, -4.00 } },
  { 4,336, 0, { -1.25, 3.25, -0.25, -0.75, -1.25, 0.75, -1.75, -5.75 } },
  { 4,344, 0, { 0.50, 5.00, 1.50, 1.00, 0.50, 2.50, 0.00, -4.00 } },
  { 4,352, 0, { 1.75, 3.25, -0.25, -0.75, -1.25, 0.75, 1.25, -5.75 } },
  { 4,360, 3, { -1.25, 4.25, -1.75, -0.25, 0.25, -2.25, 4.75, -0.75 } },
  { 4,364, 3, { -2.00, 3.50, -2.50, -1.00, -0.50, -3.00, 4.00, -1.50 } },
  { 4,368, 0, { 1.75, 3.25, -0.25, -0.75, 0.75, -1.25, 1.25, -5.75 } },
  { 4,376, 0, { 1.75, 3.25, -0.25, -0.75, 0.75, 1.25, -1.25, -5.75 } },
  { 4,384, 1, { -1.75, 4.25, 0.25, 0.75, -2.25, 4.75, -0.25, 1.25 } },
  { 4,388, 1, { -3.50, 2.50, -1.50, -1.00, -4.00, 3.00, -2.00, -0.50 } },
  { 4,392, 0, { 2.00, 3.50, 0.00, 0.50, -1.00, -1.50, 1.00, -5.50 } },
  { 4,400, 0, { 2.00, 3.50, 0.00, 0.50, -1.00, 1.00, -1.50, -5.50 } },
  { 4,408, 1, { 2.25, 4.25, 0.25, 0.75, 1.75, 4.75, -0.25, 1.25 } },
  { 4,412, 3, { -4.75, 1.75, 0.75, -0.25, 0.25, 1.25, 2.25, -4.25 } },
  { 4,416, 1, { 0.50, -3.00, -2.00, -3.50, 1.00, -2.50, -1.50, -4.00 } },
  { 4,420, 1, { 4.25, 0.75, 1.75, 0.25, 4.75, 1.25, 2.25, -0.25 } },
  { 4,424, 0, { -1.50, -1.50, -1.00, -0.50, 0.00, 0.50, -3.00, 6.00 } },
  { 4,432, 0, { -1.50, -1.50, -1.00, -0.50, 0.00, -3.00, 0.50, 6.00 } },
  { 4,440, 1, { -4.00, 1.50, 2.50, 1.00, -3.50, 2.00, 3.00, 0.50 } },
  { 4,444, 3, { 0.50, -2.00, -3.00, -4.00, -3.50, -2.50, -1.50, 1.00 } },
  { 4,448, 2, { -4.00, 0.50, 1.00, -3.50, 2.00, 2.50, 3.00, 1.50 } },
  { 4,452, 1, { 0.50, -3.00, -2.00, -3.50, 1.00, -2.50, -1.50, -4.00 } },
  { 4,456, 0, { 0.50, 3.50, 3.00, -2.00, -1.50, 2.50, -1.00, -4.00 } },
  { 4,464, 0, { 0.50, 3.50, 3.00, -2.00, -1.50, -1.00, 2.50, -4.00 } },
  { 4,472, 1, { -3.00, -2.00, -1.00, -3.50, -2.50, -1.50, -0.50, -4.00 } },
  { 4,476, 1, { 1.50, 2.50, 3.50, 1.00, 2.00, 3.00, 4.00, 0.50 } },
  { 4,480, 0, { -1.50, -1.50, -3.00, -1.00, -0.50, 0.00, 0.50, 6.00 } },
  { 4,488, 0, { 0.75, 4.75, -2.75, 2.25, 1.75, -1.75, -1.25, -2.75 } },
  { 4,496, 2, { 0.75, -3.75, -3.75, 0.75, -1.75, -3.25, -2.25, -1.75 } },
  { 4,500, 2, { 0.75, -3.75, -3.75, 0.75, -1.75, -2.25, -3.25, -1.75 } },
  { 4,504, 0, { -1.75, 4.75, -2.75, 2.25, -1.75, -1.25, -0.75, -2.75 } },
  { 4,512, 0, { -0.75, 5.75, -1.75, 3.25, -0.75, -0.25, 0.25, -1.75 } },
  { 4,520, 3, { -0.25, -4.75, -1.75, -0.75, -1.25, -2.25, -4.25, 0.25 } },
  { 4,524, 1, { 0.75, -1.75, -3.25, -2.75, 0.75, -1.75, -4.25, -2.75 } },
  { 4,528, 0, { -1.50, 5.00, -2.50, -2.00, 2.00, -1.50, -1.00, -2.50 } },
  { 4,536, 0, { -0.50, 6.00, -1.50, -1.00, 3.00, -0.50, 0.00, -1.50 } },
  { 4,544, 0, { 1.00, 5.00, -2.50, -2.00, -1.50, 2.00, 1.50, -2.50 } },
  { 4,552, 2, { -1.75, -2.75, -2.75, -1.75, -0.75, -4.25, -3.25, -0.75 } },
  { 4,556, 2, { 2.75, 1.75, 1.75, 2.75, 3.75, 0.25, 1.25, 3.75 } },
  { 4,560, 1, { -1.75, -0.75, -3.25, -2.75, -1.75, -0.75, -4.25, -2.75 } },
  { 4,564, 1, { 2.75, 3.75, 1.25, 1.75, 2.75, 3.75, 0.25, 1.75 } },
  { 4,568, 0, { -2.75, 6.25, -1.25, -0.75, -0.25, 0.25, 0.75, -1.25 } },
  { 4,576, 0, { -1.50, -3.00, -1.50, -1.00, -0.50, 0.00, 0.50, 6.00 } },
  { 4,584, 0, { 1.25, -4.25, 3.25, 2.75, 2.25, -2.25, -1.75, -0.25 } },
  { 4,592, 2, { -2.00, -1.00, -1.00, -2.00, -4.50, -0.50, 0.50, -4.50 } },
  { 4,596, 2, { -2.00, -1.00, -1.00, -2.00, -4.50, 0.50, -0.50, -4.50 } },
  { 4,600, 0, { -2.25, -4.25, 3.25, 2.75, -2.25, -1.75, -1.25, -0.25 } },
  { 4,608, 0, { -0.75, -2.75, 4.75, 4.25, -0.75, -0.25, 0.25, 1.25 } },
  { 4,616, 1, { -0.75, -1.75, -0.25, -4.75, -1.25, -2.25, 0.25, -4.25 } },
  { 4,620, 3, { -3.00, 1.00, -2.00, -3.50, -4.00, -1.50, 0.50, -2.50 } },
  { 4,624, 0, { -2.00, -4.00, 3.50, -2.50, 2.50, -2.00, -1.50, 0.00 } },
  { 4,632, 0, { -0.50, -2.50, 5.00, -1.00, 4.00, -0.50, 0.00, 1.50 } },
  { 4,640, 0, { 1.50, -4.00, 3.50, -2.50, -2.00, 2.50, 2.00, 0.00 } },
  { 4,648, 1, { 2.25, -0.75, -0.25, -4.75, 1.75, -1.25, 0.25, -4.25 } },
  { 4,652, 1, { 4.00, 1.00, 1.50, -3.00, 3.50, 0.50, 2.00, -2.50 } },
  { 4,656, 2, { 2.00, 0.00, 0.00, 2.00, -4.50, -0.50, -1.50, -4.50 } },
  { 4,660, 2, { 3.75, 1.75, 1.75, 3.75, -2.75, 1.25, 0.25, -2.75 } },
  { 4,664, 0, { -3.75, -2.25, 5.25, -0.75, -0.25, 0.25, 0.75, 1.75 } },
  { 4,672, 0, { 2.00, -3.50, -3.00, 3.00, 2.50, 2.00, -2.50, 0.50 } },
  { 4,680, 0, { 2.00, -3.50, -3.00, 3.00, 2.50, -2.50, 2.00, 0.50 } },
  { 4,688, 1, { -1.50, -4.00, -3.00, -1.00, -2.00, -3.50, -2.50, -0.50 } },
  { 4,692, 1, { 3.00, 0.50, 1.50, 3.50, 2.50, 1.00, 2.00, 4.00 } },
  { 4,696, 3, { -4.75, -1.75, -0.75, -0.25, 0.25, -1.25, -2.25, -4.25 } },
  { 4,700, 0, { -2.00, -3.50, -3.00, 3.00, -2.50, 2.50, -2.00, 0.50 } },
  { 4,708, 0, { -0.25, -1.75, -1.25, 4.75, -0.75, 4.25, -0.25, 2.25 } },
  { 4,716, 0, { -2.00, -3.50, -3.00, 3.00, -2.50, -2.00, 2.50, 0.50 } },
  { 4,724, 0, { -0.25, -1.75, -1.25, 4.75, -0.75, -0.25, 4.25, 2.25 } },
  { 4,732, 1, { -4.25, -1.25, -0.25, 1.75, -4.75, -0.75, 0.25, 2.25 } },
  { 4,736, 1, { 0.25, -0.75, -1.75, -4.75, -0.25, -1.25, -2.25, -4.25 } },
  { 4,740, 0, { -2.00, -3.50, -3.00, -2.50, 3.00, 2.50, -2.00, 0.50 } },
  { 4,748, 0, { -0.25, -1.75, -1.25, -0.75, 4.75, 4.25, -0.25, 2.25 } },
  { 4,756, 0, { -2.00, -3.50, -3.00, -2.50, 3.00, -2.00, 2.50, 0.50 } },
  { 4,764, 0, { -0.25, -1.75, -1.25, -0.75, 4.75, -0.25, 4.25, 2.25 } },
  { 4,772, 2, { -4.25, -1.25, -0.75, -4.75, 1.75, -0.25, 0.25, 2.25 } },
  { 4,776, 1, { 2.25, 0.25, -0.75, -4.75, 1.75, -0.25, -1.25, -4.25 } },
  { 4,780, 1, { 4.00, 2.00, 1.00, -3.00, 3.50, 1.50, 0.50, -2.50 } },
  { 4,784, 0, { -4.00, -1.50, -1.00, -0.50, 0.00, 5.00, 0.50, 2.50 } },
  { 4,792, 0, { -4.00, -1.50, -1.00, -0.50, 0.00, 0.50, 5.00, 2.50 } }
};

#ifdef USE_SP_CENTROIDS

double Shell1SPYCodebook0[120*8] = {
#include "Codebooks/CentroShell1SPY0"
};

double Shell1SPYCodebook1[120*8] = {
#include "Codebooks/CentroShell1SPY1"
};


double Shell1SPCCodebook0[120*8] = {
#include "Codebooks/CentroShell1SPC0"
};

double Shell1SPCCodebook1[120*8] = {
#include "Codebooks/CentroShell1SPC1"
};

double Shell2SPYCodebook0[800*8] = {
#include "Codebooks/CentroShell2SPY0"
};

double Shell2SPYCodebook1[800*8] = {
#include "Codebooks/CentroShell2SPY1"
};

double Shell2SPCCodebook0[800*8] = {
#include "Codebooks/CentroShell2SPC0"
};

double Shell2SPCCodebook1[800*8] = {
#include "Codebooks/CentroShell2SPC1"
};

#else

double Shell1SPYCodebook0[120*8] = {
#include "Codebooks/Shell1Default"
};

double Shell1SPYCodebook1[120*8] = {
#include "Codebooks/Shell1Default"
};

double Shell1SPCCodebook0[120*8] = {
#include "Codebooks/Shell1Default"
};
double Shell1SPCCodebook1[120*8] = {
#include "Codebooks/Shell1Default"
};

double Shell2SPYCodebook0[800*8] = {
#include "Codebooks/Shell2Default"
};

double Shell2SPYCodebook1[800*8] = {
#include "Codebooks/Shell2Default"
};

double Shell2SPCCodebook0[800*8] = {
#include "Codebooks/Shell2Default"
};
double Shell2SPCCodebook1[800*8] = {
#include "Codebooks/Shell2Default"
};

#endif

#ifdef USE_TP_CENTROIDS

double Shell1TPYCodebook0[120*8] = {
#include "Codebooks/CentroShell1TPY0"
};
double Shell1TPYCodebook1[120*8] = {
#include "Codebooks/CentroShell1TPY1"
};

double Shell1TPCCodebook0[120*8] = {
#include "Codebooks/CentroShell1TPC0"
};
double Shell1TPCCodebook1[120*8] = {
#include "Codebooks/CentroShell1TPC1"
};

double Shell2TPYCodebook0[800*8] = {
#include "Codebooks/CentroShell2TPY0"
};
double Shell2TPYCodebook1[800*8] = {
#include "Codebooks/CentroShell2TPY1"
};

double Shell2TPCCodebook0[800*8] = {
#include "Codebooks/CentroShell2TPC0"
};
double Shell2TPCCodebook1[800*8] = {
#include "Codebooks/CentroShell2TPC1"
};
#else
double Shell1TPYCodebook0[120*8] = {
#include "Codebooks/Shell1Default"
};
double Shell1TPYCodebook1[120*8] = {
#include "Codebooks/Shell1Default"
};

double Shell1TPCCodebook0[120*8] = {
#include "Codebooks/Shell1Default"
};
double Shell1TPCCodebook1[120*8] = {
#include "Codebooks/Shell1Default"
};

double Shell2TPYCodebook0[800*8] = {
#include "Codebooks/Shell2Default"
};
double Shell2TPYCodebook1[800*8] = {
#include "Codebooks/Shell2Default"
};
double Shell2TPCCodebook0[800*8] = {
#include "Codebooks/Shell2Default"
};
double Shell2TPCCodebook1[800*8] = {
#include "Codebooks/Shell2Default"
};
#endif
