#include <stdio.h>
#include "Image.h"
#include "KhorosIO.h"

void ReadYUVKhorosFormat(char *base, int index, FramePtr theFrame) {
  char filename[256];

  sprintf(filename,"%s.y.%d", base, index);
  LoadKhorosImagefile(filename, theFrame->Y);

  sprintf(filename,"%s.u.%d", base, index);
  LoadKhorosImagefile(filename, theFrame->U);

  sprintf(filename,"%s.v.%d", base, index);
  LoadKhorosImagefile(filename, theFrame->V);
}

void LoadRawImagefile(char *name, ImagePtr theImage) {
  FILE *in;
  int j;

  in = fopen(name,"r");

  fprintf(stderr,"%s\n", name);

  if (in==NULL) error(__FILE__,__LINE__,"File not found");

  for (j=0; j<theImage->h; j++) {
    fread(theImage->data+j*theImage->w,theImage->w,1,in);
  }

  fclose(in);
}

void SaveRawImagefile(char *name, ImagePtr theImage) {
  FILE *out;
  int j;

  out = fopen(name,"w");

  fprintf(stderr,"%s (%dx%d)\n", name, theImage->w, theImage->h);

  if (out==NULL) error(__FILE__,__LINE__,"File not found");

  for (j=0; j<theImage->h; j++) {
    fwrite(theImage->data+j*theImage->w,theImage->w,1,out);
  }

  fclose(out);
}

void ReadYUVRawFormat(char *base, int index, FramePtr theFrame) {
  char filename[256];

  sprintf(filename,"%s%03d.y", base, index);
  LoadRawImagefile(filename, theFrame->Y);

  sprintf(filename,"%s%03d.u", base, index);
  LoadRawImagefile(filename, theFrame->U);

  sprintf(filename,"%s%03d.v", base, index);
  LoadRawImagefile(filename, theFrame->V);
}

void ReadYUVRawFrameFormat(char *base, int index, FramePtr theFrame) {
  char filename[256];

  sprintf(filename,"%s%03d.y", base, index);
  LoadRawImagefile(filename, theFrame->Y);

  sprintf(filename,"%s%03d.u", base, index);
  LoadRawImagefile(filename, theFrame->U);

  sprintf(filename,"%s%03d.v", base, index);
  LoadRawImagefile(filename, theFrame->V);
}

void ReadYUVRawSeqFormat(char *base, int offset, int index, FramePtr theFrame) {
  FILE *in;
  int j;
  int w = theFrame->Y->w;
  int h = theFrame->Y->h;

  in = fopen(base,"r");
  if(in == NULL) {
    perror("fopen");
    exit(1);
  }

  if(fseek(in, offset+((index*w*h*3)>>1), SEEK_SET) < 0) {
    perror("fseek");
    exit(1);
  }

  for (j=0; j<h; j++) 
    fread(theFrame->Y->data+(j*w),w,1,in);

  for (j=0; j<(h/2); j++) 
    fread(theFrame->U->data+(j*w/2),w/2,1,in);

  for (j=0; j<h/2; j++) 
    fread(theFrame->V->data+(j*w/2),w/2,1,in);

  fclose(in);
}

void ReadYUVRawStreamFormat(char *base, FramePtr theFrame) {
  static FILE *in = NULL;
  int j;
  int w = theFrame->Y->w;
  int h = theFrame->Y->h;

  if(in == NULL) {
    in = fopen(base,"r");
    if(in == NULL) {
      perror("fopen");
      exit(1);
    }
  }

  for (j=0; j<h; j++) 
    fread(theFrame->Y->data+(j*w),w,1,in);

  for (j=0; j<(h/2); j++) 
    fread(theFrame->U->data+(j*w/2),w/2,1,in);

  for (j=0; j<h/2; j++) 
    fread(theFrame->V->data+(j*w/2),w/2,1,in);
}


void ReadYKhorosFormat(char *base, int index, ImagePtr theImage) {
  char filename[256];

  sprintf(filename,"%s.y.%d", base, index);
  LoadKhorosImagefile(filename, theImage);
}

void SaveYUVKhorosFormat(FramePtr theFrame, char *base, int index) {
  char filename[256];
  
  sprintf(filename,"%s.y.%d", base, index);
  SaveKhorosImagefile(filename, theFrame->Y);

  sprintf(filename,"%s.u.%d", base, index);
  SaveKhorosImagefile(filename, theFrame->U);

  sprintf(filename,"%s.v.%d", base, index);
  SaveKhorosImagefile(filename, theFrame->V);
}

void SaveYKhorosFormat(ImagePtr theImage, char *base, int index) {
  char filename[256];
  
  sprintf(filename,"%s.y.%d", base, index);
  SaveKhorosImagefile(filename, theImage);
}
