#include <string.h>
#include "Parameter.h"
#include "Headers.h"
#include "Output.h"

void ResetSequenceHeader()
{
  memset(&SeqHdr,0, sizeof(SequenceHeaderStruct));
}

void ResetPictureHeader()
{
  memset(&PictHdr,0,sizeof(PictureHeaderStruct));
}

int SequenceHeaderSize() {
  return(27+20*SeqHdr.Layers+24*SeqHdr.Layers);
}

void CodeSequenceHeader()
{
  int i;

  EmitBits(SeqHdr.HSize, 12,"Seq Header");  
  EmitBits(SeqHdr.VSize, 12,"Seq Header");  

  EmitBits(SeqHdr.Layers, 3,"Seq Header");

  for (i=0; i<SeqHdr.Layers; i++)
    EmitBits(SeqHdr.BlockWidth[i], 5,"Seq Header");

  for (i=0; i<SeqHdr.Layers; i++)
    EmitBits(SeqHdr.BlockHeight[i], 5,"Seq Header");

  for (i=0; i<SeqHdr.Layers; i++)
    EmitBits(SeqHdr.XSubsamp[i], 5,"Seq Header");

  for (i=0; i<SeqHdr.Layers; i++)
    EmitBits(SeqHdr.YSubsamp[i], 5,"Seq Header");

  for (i=0; i<SeqHdr.Layers; i++)
    EmitBits(SeqHdr.IPreset[i], 8,"Seq Header");

  for (i=0; i<SeqHdr.Layers; i++)
    EmitBits(SeqHdr.PPreset[i], 8,"Seq Header");

  for (i=0; i<SeqHdr.Layers; i++)
    EmitBits(SeqHdr.BPreset[i], 8,"Seq Header");
}

void CodePictureHeader()
{
  EmitBits(PictHdr.TempRef, 8,"Pict Header");
  EmitBits(PictHdr.CodingType, 2,"Pict Header");
}
