#include <stdio.h>
#include <string.h>

#include "DataTypes.h"
#include "Util.h"
#include "KhorosIO.h"

static void SetDefaultKHeader (KImageHeader *kHeader) {

  kHeader->row_size = 704;
  kHeader->col_size = 480;

  kHeader->identifier = -85;
  kHeader->file_type = 1;
  kHeader->release = 1;
  kHeader->version = 3;
  kHeader->machine_dep = 2;

  kHeader->subrow_size = 0;
  kHeader->startx = 0;
  kHeader->starty = 0;
  kHeader->pixsizx = 1;
  kHeader->pixsizy = 1;
  kHeader->location_type = 1;
  kHeader->location_dim = 0;
  kHeader->num_of_images = 1;
  kHeader->num_data_bands = 1;
  kHeader->data_storage_type = 1;
  kHeader->data_encode_scheme = 0;
  kHeader->map_scheme = 0;
  kHeader->map_storage_type = 0;
  kHeader->map_row_size = 1;
  kHeader->map_col_size = 256;
  kHeader->map_subrow_size = 0;
  kHeader->map_enable = 1;
  kHeader->maps_per_cycle = 0;
  kHeader->color_space_model = 0;
  kHeader->ispare1 = 0;
  kHeader->ispare2 = 0;
  kHeader->fspare1 = 0;
  kHeader->fspare2 = 0;

  kHeader->maps = 0x0;
  kHeader->location = 0x0;
  kHeader->imagedata = 0x0;
}

void GetKhorosImagefileDimensions(char *name, int *w, int *h) {
  FILE *in;
  KImageHeader *xvheader;
  int errnum;

  xvheader = NEW(KImageHeader);

  in = fopen(name,"r");

  if (in==NULL) error(__FILE__,__LINE__,"File not found");

  fread(xvheader, sizeof(KImageHeader), 1, in);

  errnum = ferror(in);

  if (errnum) error(__FILE__,__LINE__,"Error after file reading");

  fclose(in);

  *w = xvheader->row_size;
  *h = xvheader->col_size;

  free(xvheader);
}

void GetKhorosYImagefileDimensions(char *name, int index, int *w, int *h) {
  FILE *in;
  KImageHeader *xvheader;
  char yname[120];
  int errnum;

  xvheader = NEW(KImageHeader);

  sprintf(yname,"%s.y.%d", name, index);
  fprintf(stderr,"%s\n", yname);

  in = fopen(yname,"r");

  if (in==NULL) error(__FILE__,__LINE__,"File not found");

  fread(xvheader, sizeof(KImageHeader), 1, in);

  errnum = ferror(in);

  if (errnum) error(__FILE__,__LINE__,"Error after reading data");

  fclose(in);

  *w = xvheader->row_size;
  *h = xvheader->col_size;

  free(xvheader);
}

void LoadKhorosImagefile(char *name, ImagePtr theImage) {
  FILE *in;
  KImageHeader xvheader;
  int errnum;
  int j;

  in = fopen(name,"r");

  if (in==NULL) error(__FILE__,__LINE__,"File not found");

  fread(&xvheader, sizeof(KImageHeader), 1, in);

  errnum = ferror(in);

  if (errnum) error(__FILE__,__LINE__,"Error while reading file");

  if (xvheader.data_storage_type != VFF_TYP_1_BYTE) {
    error(__FILE__,__LINE__,"Unexpected data type");
  }
/*
  for (j=0; j<theImage->oh; j++) {
    fread(theImage->data+j*theImage->w,theImage->ow,1,in);
    for (i=theImage->ow; i<theImage->w; i++)
      theImage->data[j*theImage->w+i] = theImage->data[j*theImage->w+theImage->ow-1];
  }
  for (j=theImage->oh; j<theImage->h; j++)
    memcpy(theImage->data+j*theImage->w, theImage->data+((theImage->oh-1)*theImage->w), theImage->w);
*/
  for (j=0; j<theImage->h; j++) {
    fread(theImage->data+j*theImage->w,theImage->w,1,in);
  }

  fclose(in);
}

void SaveKhorosImagefile(char *name, ImagePtr theImage) {
  FILE *out;
  KImageHeader xvheader;
  int errnum;
  int j;

  out = fopen(name,"w");

  if (out==NULL) error(__FILE__,__LINE__,"Cannot open file for writing");

  SetDefaultKHeader(&xvheader);

  xvheader.data_storage_type = VFF_TYP_1_BYTE;
  xvheader.row_size = theImage->w;
  xvheader.col_size = theImage->h;


  fwrite(&xvheader, sizeof(KImageHeader), 1, out);

  errnum = ferror(out);

  if (errnum) error(__FILE__,__LINE__,"Error while writing file");

  for (j=0; j<theImage->h; j++) 
     fwrite(theImage->data+j*theImage->w,theImage->w,1,out);

  fclose(out);

}


