#include "Motion.h"
#include "VLC.h"
#include "CodeSymbol.h"
#include "Output.h"

static void EncodeMV (int delta)
{
  if (delta < -32) delta += 64;
  else if (delta > 31) delta -= 64;

  delta += 32;

  if ((delta < 0) || (delta > 63)) {
    fprintf(stderr,"MV range exceeded\n");
    exit(1);
  }
  MEstiBits += PutMVHuffCode(delta);
}

void CodeFXComponent (int x)
{
  EncodeMV(x);
}

void CodeFYComponent (int y)
{
  EncodeMV(y);
}

static void EncodeRefineMV (int delta)
{
  delta += 32;

  if ((delta < 0) || (delta > 63)) {
    fprintf(stderr,"MV range exceeded\n");
    exit(1);
  }
  MEstiBits += PutMVHuffCode(delta);
}

void CodeFXRefineComponent (int x)
{
  EncodeRefineMV(x);
}

void CodeFYRefineComponent (int y)
{
  EncodeRefineMV(y);
}

