#include "Syntax.h"
#include "Output.h"

static int GlobalPutBits;
static unsigned long GlobalPutBuffer;

static Ptr OutputBuffer;
static int OutputBufferSize;
static int BP;

static FILE *OutputFile;

static void UpdateStream ()
{
  int Saved;

  Saved = fwrite(OutputBuffer, 1, BP, OutputFile);
  
  if (Saved != BP)
    error(__FILE__,__LINE__,"Output file write error");

  BP = 0;
}

static int Emit16Bits (int code, int size)
{

  register unsigned long PutBuffer = code;
  register int PutBits = GlobalPutBits;

  GlobalBitCount += size;

  PutBuffer &= (((unsigned long) 1) << size) - 1; 
  /* Mask off any excess bits in code */

  PutBits += size;		   /* new number of bits in buffer */
  
  PutBuffer <<= 24 - PutBits;  /* align incoming bits */

  PutBuffer |= GlobalPutBuffer; /* and merge with old buffer contents */
  
  while (PutBits >= 8) {

    OutputBuffer[BP++] = (unsigned char) ((PutBuffer >> 16) & 0xFF);

    if (BP>2)
      if ( (((OutputBuffer[BP-3]<<16)| (OutputBuffer[BP-2]<<8) | OutputBuffer[BP-1])  & 0x00ffffff) == 0x00000001) {
	fprintf(stderr,"@@@ Sync emitted\n");
      }

    if (BP==OutputBufferSize)
      UpdateStream();
    
    PutBuffer <<= 8;
    PutBits -= 8;
  }
    
  GlobalPutBuffer = PutBuffer;	/* Update global variables */
  GlobalPutBits = PutBits;
  return(size);
}

static void PrintBits(int val, int size) {
  int i;

  for (i=0; i<size; i++) {
    if ( (1<<(size-i)-1) & val) 
      fprintf(stderr,"1");
    else
      fprintf(stderr,"0");
  }
}

extern int FrameNr;

int EmitBits (int code, int size, char *doc) {
  /*
  if (FrameNr>=6) {
    fprintf(stderr,">>> near %d, %s: ", BP, doc);
    PrintBits(code,size);
    fprintf(stderr,"\n");
  }
  */
  if (size==0) {
    fprintf(stderr,"Trying to output zero bits\n");
    exit(1);
  }

  if (size<=16) {
    Emit16Bits(code, size);
  } else {
    Emit16Bits((code>>16), (size-16));
    Emit16Bits(code, 16);
  }
  return(size);
}

static void FlushBitBuffer ()
{
  EmitBits((unsigned short) 0xff, 7,"flushing");	/* fill any partial byte with ones */
  GlobalPutBuffer = 0;		        /* and reset bit-buffer to empty */
  GlobalPutBits = 0;
}

void EmitSyncCode (int code)
{
  FlushBitBuffer();
  EmitBits (1, 24,"23x zeros, 1x one");
  EmitBits (code,8,"8 bit Sync code type");
}

void SendStartOfSlice()
{
  EmitSyncCode(SLICE_START_CODE);
}

void SendStartOfLayer(int l, int coding) {
  EmitSyncCode(LAYER_START_CODE | ((coding&3)<<2) | (l&3));
  fprintf(stderr,"@@@ Layer start, coding=%d, n=%d\n", coding, l);
}

void SendStartOfPicture(int first, int coding) {
  EmitSyncCode(PICTURE_START_CODE | ((coding&3)<<2) | (first&3));
  fprintf(stderr,"@@@ Picture start, coding=%d, first=%d\n", coding, first);
}



void OpenOutputBitstream(String name, int bufsize)
{
  if (name[0]=='-')
    OutputFile = fopen("/dev/null","w");
  else
    OutputFile = fopen(name,"w");

  if (OutputFile == NULL)
    EXIT_WITH_ERR ("Cannot open output file");

  OutputBuffer = NEWELEMS (Byte,bufsize);
  OutputBufferSize = bufsize;
  BP = 0;

  GlobalPutBits = 0;
  GlobalPutBuffer = 0;
}

void CloseOutputBitstream()
{
  FlushBitBuffer();

  if (BP>0)
    UpdateStream();

  fclose(OutputFile);
}

