#include "Parameter.h"

void ReadParameter (char *ParFile)
{
  int i,n;
  char c;
  int eof;
  FILE *inFile;

  fprintf(stderr,"============== Begin Parameter Section =======================\n");
  inFile = fopen(ParFile,"r");

  if (inFile==NULL) EXIT_WITH_ERR("Cannot open parameter file");

  do {
    c = getc(inFile);
    eof = feof(inFile);
    if (! eof )
      fprintf(stderr,"%c",c);
  } while (! eof);

  fclose(inFile);
  fprintf(stderr,"================ End Parameter Section =======================\n");
  inFile = fopen(ParFile,"r");

  fscanf(inFile,"InputBase: %s\n", ParBlk.InputBase);
  fscanf(inFile,"Format: %d\n", &ParBlk.Format);
  fscanf(inFile,"FirstFrame: %d\n", & ParBlk.FirstFrame);
  fscanf(inFile,"LastFrame: %d\n", &ParBlk.LastFrame);
  fscanf(inFile,"OutputBase: %s\n", ParBlk.OutputBase);
  fscanf(inFile,"Stream: %s\n", ParBlk.Stream);
  fscanf(inFile,"Codebook: %s\n", ParBlk.Codebook);
  fscanf(inFile,"HSize: %d\n", &SeqHdr.HSize);
  fscanf(inFile,"VSize: %d\n", &SeqHdr.VSize);
  fscanf(inFile,"Layers: %d\n", &SeqHdr.Layers);
  fscanf(inFile,"N: %d\n", &ParBlk.N);
  fscanf(inFile,"M: %d\n", &ParBlk.M);

  fscanf(inFile,"BlockWidth: ");
  for (n=0; n<SeqHdr.Layers-1; n++) 
      fscanf(inFile,"%d, ", &SeqHdr.BlockWidth[n]);
  fscanf(inFile,"%d\n", &SeqHdr.BlockWidth[n]);

  fscanf(inFile,"BlockHeight: ");
  for (n=0; n<SeqHdr.Layers-1; n++) 
      fscanf(inFile,"%d, ", &SeqHdr.BlockHeight[n]);
  fscanf(inFile,"%d\n", &SeqHdr.BlockHeight[n]);

  fscanf(inFile,"XSubsamp: ");
  for (n=0; n<SeqHdr.Layers-1; n++) 
      fscanf(inFile,"%d, ", &SeqHdr.XSubsamp[n]);
  fscanf(inFile,"%d\n", &SeqHdr.XSubsamp[n]);

  fscanf(inFile,"YSubsamp: ");
  for (n=0; n<SeqHdr.Layers-1; n++) 
      fscanf(inFile,"%d, ", &SeqHdr.YSubsamp[n]);
  fscanf(inFile,"%d\n", &SeqHdr.YSubsamp[n]);


  fscanf(inFile,"SearchRange: %d\n", &ParBlk.SearchRange);
  fscanf(inFile,"PyraLength: %d\n", &ParBlk.PyraLength);

  ParBlk.LayerCoding = (int *) malloc (SeqHdr.Layers*(ParBlk.N)*sizeof(int));
  for (i=0; i<ParBlk.PyraLength; i++) {
    for (n=0; n<SeqHdr.Layers; n++) {
      fscanf(inFile,"%d ", &ParBlk.LayerCoding[i*SeqHdr.Layers+n]);
    }
  }


  fscanf(inFile,"IPreset: ");
  for (n=0; n<SeqHdr.Layers-1; n++) 
      fscanf(inFile,"%d, ", &SeqHdr.IPreset[n]);
  fscanf(inFile,"%d\n", &SeqHdr.IPreset[n]);

  fscanf(inFile,"PPreset: ");
  for (n=0; n<SeqHdr.Layers-1; n++) 
      fscanf(inFile,"%d, ", &SeqHdr.PPreset[n]);
  fscanf(inFile,"%d\n", &SeqHdr.PPreset[n]);

  fscanf(inFile,"BPreset: ");
  for (n=0; n<SeqHdr.Layers-1; n++) 
      fscanf(inFile,"%d, ", &SeqHdr.BPreset[n]);
  fscanf(inFile,"%d\n", &SeqHdr.BPreset[n]);


}

