#include <string.h>
#include "config.h"
#include "VLC.h"

static void InitHuffTable (VLCTree **code_table, String name, int *code, int size)
{
  (*code_table) =  NEW(VLCTree);

  if ((*code_table) == NULL)
    EXIT_WITH_ERR ("Malloc failed");
  
  sprintf((*code_table)->name,"%s",name);
  (*code_table)->size = size;
  (*code_table)->maxlength = 0;

  (*code_table)->histo = NEWELEMS(unsigned long, size);
  memset((*code_table)->histo, 0, size*sizeof(long));

  (*code_table)->HuffCode = code;

  /* printf("}; \nint %sTab[%d] = { ", name, 2*size); */
}

int MVHuffCodeTab[128] = { 5, 13, 7, 13, 5, 12, 7, 12, 9, 12, 11, 12, 13,
12, 15, 12, 9, 11, 11, 11, 13, 11, 15, 11, 17, 11, 19, 11, 21, 11, 23,
11, 25, 11, 27, 11, 29, 11, 31, 11, 33, 11, 35, 11, 19, 10, 21, 10,
23, 10, 7, 8, 9, 8, 11, 8, 7, 7, 3, 5, 3, 4, 3, 3, 1, 1, 2, 3, 2, 4,
2, 5, 6, 7, 10, 8, 8, 8, 6, 8, 22, 10, 20, 10, 18, 10, 34, 11, 32, 11,
30, 11, 28, 11, 26, 11, 24, 11, 22, 11, 20, 11, 18, 11, 16, 11, 14,
11, 12, 11, 10, 11, 8, 11, 14, 12, 12, 12, 10, 12, 8, 12, 6, 12, 4,
12, 6, 13 };

int MeanSizeHuffCodeTab[18] = { 3, 3, 2, 3, 3, 2, 2, 2, 1, 3, 1, 4, 1, 5,
1, 6, 1, 7 };

/*
int CombSignHuffCodeTab[18] = {1, 2, 3, 6, 3, 4, 2, 6, 2, 4, 1, 7, 1, 4, 1, 6, 1, 1, };


int VCombHuffCodeTab[128] = {9, 4, 11, 5, 10, 5, 7, 7, 7, 9, 9, 12, 25, 14, 24, 14, 9, 5, 8, 4, 8, 5, 7, 5, 6, 7, 7, 10, 23, 14, 22, 14, 6, 5, 5, 5, 3, 2, 7, 4, 5, 7, 6, 10, 21, 14, 20, 14, 7, 6, 4, 5, 6, 4, 5, 3, 6, 6, 5, 10, 19, 14, 18, 14, 5, 8, 4, 7, 3, 7, 5, 6, 4, 6, 6, 9, 17, 14, 16, 14, 5, 11, 4, 10, 3, 10, 5, 9, 4, 9, 4, 8, 8, 12, 15, 14, 14, 14, 13, 14, 12, 14, 11, 14, 7, 12, 10, 14, 13, 13, 9, 14, 8, 14, 7, 14, 6, 14, 5, 14, 4, 14, 3, 14, 2, 14, 1, 14, };


int VMagHuffCodeTab[16] = {3, 7, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 2, 7, 1, 7, };


int EvenSignHuffCodeTab[256] = {7, 3, 31, 8, 35, 11, 33, 9, 32, 9, 27, 12, 25, 7, 15, 6, 11, 5, 26, 12, 33, 10, 31, 9, 30, 8, 34, 11, 30, 9, 29, 9, 25, 12, 24, 7, 13, 13, 32, 10, 33, 11, 24, 12, 23, 12, 28, 9, 23, 7, 9, 4, 32, 11, 29, 8, 28, 8, 12, 13, 27, 9, 27, 8, 31, 10, 30, 10, 22, 7, 31, 11, 30, 11, 11, 13, 22, 12, 29, 10, 21, 12, 20, 12, 26, 8, 10, 13, 9, 13, 19, 12, 18, 12, 29, 11, 28, 10, 21, 7, 28, 11, 8, 4, 27, 11, 8, 13, 25, 8, 26, 9, 24, 8, 26, 11, 25, 11, 10, 5, 27, 10, 24, 11, 23, 11, 25, 9, 23, 8, 7, 13, 22, 11, 26, 10, 7, 4, 24, 9, 17, 12, 22, 8, 23, 9, 22, 9, 16, 12, 15, 12, 6, 3, 14, 12, 21, 8, 21, 9, 13, 12, 6, 13, 5, 13, 12, 12, 11, 12, 20, 8, 21, 11, 20, 11, 25, 10, 10, 12, 4, 13, 19, 11, 24, 10, 14, 6, 18, 11, 17, 11, 20, 7, 20, 9, 9, 12, 19, 7, 19, 9, 3, 13, 6, 4, 18, 7, 18, 9, 8, 12, 2, 13, 1, 13, 7, 12, 16, 11, 13, 6, 23, 10, 17, 9, 22, 10, 15, 11, 19, 8, 18, 8, 21, 10, 20, 10, 9, 5, 8, 5, 17, 7, 14, 11, 19, 10, 17, 8, 18, 10, 16, 7, 5, 3, };


int AllSignsHuffCodeTab[512] = {3, 2, 29, 8, 111, 11, 197, 12, 196, 12, 195, 12, 194, 12, 193, 12, 28, 8, 192, 12, 191, 12, 190, 12, 189, 12, 188, 12, 187, 12, 9, 5, 73, 10, 8, 5, 186, 12, 110, 11, 185, 12, 184, 12, 183, 12, 182, 12, 181, 12, 47, 9, 180, 12, 179, 12, 72, 10, 178, 12, 177, 12, 46, 9, 176, 12, 175, 12, 109, 11, 174, 12, 173, 12, 172, 12, 171, 12, 170, 12, 169, 12, 168, 12, 167, 12, 166, 12, 165, 12, 164, 12, 163, 12, 162, 12, 108, 11, 27, 8, 161, 12, 7, 5, 160, 12, 159, 12, 71, 10, 158, 12, 157, 12, 156, 12, 155, 12, 154, 12, 153, 12, 152, 12, 70, 10, 151, 12, 150, 12, 149, 12, 148, 12, 69, 10, 68, 10, 147, 12, 146, 12, 145, 12, 144, 12, 143, 12, 142, 12, 141, 12, 140, 12, 139, 12, 138, 12, 137, 12, 136, 12, 135, 12, 134, 12, 133, 12, 132, 12, 45, 9, 131, 12, 130, 12, 129, 12, 128, 12, 127, 12, 126, 12, 125, 12, 124, 12, 123, 12, 122, 12, 121, 12, 120, 12, 119, 12, 26, 8, 118, 12, 117, 12, 5, 4, 116, 12, 115, 12, 114, 12, 113, 12, 112, 12, 67, 10, 111, 12, 107, 11, 66, 10, 44, 9, 65, 10, 110, 12, 64, 10, 109, 12, 108, 12, 63, 10, 25, 8, 107, 12, 106, 12, 105, 12, 104, 12, 103, 12, 102, 12, 101, 12, 100, 12, 43, 9, 99, 12, 98, 12, 106, 11, 97, 12, 96, 12, 105, 11, 95, 12, 6, 5, 42, 9, 94, 12, 93, 12, 24, 8, 92, 12, 91, 12, 41, 9, 90, 12, 89, 12, 88, 12, 87, 12, 86, 12, 85, 12, 84, 12, 83, 12, 62, 10, 3, 3, 82, 12, 81, 12, 80, 12, 79, 12, 78, 12, 77, 12, 76, 12, 75, 12, 74, 12, 73, 12, 72, 12, 71, 12, 70, 12, 69, 12, 68, 12, 67, 12, 66, 12, 65, 12, 64, 12, 63, 12, 62, 12, 61, 12, 60, 12, 61, 10, 59, 12, 58, 12, 57, 12, 56, 12, 55, 12, 54, 12, 53, 12, 52, 12, 51, 12, 60, 10, 50, 12, 49, 12, 48, 12, 47, 12, 104, 11, 59, 10, 46, 12, 45, 12, 44, 12, 43, 12, 103, 11, 42, 12, 58, 10, 41, 12, 40, 12, 39, 12, 5, 5, 38, 12, 37, 12, 102, 11, 36, 12, 35, 12, 34, 12, 33, 12, 32, 12, 31, 12, 30, 12, 29, 12, 28, 12, 27, 12, 26, 12, 25, 12, 24, 12, 23, 12, 22, 12, 21, 12, 57, 10, 20, 12, 19, 12, 18, 12, 17, 12, 16, 12, 15, 12, 14, 12, 40, 9, 13, 12, 12, 12, 11, 12, 101, 11, 10, 12, 15, 7, 39, 9, 4, 5, 38, 9, 9, 12, 56, 10, 8, 12, 7, 12, 6, 12, 100, 11, 37, 9, 5, 12, 4, 12, 3, 12, 99, 11, 2, 12, 1, 12, 2, 2, };

int PLowPredTypeHuffCodeTab[8] = {1, 2, 1, 1, 1, 3, 1, 4, };
int PPredTypeHuffCodeTab[8] = {1, 4, 1, 3, 1, 2, 1, 1, };
*/
#include "Code.vlc"

void DefineHuffTables() {

  InitHuffTable(&VMagHuffCode,"VMagHuffCode", VMagHuffCodeTab, 8);
  InitHuffTable(&VCombHuffCode,"VCombHuffCode", VCombHuffCodeTab, 64);
  InitHuffTable(&CombSignHuffCode,"CombSignHuffCode", CombSignHuffCodeTab, 9);

  InitHuffTable(&EvenSignHuffCode,"EvenSignHuffCode", EvenSignHuffCodeTab, 128);
  InitHuffTable(&AllSignsHuffCode,"AllSignsHuffCode", AllSignsHuffCodeTab, 256);

  /* Leave motion vectors unchanged */

  InitHuffTable(&MVHuffCode,"MVHuffCode", MVHuffCodeTab, 64);
  InitHuffTable(&MeanSizeHuffCode,"MeanSizeHuffCode", MeanSizeHuffCodeTab, 9);
  InitHuffTable(&PLowPredTypeHuffCode,"PLowPredTypeHuffCode", PLowPredTypeHuffCodeTab, 4);
  InitHuffTable(&PPredTypeHuffCode,"PPredTypeHuffCode", PPredTypeHuffCodeTab, 4);

  InitHuffTable(&IntraCBPYHuffCode0,"IntraCBPY0HuffCode", IntraCBPY0HuffCodeTab, 256);
  InitHuffTable(&IntraCBPYHuffCode1,"IntraCBPY1HuffCode", IntraCBPY1HuffCodeTab, 256);

  InitHuffTable(&IntraCBPCHuffCode0,"IntraCBPC0HuffCode", IntraCBPC0HuffCodeTab, 256);
  InitHuffTable(&IntraCBPCHuffCode1,"IntraCBPC1HuffCode", IntraCBPC1HuffCodeTab, 256);

  InitHuffTable(&IntraShellCombYHuffCode0,"IntraShellCombY0HuffCode", IntraShellCombY0HuffCodeTab, 15);
  InitHuffTable(&IntraShellCombYHuffCode1,"IntraShellCombY1HuffCode", IntraShellCombY1HuffCodeTab, 15);

  InitHuffTable(&SPYClassHuffCode0,"SPYClass0HuffCode", SPYClass0HuffCodeTab, 65);
  InitHuffTable(&SPYClassHuffCode1,"SPYClass1HuffCode", SPYClass1HuffCodeTab, 65);
  InitHuffTable(&TPYClassHuffCode0,"TPYClass0HuffCode", TPYClass0HuffCodeTab, 65);
  InitHuffTable(&TPYClassHuffCode1,"TPYClass1HuffCode", TPYClass1HuffCodeTab, 65);
  InitHuffTable(&SPCClassHuffCode0,"SPCClass0HuffCode", SPCClass0HuffCodeTab, 65);
  InitHuffTable(&SPCClassHuffCode1,"SPCClass1HuffCode", SPCClass1HuffCodeTab, 65);
  InitHuffTable(&TPCClassHuffCode0,"TPCClass0HuffCode", TPCClass0HuffCodeTab, 65);
  InitHuffTable(&TPCClassHuffCode1,"TPCClass1HuffCode", TPCClass1HuffCodeTab, 65);

  InitHuffTable(&InterCBPYHuffCode0,"InterCBPY0HuffCode", InterCBPY0HuffCodeTab, 256);
  InitHuffTable(&InterCBPYHuffCode1,"InterCBPY1HuffCode", InterCBPY1HuffCodeTab, 256);
  InitHuffTable(&InterCBPCHuffCode0,"InterCBPC0HuffCode", InterCBPC0HuffCodeTab, 256);
  InitHuffTable(&InterCBPCHuffCode1,"InterCBPC1HuffCode", InterCBPC1HuffCodeTab, 256);

  InitHuffTable(&InterShellCombYHuffCode0,"InterShellCombY0HuffCode", InterShellCombY0HuffCodeTab, 15);
  InitHuffTable(&InterShellCombYHuffCode1,"InterShellCombY1HuffCode", InterShellCombY1HuffCodeTab, 15);

  InitHuffTable(&InterShellCombCHuffCode0,"InterShellCombC0HuffCode", InterShellCombC0HuffCodeTab, 15);
  InitHuffTable(&InterShellCombCHuffCode1,"InterShellCombC1HuffCode", InterShellCombC1HuffCodeTab, 15);

  InitHuffTable(&Shell1TPYHuffCode0,"Shell1TPY0HuffCode", Shell1TPY0HuffCodeTab, 120);
  InitHuffTable(&Shell1TPYHuffCode1,"Shell1TPY1HuffCode", Shell1TPY1HuffCodeTab, 120);

  InitHuffTable(&Shell1TPCHuffCode0,"Shell1TPC0HuffCode", Shell1TPC0HuffCodeTab, 120);
  InitHuffTable(&Shell1TPCHuffCode1,"Shell1TPC1HuffCode", Shell1TPC1HuffCodeTab, 120);

  InitHuffTable(&Shell2TPYHuffCode0,"Shell2TPY0HuffCode", Shell2TPY0HuffCodeTab, 800);
  InitHuffTable(&Shell2TPYHuffCode1,"Shell2TPY1HuffCode", Shell2TPY1HuffCodeTab, 800);

  InitHuffTable(&Shell2TPCHuffCode0,"Shell2TPC0HuffCode", Shell2TPC0HuffCodeTab, 800);
  InitHuffTable(&Shell2TPCHuffCode1,"Shell2TPC1HuffCode", Shell2TPC1HuffCodeTab, 800);

  InitHuffTable(&Shell2SPCHuffCode0,"Shell2SPC0HuffCode", Shell2SPC0HuffCodeTab, 800);
  InitHuffTable(&Shell2SPCHuffCode1,"Shell2SPC1HuffCode", Shell2SPC1HuffCodeTab, 800);

  InitHuffTable(&IntraShellCombCHuffCode0,"IntraShellCombC0HuffCode", IntraShellCombC0HuffCodeTab, 15);
  InitHuffTable(&IntraShellCombCHuffCode1,"IntraShellCombC1HuffCode", IntraShellCombC1HuffCodeTab, 15);

  InitHuffTable(&Shell1SPYHuffCode0,"Shell1SPY0HuffCode", Shell1SPY0HuffCodeTab, 120);
  InitHuffTable(&Shell1SPYHuffCode1,"Shell1SPY1HuffCode", Shell1SPY1HuffCodeTab, 120);

  InitHuffTable(&Shell1SPCHuffCode0,"Shell1SPC0HuffCode", Shell1SPC0HuffCodeTab, 120);
  InitHuffTable(&Shell1SPCHuffCode1,"Shell1SPC1HuffCode", Shell1SPC1HuffCodeTab, 120);

  InitHuffTable(&Shell2SPYHuffCode0,"Shell2SPY0HuffCode", Shell2SPY0HuffCodeTab, 800);
  InitHuffTable(&Shell2SPYHuffCode1,"Shell2SPY1HuffCode", Shell2SPY1HuffCodeTab, 800);

  InitHuffTable(&Shell2SPYHuffCode0,"Shell2SPY0HuffCode", Shell2SPY0HuffCodeTab, 800);
  InitHuffTable(&Shell2SPYHuffCode1,"Shell2SPY1HuffCode", Shell2SPY1HuffCodeTab, 800);
}


