#include "Util.h"
#include "Output.h"
#include "VLC.h"
#include "Image.h"
#include "Crop.h"
#include "Statistics.h"
#include "BlockCoder.h"

static void EncodeImageDPCM(ImagePtr buffer, ImagePtr decoded, int *bits)
{
  int i, j;
  int w;
  Byte *s;
  int p1, p2, p3, p;

  *bits = 0;

  w = buffer->w;
  s = buffer->data;

  p1 = 128;

  for (i=0; i<w; i++) {
    CodeIntraMean(s[i], &p1);
    decoded->data[i] = s[i];
  } 

  for (j=1; j<buffer->h; j++) {
    p1 = decoded->data[(j-1)*w];
    CodeIntraMean(s[j*w], &p1);
    decoded->data[j*w] = s[j*w];
    for (i=1; i<w; i++) {
      p1=decoded->data[(j-1)*w+i-1];
      p2=decoded->data[(j-1)*w+i];
      p3=decoded->data[j*w+i-1];
      p = ROUND( ((-2*p1) + (3*p2) + (3*p3)) / 4.0);
      CodeIntraMean(s[j*w+i], &p);
      decoded->data[j*w+i] = s[j*w+i];
    }
  }
}

static void EncodeImageDPCMChrom(ImagePtr buffer, ImagePtr decoded, int *bits)
{
  int i, j;
  int w;
  Byte *s;
  int p1, p2, p3, p;

  *bits = 0;

  w = buffer->w;
  s = buffer->data;

  p1 = 128;

  for (i=0; i<w; i++) {
    CodeIntraMean(s[i], &p1);
    decoded->data[i] = s[i];
  } 

  for (j=1; j<buffer->h; j++) {
    p1 = decoded->data[(j-1)*w];
    CodeIntraMean(s[j*w], &p1);
    decoded->data[j*w] = s[j*w];
    for (i=1; i<w; i++) {
      p1=decoded->data[(j-1)*w+i-1];
      p2=decoded->data[(j-1)*w+i];
      p3=decoded->data[j*w+i-1];
      p = ROUND( ((-1*p1) + (2*p2) + (1*p3)) / 2.0);
      CodeIntraMean(s[j*w+i], &p);
      decoded->data[j*w+i] = s[j*w+i];
    }
  }
}
/* ****************************************************************************** */

void EncodeFrameDPCM(FramePtr Actual, FramePtr Decoded) {
  int UsedBits;

  SMStartBlock(0);
  EncodeImageDPCM(Actual->Y, Decoded->Y, &UsedBits); 
  SMIncrementResidBitCount(UsedBits); 
  SMStartBlock(1);
  EncodeImageDPCM(Actual->U, Decoded->U, &UsedBits);
  SMIncrementResidBitCount(UsedBits); 
  SMStartBlock(2);
  EncodeImageDPCM(Actual->V, Decoded->V, &UsedBits);
  SMIncrementResidBitCount(UsedBits); 
}
/* ****************************************************************************** */
