#ifndef _IMAGE_
#define _IMAGE_

#include "DataTypes.h"
#include "Util.h"

typedef struct {
  Byte *data;
  int ow, oh;
  int w,h;
  long size;
} ImageStruct;

typedef ImageStruct *ImagePtr;

typedef struct { 
  int TempRef;
  int SeqIndex;
  ImagePtr Y;
  ImagePtr U;
  ImagePtr V;
} FrameStruct;

typedef FrameStruct *FramePtr;

typedef struct {
  int size;
  int LowestLayer;
  FramePtr *Layer;
} PyramidStruct;

typedef PyramidStruct *PyramidPtr;

ImagePtr NewImage(int w, int h);
FramePtr NewFrame(int w, int h);
void DeleteFrame(FramePtr frame);

PyramidPtr NewPyramid(int w, int h, int size);


void GetMB(FramePtr frame, int x, int y, int size, int *ydata, int *udata, int *vdata);
void PutMB(FramePtr frame, int x, int y, int size, int *ydata, int *udata, int *vdata);
void GetTranslatedMB (FramePtr frame, int x, int y, int fx, int fy, int size, int *ydata, int *udata, int *vdata);

GLOBAL int gprint_on;

void PrintIntBlock(int *data, char *comm, int n, int size);
void PrintFloatBlock(double *data, char *comm, int n, int size);

#endif
