#ifndef _LATTICE_
#define _LATTICE_


typedef double VECTOR[8];
typedef unsigned char INDEX[8];

int LatticePointGN (VECTOR x);
int GroupIndex (VECTOR x, int gn);
void ApplySymmetry(VECTOR x, VECTOR y, int type, int polarity);
void NearestE8LatticePoint (VECTOR v, VECTOR z);
void NearestE8LatticePoint16(double x[8], double y[8]);
int l2_norm (VECTOR x);
int l1_norm (VECTOR x);
double ScalarMul(VECTOR x, VECTOR y);
void Point2Index (VECTOR x, INDEX z, int r);
void Index2Point (INDEX i, VECTOR x, int r);
int FindSymmetry(VECTOR x);
#endif
