#include "Util.h"

#ifndef _MOTION_
#define _MOTION_

typedef struct {

  int ActTempRef;
  int RefTempRef;
  int layer;
  int width;
  int height;
  int size;
  int bw;
  int bh;

  short *Mode;
  short *SXComp;
  short *SYComp;
  short *XComp;
  short *YComp;

} MVFieldStruct;

typedef MVFieldStruct *MVFieldPtr;

typedef struct  {

  MVFieldPtr Layer[8];

} MultiScaleFieldStruct;

typedef MultiScaleFieldStruct *MultiScaleFieldPtr;

#endif

GLOBAL MultiScaleFieldPtr ActFwdMV;
GLOBAL unsigned long MEstiBits;

MultiScaleFieldPtr NewVectorField ();
void FreeVectorField (MultiScaleFieldPtr field1, MultiScaleFieldPtr field2);

void GetMotionVector (MVFieldPtr mv, int i, int j, int *sx, int *sy, int *x, int *y, int *mode);
void SetMotionVector (MVFieldPtr mv, int i, int j, int x, int y, int mode);
void DumpFwdX();
void DumpFwdY();
void PrintMV(MVFieldPtr mv);

void InterpolateMVField (MVFieldPtr in, MVFieldPtr out, int scaling);
void InterpolateMVField2 (MVFieldPtr in, MVFieldPtr out, int inRefTempRef, int inActTempRef, int outRefTempRef, int outActTempRef, int fullpel);

void ResetMVPredictor();
void CodeFXComponent (int x);
void CodeFYComponent (int y);
void CodeFXRefineComponent (int x);
void CodeFYRefineComponent (int y);
