#include <stdio.h>

#include "Util.h"

#ifndef _PARAMETER_
#define _PARAMETER_

typedef struct _Parameter_struct {
  char InputBase[80];
  char OutputBase[80];
  char Codebook[80];
  char Stream[80];
  int Format; /* 0: Khoros, frames; 1: Raw, frames; 2: Raw, sequence */
  int FirstFrame;
  int LastFrame;
  int N;
  int M;
  int SearchRange;
  int PyraLength;
  int *LayerCoding;

  int FwdScaling[8];
  int BakScaling[8];
  int FwdXRange[8], FwdYRange[8];
  int BakXRange[8], BakYRange[8];

} Parameter_struct;

GLOBAL Parameter_struct ParBlk;

typedef struct SequenceHeader {
  int HSize;
  int VSize;
  int BlockWidth[8];
  int BlockHeight[8];
  int XSubsamp[8];
  int YSubsamp[8];
  int IPreset[8];
  int PPreset[8];
  int BPreset[8];
  int Layers;
} SequenceHeaderStruct;

GLOBAL SequenceHeaderStruct SeqHdr;

typedef struct _PictureHeader {
  int TempRef;
  int CodingType;
} PictureHeaderStruct;

GLOBAL PictureHeaderStruct PictHdr;

typedef struct _LayerHeader {
  int Number;
  int w;
  int h;
  int FXMVSize, FYMVSize;
  int BXMVSize, BYMVSize;
  int IsLowestLayer;
  int ResiduumCoded;
  int ClassVar[3][3][3]; /* [mode][signal][Class] */
} LayerHeaderStruct;

GLOBAL LayerHeaderStruct LayerHdr;

typedef struct _BlockHeader {
  int MCMode;
  int fx, fy;
  int bx, by;
  int Coded;
} BlockHeaderStruct;

#endif

void ReadParameter (char *ParFile);
