#include "config.h"

#ifdef USE_VIS

/*
 *  VIS data types
 */

typedef float vis_s8;
typedef float vis_u8;
typedef float vis_s16;
typedef float vis_u16;
typedef float vis_u32;
typedef float vis_s32;
typedef float vis_f32;
typedef double vis_d64;

/*
 *  VIS prototypes
 */

extern int vis_read_gsr();
extern void vis_write_gsr(int);
extern vis_f32 vis_read_lo(vis_d64);
extern vis_f32 vis_read_hi(vis_d64);
extern vis_d64 vis_write_lo(vis_d64,vis_f32);
extern vis_d64 vis_write_hi(vis_d64,vis_f32);
extern vis_d64 vis_freg_pair(vis_f32,vis_f32);
extern vis_f32 vis_to_float(int);
extern vis_d64 vis_to_double(int,int);
extern vis_d64 vis_to_double_dup(int);
/* extensions */
#define vis_to_double_quad(x) vis_to_double_dup(((x)<<16)|(x))
extern long vis_from_float(vis_f32);
extern long long vis_from_double(vis_d64);
extern vis_d64 vis_ld64(void *);
extern void vis_st64(vis_d64,void *);
extern void vis_st64_pack2(vis_d64,vis_d64,void *);
extern vis_d64 vis_hi2lo(vis_d64);
extern vis_d64 vis_lo2hi(vis_d64);

extern vis_d64 vis_fsrc(vis_d64);
extern vis_d64 vis_fzero();
extern vis_d64 vis_fone();
extern vis_d64 vis_for(vis_d64,vis_d64);
extern vis_d64 vis_fand(vis_d64,vis_d64);
extern vis_d64 vis_fxor(vis_d64,vis_d64);
extern vis_d64 vis_fnor(vis_d64,vis_d64);
extern vis_d64 vis_fnand(vis_d64,vis_d64);
extern vis_d64 vis_fxnor(vis_d64,vis_d64);
extern vis_d64 vis_fornot(vis_d64,vis_d64);
extern vis_d64 vis_fandnot(vis_d64,vis_d64);

extern vis_s32 vis_fsrcs(vis_s32);
extern vis_f32 vis_fzeros();
extern vis_f32 vis_fones();
extern vis_f32 vis_fors(vis_f32,vis_f32);
extern vis_f32 vis_fands(vis_f32,vis_f32);
extern vis_f32 vis_fxors(vis_f32,vis_f32);
extern vis_f32 vis_fnors(vis_f32,vis_f32);
extern vis_f32 vis_fnands(vis_f32,vis_f32);
extern vis_f32 vis_fxnors(vis_f32,vis_f32);
extern vis_f32 vis_fornots(vis_f32,vis_f32);
extern vis_f32 vis_fandnots(vis_f32,vis_f32);


extern vis_d64 vis_fpadd16(vis_d64,vis_d64);
extern vis_d64 vis_fpadd32(vis_d64,vis_d64);
extern vis_d64 vis_fpsub16(vis_d64,vis_d64);
extern vis_d64 vis_fpsub32(vis_d64,vis_d64);

extern vis_f32 vis_fpadd16s(vis_f32,vis_f32);
extern vis_f32 vis_fpadd32s(vis_f32,vis_f32);
extern vis_f32 vis_fpsub16s(vis_f32,vis_f32);
extern vis_f32 vis_fpsub32s(vis_f32,vis_f32);


extern int vis_fcmpgt16(vis_d64,vis_d64);
extern int vis_fcmpge16(vis_d64,vis_d64);
extern int vis_fcmplt16(vis_d64,vis_d64);
extern int vis_fcmple16(vis_d64,vis_d64);
extern int vis_fcmpne16(vis_d64,vis_d64);
extern int vis_fcmpeq16(vis_d64,vis_d64);

extern int vis_fcmpgt32(vis_d64,vis_d64);
extern int vis_fcmpge32(vis_d64,vis_d64);
extern int vis_fcmplt32(vis_d64,vis_d64);
extern int vis_fcmple32(vis_d64,vis_d64);
extern int vis_fcmpne32(vis_d64,vis_d64);
extern int vis_fcmpeq32(vis_d64,vis_d64);

extern vis_d64 vis_fmul8x16(vis_f32,vis_d64);
extern vis_d64 vis_fmul8x16au(vis_f32,vis_f32);
extern vis_d64 vis_fmul8x16al(vis_f32,vis_f32);
extern vis_d64 vis_fmul8sux16(vis_d64,vis_d64);
extern vis_d64 vis_fmul8ulx16(vis_d64,vis_d64);
extern vis_d64 vis_fmuld8sux16(vis_f32,vis_f32);
extern vis_d64 vis_fmuld8ulx16(vis_f32,vis_f32);
/* extensions */
extern vis_d64 vis_fmul16x16(vis_d64,vis_d64);
extern vis_d64 vis_fmul8x16_lo(vis_d64,vis_d64);
extern vis_d64 vis_fmul8x16_hi(vis_d64,vis_d64);
extern vis_d64 vis_fmul8x16au_lo(vis_d64,vis_f32);
extern vis_d64 vis_fmul8x16au_hi(vis_d64,vis_f32);
extern vis_d64 vis_fmul8x16al_lo(vis_d64,vis_f32);
extern vis_d64 vis_fmul8x16al_hi(vis_d64,vis_f32);

extern vis_f32 vis_fpack16(vis_d64);
extern vis_d64 vis_fpack32(vis_d64,vis_d64);
extern vis_f32 vis_fpackfix(vis_d64);
extern vis_d64 vis_fexpand(vis_f32);
extern vis_d64 vis_fpmerge(vis_f32,vis_f32);
/* extensions */
extern vis_d64 vis_fpack16_2(vis_d64,vis_d64);
extern vis_d64 vis_fpmerge_hi(vis_d64,vis_d64);
extern vis_d64 vis_fpmerge_lo(vis_d64,vis_d64);
extern vis_d64 vis_fexpand_hi(vis_d64);
extern vis_d64 vis_fexpand_lo(vis_d64);

extern void *vis_alignaddr(void *,int);
extern vis_d64 vis_faligndata(vis_d64,vis_d64);
extern int vis_edge8(void *,void *);
extern int vis_edge16(void *,void *);
extern int vis_edge32(void *,void *);
extern void vis_pst_8(vis_d64,void *, int);
extern void vis_pst_16(vis_d64,void *, int);
extern void vis_pst_32(vis_d64,void *, int);
/* extensions */
extern void vis_alignaddr_const(int);
extern vis_d64 vis_faligndata_hi1(vis_d64,vis_d64);
extern vis_d64 vis_faligndata_lo2(vis_d64,vis_d64);
extern vis_f32 vis_faligndata_2x32(vis_f32,vis_f32);

extern void vis_st_u8(vis_d64,void *);
extern void vis_st_u8_i(vis_d64,void *,int);
extern void vis_st_u16(vis_d64,void *);
extern void vis_st_u16_i(vis_d64,void *,int);
extern vis_d64 vis_ld_u8(void *);
extern vis_d64 vis_ld_u8_i(void *,int);
extern vis_d64 vis_ld_u16(void *);
extern vis_d64 vis_ld_u16_i(void *,int);

extern vis_d64 vis_pdist(vis_d64,vis_d64,vis_d64);

#endif
