#define DEFINE_GLOBALS

#include "VLC.h"
#include "CodeSymbol.h"
#include "Parameter.h"
#include "Statistics.h"
#include "Motion.h"
#include "Crop.h"
#include "Headers.h"
#include "Buffers.h"
#include "Output.h"
#include "Filter.h"
#include "KhorosIO.h"
#include "Syntax.h"

#include "config.h"

#define NORMAL
/* #define RAW */
/* #define USE_STARTFRAME */

/* #define SINGLELAYER */
#define TWOLAYER
/* #define THREELAYER */

/* #define DOUBLECIF */

unsigned long layerBits[4] = { 0, 0, 0, 0 };

extern void Read263MVField(MVFieldPtr mv, char *name, int pos);
extern void CodeIFrame (PyramidPtr Actual, PyramidPtr Decoded, int TempRef, int start, int end);
extern void CodePFrame (PyramidPtr Actual, PyramidPtr Decoded, PyramidPtr RefRec, PyramidPtr RefOrig, PyramidPtr MotComp, MultiScaleFieldPtr mv, int TempRef, int start, int end);

int FrameNr;

static void CoderLoop()

{
  FramePtr FrameToCode, InputFrame, FilteredFrame;
  int w,h;
  int FramesToCode, FrameIndex;

  switch (ParBlk.Format) {
  case 0:
    GetKhorosYImagefileDimensions(ParBlk.InputBase, ParBlk.FirstFrame, &w, &h);
    break;
  case 1:
  case 2:
  case 3:
    w = SeqHdr.HSize; h = SeqHdr.VSize;
    break;
  default:
    FATAL("Unknown sequence format");
    break;
  }

  FrameToCode = NewFrame(w, h);
  FramesToCode = ParBlk.LastFrame - ParBlk.FirstFrame + 1;

  SMInit(); /* Initialize Statistic Module */

  fprintf(stderr,"%s\n", ParBlk.InputBase);

  /* Search range for motion estimation */
#ifdef SINGLELAYER
  ParBlk.FwdXRange[1] = 21; ParBlk.FwdYRange[1] = 21;
#endif
#ifdef TWOLAYER
  ParBlk.FwdXRange[1] = 7; ParBlk.FwdYRange[1] = 7;
  ParBlk.FwdXRange[0] = 4; ParBlk.FwdYRange[0] = 4;
#endif
#ifdef THREELAYER
  ParBlk.FwdXRange[2] = 7; ParBlk.FwdYRange[2] = 7;
  ParBlk.FwdXRange[1] = 3; ParBlk.FwdYRange[1] = 3;
  ParBlk.FwdXRange[0] = 3; ParBlk.FwdYRange[0] = 3;
#endif

  EmitSyncCode (SEQUENCE_START_CODE);
  CodeSequenceHeader();

  FrameIndex = 0;
  FrameNr = ParBlk.FirstFrame + FrameIndex;

  switch(ParBlk.Format) {
  case 0:
    ReadYUVKhorosFormat(ParBlk.InputBase, FrameNr, FrameToCode); 
    break;
  case 1:
    ReadYUVRawFrameFormat(ParBlk.InputBase, FrameNr, FrameToCode); 
    break;
  case 2:
    ReadYUVRawSeqFormat(ParBlk.InputBase, 1152, FrameNr, FrameToCode); 
    break;
  case 3:
    ReadYUVRawStreamFormat(ParBlk.InputBase, FrameToCode); 
    break;
  }

  FrameToCode->TempRef = FrameIndex; FrameToCode->SeqIndex = FrameNr;
  FrameToBuffer(FrameToCode, 0);

#ifdef SINGLELAYER
  CodeIFrame (FrameBuffer[0], PastDecoded, FrameIndex, 1, 0); 
#endif
#ifdef TWOLAYER
  CodeIFrame (FrameBuffer[0], PastDecoded, FrameIndex, 3, 0);
#endif
#ifdef THREELAYER
  CodeIFrame (FrameBuffer[0], PastDecoded, FrameIndex, 3, 0); 
#endif

#ifdef FAST_ME
  mkSNorm(FrameBuffer[0]->Layer[0],refNorm[0]);
  mkSNorm(FrameBuffer[0]->Layer[1],refNorm[1]);
#endif

 LOOP:
  for (FrameIndex=1; FrameIndex<FramesToCode; FrameIndex+=1) { 

    /* First frame (only lowest layer) */
    FrameNr = ParBlk.FirstFrame + FrameIndex;

    switch(ParBlk.Format) {
    case 0:
      ReadYUVKhorosFormat(ParBlk.InputBase, FrameNr, FrameToCode); 
      break;
    case 1:
      ReadYUVRawFrameFormat(ParBlk.InputBase, FrameNr, FrameToCode); 
      break;
    case 2:
      ReadYUVRawSeqFormat(ParBlk.InputBase, 1152, FrameNr, FrameToCode); 
      break;
    case 3:
      ReadYUVRawStreamFormat(ParBlk.InputBase, FrameToCode); 
      break;
    }

    FrameToCode->TempRef = FrameIndex; FrameToCode->SeqIndex = FrameNr;
    FrameToBuffer(FrameToCode, 2);

#ifdef SINGLELAYER
  CodePFrame(FrameBuffer[2],FutrDecoded, PastDecoded, FrameBuffer[0], FutrSPInter, ActFwdMV, FrameIndex, 0, 0);
#endif
#ifdef TWOLAYER
  /* CodeIFrame (FrameBuffer[0], PastDecoded, FrameIndex, 3, 0); */

  if ( (FrameIndex%2)==0 ) {
    CodePFrame(FrameBuffer[2],FutrDecoded, PastDecoded, FrameBuffer[0], FutrSPInter, ActFwdMV, FrameIndex, 1, 0); 
    FutureLayerRefToPast(1);
    FutureLayerRefToPast(0);
  } else {
    ParBlk.FwdXRange[0] = 7; ParBlk.FwdYRange[0] = 7;
    CodePFrame(FrameBuffer[2],FutrDecoded, PastDecoded, FrameBuffer[0], FutrSPInter, ActFwdMV, FrameIndex, 0, 0); 
    FutureLayerRefToPast(0);
    ParBlk.FwdXRange[0] = 4; ParBlk.FwdYRange[0] = 4;
  }

#endif
#ifdef THREELAYER
  CodePFrame(FrameBuffer[2],FutrDecoded, PastDecoded, FrameBuffer[0], FutrSPInter, ActFwdMV, FrameIndex, 2, 0);
  FutureLayerRefToPast(2);
  FutureLayerRefToPast(1);
  FutureLayerRefToPast(0);
#endif
  }

  EmitSyncCode (SEQUENCE_END_CODE); 
}

int main(int argc, char *argv[])
{
  double y[8];

  /* NearestE8LatticePoint(testv, y); */

  GlobalBitCount = 0;

  ResetSequenceHeader();
  ReadParameter(argv[1]);
  SetupCropTable();
  InitInterpolator();
  DefineHuffTables();
  SetupExtVectTables();
#ifdef PCODE
  InitPCodeTables();
#endif
  AddAllTrees();
  InitBuffers();

  ActFwdMV = NewVectorField();

  InitTraining();
  ResetTrainset();
  ResetHistograms();

  /* OpenProtFile("cvar"); */
  OpenOutputBitstream(ParBlk.Stream,8000);
  InitMVHist();
  CoderLoop();
  CloseOutputBitstream();
  /* CloseProtFile(); */

  PrintMVHist();
  PrintHistograms();
#ifdef SAVE_TRAINED_CODEBOOKS
  ComputeCentroids();
#endif
  PrintIndexHist();
  return(0);
}
